/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsGroup;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolManager<T extends Tool> {
    private final SchemeManager<ToolsGroup<T>> mySchemeManager;

    public BaseToolManager(@NotNull SchemeManagerFactory factory2, @NotNull String schemePath, @NotNull String presentableName) {
        this.mySchemeManager = factory2.create(schemePath, this.createProcessor(), presentableName);
        this.mySchemeManager.loadSchemes();
    }

    protected abstract SchemeProcessor<ToolsGroup<T>, ToolsGroup<T>> createProcessor();

    @Nullable
    protected ActionManagerEx getActionManager() {
        return ActionManagerEx.getInstanceEx();
    }

    @Nullable
    public static String convertString(String s) {
        return StringUtil.nullize((String)s, (boolean)true);
    }

    public List<T> getTools() {
        SmartList result2 = new SmartList();
        for (ToolsGroup<T> group : this.mySchemeManager.getAllSchemes()) {
            result2.addAll(group.getElements());
        }
        return result2;
    }

    @NotNull
    public List<T> getTools(@NotNull String group) {
        ToolsGroup<T> groupByName = this.mySchemeManager.findSchemeByName(group);
        if (groupByName == null) {
            return Collections.emptyList();
        }
        return groupByName.getElements();
    }

    public List<ToolsGroup<T>> getGroups() {
        return this.mySchemeManager.getAllSchemes();
    }

    public void setTools(@NotNull List<ToolsGroup<T>> tools) {
        this.mySchemeManager.setSchemes(tools);
        this.registerActions((ActionManager)this.getActionManager());
    }

    protected final void registerActions(@Nullable ActionManager actionManager) {
        if (actionManager == null) {
            return;
        }
        this.unregisterActions(actionManager);
        THashSet registeredIds = new THashSet();
        for (Tool tool : this.getTools()) {
            String actionId = tool.getActionId();
            if (!registeredIds.add(actionId)) continue;
            actionManager.registerAction(actionId, (AnAction)this.createToolAction(tool));
        }
    }

    @NotNull
    protected ToolAction createToolAction(@NotNull T tool) {
        return new ToolAction((Tool)tool);
    }

    protected abstract String getActionIdPrefix();

    protected void unregisterActions(@Nullable ActionManager actionManager) {
        if (actionManager == null) {
            return;
        }
        for (String oldId : actionManager.getActionIds(this.getActionIdPrefix())) {
            actionManager.unregisterAction(oldId);
        }
    }
}

