/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalWidget;
import com.jediterm.terminal.ui.TerminalPanel;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalEscapeKeyListener {
    private final TerminalPanel myTerminalPanel;
    private final AnAction myTerminalSwitchFocusToEditorAction;
    private boolean myShortcutPressed = false;

    public TerminalEscapeKeyListener(@NotNull TerminalPanel terminalPanel) {
        this.myTerminalPanel = terminalPanel;
        this.myTerminalSwitchFocusToEditorAction = ActionManager.getInstance().getAction("Terminal.SwitchFocusToEditor");
    }

    public void handleKeyEvent(@NotNull KeyEvent e) {
        if (e.getID() == 401) {
            this.myShortcutPressed = this.isMatched(e);
        } else if (e.getID() == 402) {
            if (this.myShortcutPressed && this.isMatched(e)) {
                this.switchFocusToEditorIfSuitable();
            }
            this.myShortcutPressed = false;
        }
    }

    private boolean isMatched(@NotNull KeyEvent e) {
        KeyStroke stroke = this.getKeyStroke();
        return stroke != null && stroke.getKeyCode() == e.getKeyCode() && stroke.getModifiers() == (e.getModifiers() | e.getModifiersEx());
    }

    @Nullable
    private KeyStroke getKeyStroke() {
        if (this.myTerminalSwitchFocusToEditorAction == null) {
            return null;
        }
        return KeymapUtil.getKeyStroke((ShortcutSet)this.myTerminalSwitchFocusToEditorAction.getShortcutSet());
    }

    private void switchFocusToEditorIfSuitable() {
        DataContext dataContext;
        Project project;
        if (!this.myTerminalPanel.getTerminalTextBuffer().isUsingAlternateBuffer() && (project = (Project)(dataContext = DataManager.getInstance().getDataContext((Component)this.myTerminalPanel)).getData(CommonDataKeys.PROJECT)) != null && !project.isDisposed()) {
            if (JBTerminalWidget.isInTerminalToolWindow(dataContext) && !Registry.is((String)"terminal.escape.moves.focus.to.editor")) {
                return;
            }
            ToolWindowManager.getInstance((Project)project).activateEditorComponent();
        }
    }
}

