/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class ProjectViewContextProvider
extends WorkingContextProvider {
    ProjectViewContextProvider() {
    }

    @NotNull
    public String getId() {
        return "projectView";
    }

    @NotNull
    public String getDescription() {
        return "Project view state";
    }

    public void saveContext(@NotNull Project project, @NotNull Element toElement) throws WriteExternalException {
        for (AbstractProjectViewPane pane2 : AbstractProjectViewPane.EP.getExtensions((AreaInstance)project)) {
            Element paneElement = new Element(pane2.getId());
            pane2.writeExternal(paneElement);
            toElement.addContent(paneElement);
        }
    }

    public void loadContext(@NotNull Project project, @NotNull Element fromElement) throws InvalidDataException {
        for (AbstractProjectViewPane pane2 : AbstractProjectViewPane.EP.getExtensions((AreaInstance)project)) {
            Element paneElement = fromElement.getChild(pane2.getId());
            if (paneElement == null) continue;
            pane2.readExternal(paneElement);
            if (pane2.getTree() == null) continue;
            pane2.restoreExpandedPaths();
        }
    }

    public void clearContext(@NotNull Project project) {
        for (AbstractProjectViewPane pane2 : AbstractProjectViewPane.EP.getExtensions((AreaInstance)project)) {
            JTree tree = pane2.getTree();
            if (tree == null) continue;
            TreeUtil.collapseAll((JTree)tree, (int)0);
        }
    }
}

