/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.BranchChangeListener;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.context.ConfigureBranchContextDialog;
import com.intellij.tasks.context.WorkingContextManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BranchContextTracker
implements BranchChangeListener {
    public static final NotificationGroup NOTIFICATION = new NotificationGroup("Branch Context group", NotificationDisplayType.BALLOON, true);
    private final Project myProject;
    private String myLastBranch;

    public BranchContextTracker(@NotNull Project project) {
        this.myProject = project;
    }

    private WorkingContextManager getContextManager() {
        return WorkingContextManager.getInstance(this.myProject);
    }

    public void branchWillChange(@NotNull String branchName) {
        this.myLastBranch = branchName;
        this.getContextManager().saveContext(BranchContextTracker.getContextName(branchName), null);
    }

    public void branchHasChanged(@NotNull String branchName) {
        LocalTask task2;
        List branches;
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (!vcsConfiguration.RELOAD_CONTEXT) {
            return;
        }
        TaskManager manager = TaskManager.getManager((Project)this.myProject);
        if (manager != null && (branches = (task2 = manager.getActiveTask()).getBranches(false)).stream().anyMatch(info -> branchName.equals(info.name))) {
            return;
        }
        String contextName = BranchContextTracker.getContextName(branchName);
        if (!this.getContextManager().hasContext(contextName)) {
            return;
        }
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> this.switchContext(branchName, contextName));
    }

    private void switchContext(@NotNull String branchName, String contextName) {
        final WorkingContextManager contextManager = this.getContextManager();
        contextManager.clearContext();
        contextManager.loadContext(contextName);
        Notification notification = NOTIFICATION.createNotification(TaskBundle.message("workspace.associated.with.branch.has.been.restored", branchName), NotificationType.INFORMATION);
        if (this.myLastBranch != null && contextManager.hasContext(BranchContextTracker.getContextName(this.myLastBranch))) {
            notification.addAction((AnAction)new NotificationAction(TaskBundle.messagePointer("action.Anonymous.text.rollback", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    contextManager.clearContext();
                    contextManager.loadContext(BranchContextTracker.getContextName(BranchContextTracker.this.myLastBranch));
                }
            });
        }
        notification.addAction((AnAction)new NotificationAction(TaskBundle.messagePointer("action.Anonymous.text.configure.tree.dots", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                new ConfigureBranchContextDialog(BranchContextTracker.this.myProject).show();
            }
        }).setContextHelpAction(new AnAction(TaskBundle.messagePointer("action.BranchContextTracker.Anonymous.text.what.is.a.workspace", new Object[0]), TaskBundle.messagePointer("action.BranchContextTracker.Anonymous.description", new Object[0]), null){

            public void actionPerformed(@NotNull AnActionEvent e) {
            }
        }).notify(this.myProject);
    }

    @NotNull
    private static String getContextName(String branchName) {
        return "__branch_context_" + branchName;
    }
}

