/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class SliceLeafValueRootNode
extends SliceNode
implements MyColoredTreeCellRenderer {
    public final List<SliceNode> myCachedChildren;

    public SliceLeafValueRootNode(@NotNull Project project, @NotNull SliceNode root, @NotNull SliceUsage sliceUsage, @NotNull List<SliceNode> children2) {
        super(project, sliceUsage, root.targetEqualUsages);
        this.myCachedChildren = children2;
    }

    @Override
    @NotNull
    public Collection<SliceNode> getChildren() {
        return this.myCachedChildren;
    }

    @Override
    public List<SliceNode> getCachedChildren() {
        return this.myCachedChildren;
    }

    @Override
    protected void update(@NotNull PresentationData presentation2) {
    }

    @Override
    public String toString() {
        return this.getNodeText();
    }

    @Override
    public String getNodeText() {
        PsiElement element2;
        SliceUsage value2 = (SliceUsage)((Object)this.getValue());
        String text = value2 != null ? ((element2 = value2.getUsageInfo().getElement()) == null ? "" : element2.getText()) : "Other";
        return "Value: " + text;
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer, @NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SliceUsage usage = (SliceUsage)((Object)this.getValue());
        renderer.append("Value: ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (usage != null) {
            PsiElement element2 = usage.getElement();
            if (element2 == null) {
                renderer.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SliceUsageCellRendererBase.ourInvalidAttributes);
            } else {
                SliceLeafValueRootNode.appendElementText(usage, element2, renderer);
            }
        } else {
            renderer.append("Other", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    private static void appendElementText(@NotNull UsageInfo2UsageAdapter usage, @NotNull PsiElement element2, @NotNull SliceUsageCellRendererBase renderer) {
        PsiFile file2 = element2.getContainingFile();
        ArrayList result2 = new ArrayList();
        ChunkExtractor.getExtractor((PsiFile)element2.getContainingFile()).createTextChunks(usage, (CharSequence)file2.getText(), element2.getTextRange().getStartOffset(), element2.getTextRange().getEndOffset(), false, result2);
        for (TextChunk chunk : result2) {
            renderer.append(chunk.getText(), chunk.getSimpleAttributesIgnoreBackground());
        }
    }
}

