/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui.tree.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.impl.runtime.ui.DefaultRemoteServersServiceViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersServiceViewContributor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddCloudConnectionActionGroup
extends ActionGroup {
    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        List serverTypes = ContainerUtil.filter((Collection)ServerType.EP_NAME.getExtensionList(), type -> type.getCustomToolWindowId() == null && type.createDefaultConfiguration().getCustomToolWindowId() == null);
        AnAction[] actions = new AnAction[serverTypes.size()];
        for (int i2 = 0; i2 < serverTypes.size(); ++i2) {
            actions[i2] = new AddCloudConnectionAction((ServerType)serverTypes.get(i2));
        }
        return actions;
    }

    private static class AddCloudConnectionAction
    extends DumbAwareAction {
        private final ServerType<?> myServerType;

        AddCloudConnectionAction(ServerType<?> serverType) {
            super(serverType.getPresentableName(), String.format("Add %s connection", serverType.getPresentableName()), serverType.getIcon());
            this.myServerType = serverType;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e.getPlace().equals("GoToAction")) {
                e.getPresentation().setText(CloudBundle.messagePointer((String)"new.cloud.connection.configurable.title", (Object[])new Object[]{this.myServerType.getPresentableName()}));
            } else {
                e.getPresentation().setText(this.myServerType.getPresentableName());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            RemoteServersServiceViewContributor.addNewRemoteServer(project, this.myServerType, DefaultRemoteServersServiceViewContributor.class);
        }
    }
}

