/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.impl.runtime.log.CloudTerminalProvider;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.runtime.log.TerminalHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentLogManagerImpl
implements DeploymentLogManager {
    private final LoggingHandlerImpl myMainLoggingHandler;
    private final Project myProject;
    private final List<LoggingHandlerBase> myAdditionalLoggingHandlers = new ArrayList<LoggingHandlerBase>();
    private final Runnable myChangeListener;
    private final AtomicBoolean myLogsDisposed = new AtomicBoolean(false);
    private final Disposable myLogsDisposable;
    private boolean myMainHandlerVisible = false;

    public DeploymentLogManagerImpl(@NotNull Project project, @NotNull Runnable changeListener) {
        this.myProject = project;
        this.myChangeListener = changeListener;
        this.myMainLoggingHandler = new LoggingHandlerImpl.Colored(null, project);
        this.myLogsDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myLogsDisposable, (Disposable)this.myMainLoggingHandler);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                DeploymentLogManagerImpl.this.disposeLogs();
            }
        });
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public DeploymentLogManagerImpl withMainHandlerVisible(boolean mainHandlerVisible) {
        this.myMainHandlerVisible = mainHandlerVisible;
        return this;
    }

    public boolean isMainHandlerVisible() {
        return this.myMainHandlerVisible;
    }

    @NotNull
    public LoggingHandlerImpl getMainLoggingHandler() {
        return this.myMainLoggingHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LoggingHandler addAdditionalLog(@NotNull String presentableName) {
        AtomicBoolean atomicBoolean = this.myLogsDisposed;
        synchronized (atomicBoolean) {
            if (this.myLogsDisposed.get()) {
                throw new IllegalStateException("Already disposed, can't add " + presentableName);
            }
            LoggingHandlerImpl.Colored handler2 = new LoggingHandlerImpl.Colored(presentableName, this.myProject);
            this.addAdditionalLoggingHandler(handler2);
            return handler2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdditionalLog(@NotNull String presentableName) {
        List<LoggingHandlerBase> list2 = this.myAdditionalLoggingHandlers;
        synchronized (list2) {
            this.myAdditionalLoggingHandlers.removeIf(next -> presentableName.equals(next.getPresentableName()));
        }
        this.myChangeListener.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LoggingHandler findOrCreateAdditionalLog(@NotNull String presentableName) {
        List<LoggingHandlerBase> list2 = this.myAdditionalLoggingHandlers;
        synchronized (list2) {
            for (LoggingHandlerBase next : this.myAdditionalLoggingHandlers) {
                if (!(next instanceof LoggingHandler) || !presentableName.equals(next.getPresentableName())) continue;
                return (LoggingHandler)next;
            }
            return this.addAdditionalLog(presentableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TerminalHandler addTerminal(@NotNull String presentableName, InputStream terminalOutput, OutputStream terminalInput) {
        AtomicBoolean atomicBoolean = this.myLogsDisposed;
        synchronized (atomicBoolean) {
            if (this.myLogsDisposed.get()) {
                return null;
            }
            TerminalHandlerBase handler2 = CloudTerminalProvider.getInstance().createTerminal(presentableName, this.myProject, terminalOutput, terminalInput);
            this.addAdditionalLoggingHandler(handler2);
            return handler2;
        }
    }

    public boolean isTtySupported() {
        return CloudTerminalProvider.getInstance().isTtySupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAdditionalLoggingHandler(LoggingHandlerBase loggingHandler) {
        Disposer.register((Disposable)this.myLogsDisposable, (Disposable)loggingHandler);
        List<LoggingHandlerBase> list2 = this.myAdditionalLoggingHandlers;
        synchronized (list2) {
            this.myAdditionalLoggingHandlers.add(loggingHandler);
        }
        this.myChangeListener.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LoggingHandlerBase> getAdditionalLoggingHandlers() {
        ArrayList<LoggingHandlerBase> result2;
        List<LoggingHandlerBase> list2 = this.myAdditionalLoggingHandlers;
        synchronized (list2) {
            result2 = new ArrayList<LoggingHandlerBase>(this.myAdditionalLoggingHandlers);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeLogs() {
        AtomicBoolean atomicBoolean = this.myLogsDisposed;
        synchronized (atomicBoolean) {
            if (!this.myLogsDisposed.getAndSet(true)) {
                Disposer.dispose((Disposable)this.myLogsDisposable);
            }
        }
    }
}

