/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.clientLibrary;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryDescription;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RemoteServerClientLibraries", storages={@Storage(value="remote-server-client-libraries.xml")})
public class ClientLibraryManagerImpl
extends ClientLibraryManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(ClientLibraryManagerImpl.class);
    private Map<String, List<File>> myFiles = new LinkedHashMap<String, List<File>>();
    private final EventDispatcher<ClientLibraryManager.CloudClientLibraryManagerListener> myEventDispatcher = EventDispatcher.create(ClientLibraryManager.CloudClientLibraryManagerListener.class);

    public void addListener(@NotNull ClientLibraryManager.CloudClientLibraryManagerListener listener2, @NotNull Disposable disposable2) {
        this.myEventDispatcher.addListener((EventListener)listener2, disposable2);
    }

    public State getState() {
        State result2 = new State();
        for (Map.Entry<String, List<File>> entry : this.myFiles.entrySet()) {
            DownloadedLibraryState libraryState = new DownloadedLibraryState();
            libraryState.myId = entry.getKey();
            for (File file2 : entry.getValue()) {
                libraryState.myPaths.add(FileUtil.toSystemIndependentName((String)file2.getAbsolutePath()));
            }
            result2.myLibraries.add(libraryState);
        }
        return result2;
    }

    public void loadState(@NotNull State state) {
        this.myFiles = new HashMap<String, List<File>>();
        for (DownloadedLibraryState libraryState : state.myLibraries) {
            ArrayList<File> files2 = new ArrayList<File>();
            for (String path : libraryState.myPaths) {
                files2.add(new File(path));
            }
            this.myFiles.put(libraryState.myId, files2);
        }
    }

    public boolean isDownloaded(@NotNull ClientLibraryDescription description) {
        return !this.getExistentFiles(description).isEmpty();
    }

    @NotNull
    private List<File> getExistentFiles(ClientLibraryDescription description) {
        List<File> files2 = this.myFiles.get(description.getId());
        if (files2 == null) {
            return Collections.emptyList();
        }
        ArrayList<File> existentFiles = new ArrayList<File>();
        for (File file2 : files2) {
            if (!file2.exists()) continue;
            existentFiles.add(file2);
        }
        return existentFiles;
    }

    public void checkConfiguration(@NotNull ClientLibraryDescription description, @Nullable Project project, @Nullable JComponent component2) throws RuntimeConfigurationError {
        if (!this.isDownloaded(description)) {
            throw new RuntimeConfigurationError(CloudBundle.message((String)"dialog.message.client.libraries.were.downloaded", (Object[])new Object[0]), () -> this.download(description, project, component2));
        }
    }

    private static File getStoreDirectory(ClientLibraryDescription description) {
        return new File(PathManager.getSystemPath(), "remote-server-libraries/" + description.getId());
    }

    @NotNull
    public List<File> getLibraries(@NotNull ClientLibraryDescription description) {
        File[] files2 = ClientLibraryManagerImpl.getStoreDirectory(description).listFiles();
        return files2 == null ? Collections.emptyList() : Arrays.asList(files2);
    }

    public void download(@NotNull ClientLibraryDescription libraryDescription, @Nullable Project project, @Nullable JComponent component2) {
        Ref exc = Ref.create(null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                this.download(libraryDescription);
            }
            catch (IOException e) {
                exc.set((Object)e);
            }
        }, CloudBundle.message((String)"progress.title.downloading.client.libraries", (Object[])new Object[0]), false, project, component2);
        if (exc.isNull()) {
            ((ClientLibraryManager.CloudClientLibraryManagerListener)this.myEventDispatcher.getMulticaster()).downloaded();
        } else {
            LOG.info((Throwable)exc.get());
        }
    }

    @NotNull
    public List<File> download(@NotNull ClientLibraryDescription libraryDescription) throws IOException {
        List<File> existentFiles = this.getExistentFiles(libraryDescription);
        if (!existentFiles.isEmpty()) {
            return existentFiles;
        }
        DownloadableFileService downloadService = DownloadableFileService.getInstance();
        URL versionsUrl = libraryDescription.getDescriptionUrl();
        DownloadableFileSetVersions versions = downloadService.createFileSetVersions(null, new URL[]{versionsUrl});
        List descriptions = versions.fetchVersions();
        if (descriptions.isEmpty()) {
            throw new IOException("No client library versions loaded");
        }
        FileDownloader downloader = downloadService.createDownloader((DownloadableFileSetDescription)descriptions.get(0));
        List downloaded = downloader.download(ClientLibraryManagerImpl.getStoreDirectory(libraryDescription));
        List<File> files2 = this.myFiles.get(libraryDescription.getId());
        if (files2 == null) {
            files2 = new ArrayList<File>();
            this.myFiles.put(libraryDescription.getId(), files2);
        }
        for (Pair pair : downloaded) {
            files2.add((File)pair.getFirst());
        }
        ((ClientLibraryManager.CloudClientLibraryManagerListener)this.myEventDispatcher.getMulticaster()).downloaded();
        return files2;
    }

    public static class State {
        @Property(surroundWithTag=false)
        @XCollection
        public List<DownloadedLibraryState> myLibraries = new ArrayList<DownloadedLibraryState>();
    }

    @Tag(value="client-library")
    public static class DownloadedLibraryState {
        @Attribute(value="id")
        public String myId;
        @Property(surroundWithTag=false)
        @XCollection(elementName="file", valueAttributeName="path")
        public List<String> myPaths = new ArrayList<String>();
    }
}

