/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.RemoteServerListConfigurable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServerCombo<S extends ServerConfiguration>
extends ComboboxWithBrowseButton
implements UserActivityProviderComponent {
    private static final Comparator<RemoteServer<?>> SERVERS_COMPARATOR = Comparator.comparing(RemoteServer::getName, String.CASE_INSENSITIVE_ORDER);
    private final ServerType<S> myServerType;
    private final List<ChangeListener> myChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final CollectionComboBoxModel<ServerItem> myServerListModel;
    private String myServerNameReminder;

    public RemoteServerCombo(@NotNull ServerType<S> serverType) {
        this(serverType, (CollectionComboBoxModel<ServerItem>)new CollectionComboBoxModel());
    }

    private RemoteServerCombo(@NotNull ServerType<S> serverType, @NotNull CollectionComboBoxModel<ServerItem> model) {
        super((JComboBox)new ComboBox(model));
        this.myServerType = serverType;
        this.myServerListModel = model;
        this.refillModel(null);
        this.addActionListener(this::onBrowseServer);
        this.getComboBox().addActionListener(this::onItemChosen);
        this.getComboBox().addItemListener(this::onItemUnselected);
        this.getComboBox().setRenderer(new ColoredListCellRenderer<ServerItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ServerItem> list2, ServerItem value2, int index, boolean selected2, boolean focused) {
                if (value2 == null) {
                    return;
                }
                value2.render((SimpleColoredComponent)this);
            }
        });
    }

    public ServerItem getSelectedItem() {
        return (ServerItem)this.myServerListModel.getSelectedItem();
    }

    @Nullable
    public RemoteServer<S> getSelectedServer() {
        ServerItem selected2 = this.getSelectedItem();
        return selected2 == null ? null : selected2.findRemoteServer();
    }

    public void selectServerInCombo(@Nullable String serverName) {
        ServerItem item = this.findNonTransientItemForName(serverName);
        if (serverName != null && item == null && (item = this.getMissingServerItem(serverName)) != null) {
            this.myServerListModel.add(0, (Object)item);
        }
        this.getComboBox().setSelectedItem(item);
    }

    protected ServerType<S> getServerType() {
        return this.myServerType;
    }

    @NotNull
    protected List<TransientItem> getActionItems() {
        return Collections.singletonList(new CreateNewServerItem());
    }

    @Nullable
    protected ServerItem getMissingServerItem(@NotNull String serverName) {
        return new MissingServerItem(serverName);
    }

    @NotNull
    protected ServerItem getNoServersItem() {
        return new NoServersItem();
    }

    private ServerItem findNonTransientItemForName(@Nullable String serverName) {
        return this.myServerListModel.getItems().stream().filter(Objects::nonNull).filter(item -> !(item instanceof TransientItem)).filter(item -> Objects.equals(item.getServerName(), serverName)).findAny().orElse(null);
    }

    public void dispose() {
        super.dispose();
        this.myChangeListeners.clear();
    }

    protected final void fireStateChanged() {
        ChangeEvent event = new ChangeEvent((Object)this);
        for (ChangeListener changeListener : this.myChangeListeners) {
            changeListener.stateChanged(event);
        }
    }

    private void onBrowseServer(ActionEvent e) {
        ServerItem item = this.getSelectedItem();
        if (item != null) {
            item.onBrowseAction();
        } else {
            this.editServer(RemoteServerListConfigurable.createConfigurable(this.myServerType, null));
        }
    }

    private void onItemChosen(ActionEvent e) {
        RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)false, () -> {
            ServerItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                selectedItem.onItemChosen();
            }
            if (!(selectedItem instanceof TransientItem)) {
                this.fireStateChanged();
            }
            return null;
        });
    }

    private void onItemUnselected(ItemEvent e) {
        if (e.getStateChange() == 2) {
            ServerItem item = (ServerItem)e.getItem();
            this.myServerNameReminder = item == null ? null : item.getServerName();
        }
    }

    protected final boolean editServer(@NotNull RemoteServerListConfigurable configurable2) {
        boolean isOk = ShowSettingsUtil.getInstance().editConfigurable((Component)((Object)this), (Configurable)configurable2);
        if (isOk) {
            RemoteServer<?> lastSelectedServer = configurable2.getLastSelectedServer();
            this.refillModel(lastSelectedServer);
        }
        return isOk;
    }

    protected final void createAndEditNewServer() {
        String selectedBefore = this.myServerNameReminder;
        RemoteServersManager manager = RemoteServersManager.getInstance();
        RemoteServer newServer = manager.createServer(this.myServerType);
        manager.addServer(newServer);
        if (!this.editServer(RemoteServerListConfigurable.createConfigurable(this.myServerType, newServer.getName()))) {
            manager.removeServer(newServer);
            this.selectServerInCombo(selectedBefore);
        }
    }

    protected final void refillModel(@Nullable RemoteServer<?> newSelection) {
        String nameToSelect = newSelection != null ? newSelection.getName() : null;
        this.myServerListModel.removeAll();
        ServerItem itemToSelect = null;
        List<RemoteServer<S>> servers = this.getSortedServers();
        if (servers.isEmpty()) {
            ServerItem noServersItem = this.getNoServersItem();
            if (nameToSelect == null) {
                itemToSelect = noServersItem;
            }
            this.myServerListModel.add((Object)noServersItem);
        }
        for (RemoteServer<S> nextServer : this.getSortedServers()) {
            ServerItemImpl nextServerItem = new ServerItemImpl(nextServer.getName());
            if (itemToSelect == null && nextServer.getName().equals(nameToSelect)) {
                itemToSelect = nextServerItem;
            }
            this.myServerListModel.add((Object)nextServerItem);
        }
        for (TransientItem nextAction : this.getActionItems()) {
            this.myServerListModel.add((Object)nextAction);
        }
        this.getComboBox().setSelectedItem(itemToSelect);
    }

    @NotNull
    private List<RemoteServer<S>> getSortedServers() {
        ArrayList<RemoteServer<S>> result2 = new ArrayList<RemoteServer<S>>(RemoteServersManager.getInstance().getServers(this.myServerType));
        result2.sort(SERVERS_COMPARATOR);
        return result2;
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        this.myChangeListeners.add(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        this.myChangeListeners.remove(changeListener);
    }

    protected class NoServersItem
    extends ServerItemImpl {
        public NoServersItem() {
            super(null);
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            ui.setIcon(null);
            ui.append(CloudBundle.message((String)"remote.server.combo.no.servers", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    protected class MissingServerItem
    extends ServerItemImpl {
        public MissingServerItem(String serverName) {
            super(serverName);
        }

        @Override
        @NotNull
        public String getServerName() {
            String result2 = super.getServerName();
            assert (result2 != null);
            return result2;
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            ui.setIcon(RemoteServerCombo.this.myServerType.getIcon());
            ui.append(this.getServerName(), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public class ServerItemImpl
    implements ServerItem {
        private final String myServerName;

        public ServerItemImpl(String serverName) {
            this.myServerName = serverName;
        }

        @Override
        public String getServerName() {
            return this.myServerName;
        }

        @Override
        public void onItemChosen() {
        }

        @Override
        public void onBrowseAction() {
            RemoteServerCombo.this.editServer(RemoteServerListConfigurable.createConfigurable(RemoteServerCombo.this.myServerType, this.myServerName));
        }

        @Nullable
        public RemoteServer<S> findRemoteServer() {
            return this.myServerName == null ? null : RemoteServersManager.getInstance().findByName(this.myServerName, RemoteServerCombo.this.myServerType);
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            RemoteServer server = this.findRemoteServer();
            SimpleTextAttributes attributes = server == null ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            ui.setIcon(server == null ? null : RemoteServerCombo.this.myServerType.getIcon());
            ui.append(StringUtil.notNullize((String)this.myServerName), attributes);
        }
    }

    private class CreateNewServerItem
    implements TransientItem {
        private CreateNewServerItem() {
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            ui.setIcon((Icon)EmptyIcon.create((Icon)RemoteServerCombo.this.myServerType.getIcon()));
            ui.append(CloudBundle.message((String)"remote.server.combo.create.new.server", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        @Override
        public String getServerName() {
            return null;
        }

        @Override
        public void onItemChosen() {
            RemoteServerCombo.this.createAndEditNewServer();
        }

        @Override
        public void onBrowseAction() {
            RemoteServerCombo.this.createAndEditNewServer();
        }

        @Nullable
        public RemoteServer<S> findRemoteServer() {
            return null;
        }
    }

    public static interface TransientItem
    extends ServerItem {
    }

    public static interface ServerItem {
        @Nullable
        public String getServerName();

        public void render(@NotNull SimpleColoredComponent var1);

        public void onItemChosen();

        public void onBrowseAction();

        @Nullable
        public RemoteServer<?> findRemoteServer();
    }
}

