/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.PresentableId;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConfigCredentialsHolder {
    private static final String SSH_CREDENTIALS_ID = "SSH_CREDENTIALS_ID";
    private static final String SSH_CONFIG_NAME = "SSH_CONFIG_NAME";
    private static final String SSH_CONFIG_ID = "SSH_CONFIG_ID";
    public static final String SSH_CONFIG_PREFIX = "sshConfig://";
    @NotNull
    private String myCredentialsId;
    @Nullable
    private PresentableId mySshId;

    public SshConfigCredentialsHolder() {
        this(null);
    }

    public SshConfigCredentialsHolder(@Nullable PresentableId presentableId) {
        this.mySshId = presentableId;
        this.myCredentialsId = this.constructCredentialsId();
    }

    @NotNull
    public String getCredentialsId() {
        return this.myCredentialsId;
    }

    @Nullable
    public PresentableId getSshId() {
        return this.mySshId;
    }

    public void setSshId(@Nullable PresentableId sshId) {
        this.mySshId = sshId;
    }

    public void save(@NotNull Element element2) {
        if (this.mySshId != null) {
            if (this.mySshId.getId() != null) {
                element2.setAttribute(SSH_CONFIG_ID, this.mySshId.getId());
            }
            if (this.mySshId.getName() != null) {
                element2.setAttribute(SSH_CONFIG_NAME, this.mySshId.getName());
            }
        }
        element2.setAttribute(SSH_CREDENTIALS_ID, StringUtil.notNullize((String)this.myCredentialsId));
    }

    public void load(@NotNull Element element2) {
        this.mySshId = PresentableId.createId(element2.getAttributeValue(SSH_CONFIG_ID), element2.getAttributeValue(SSH_CONFIG_NAME));
        String credentialsId = element2.getAttributeValue(SSH_CREDENTIALS_ID);
        this.myCredentialsId = credentialsId == null ? this.constructCredentialsId() : credentialsId;
    }

    public void cleanConfigData() {
        this.mySshId = null;
        this.myCredentialsId = this.constructCredentialsId();
    }

    @NotNull
    private String constructCredentialsId() {
        return SSH_CONFIG_PREFIX + (this.mySshId == null || this.mySshId.getName() == null ? "<unknown>" : this.mySshId.getName());
    }

    public void copyFrom(SshConfigCredentialsHolder credentials) {
        this.myCredentialsId = credentials.myCredentialsId;
        this.mySshId = credentials.mySshId == null ? null : credentials.mySshId.clone();
    }
}

