/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkFactory;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteSdkFactoryImpl<T extends RemoteSdkAdditionalData>
implements RemoteSdkFactory<T> {
    @Override
    public Sdk createRemoteSdk(@Nullable Project project, @NotNull T data2, @Nullable String sdkName, Collection<Sdk> existingSdks) throws RemoteSdkException {
        String sdkVersion = this.getSdkVersion(project, data2);
        String name = StringUtil.isNotEmpty((String)sdkName) ? sdkName : this.getSdkName(data2, sdkVersion);
        SdkType sdkType = this.getSdkType(data2);
        ProjectJdkImpl sdk2 = this.createSdk(existingSdks, sdkType, data2, name);
        sdk2.setVersionString(sdkVersion);
        data2.setValid(true);
        return sdk2;
    }

    @Override
    public String generateSdkHomePath(@NotNull T data2) {
        return data2.getSdkId();
    }

    @NotNull
    protected abstract SdkType getSdkType(@NotNull T var1);

    @NotNull
    protected abstract String getSdkName(@NotNull T var1, @Nullable String var2) throws RemoteSdkException;

    @Nullable
    protected abstract String getSdkVersion(Project var1, @NotNull T var2) throws RemoteSdkException;

    @Override
    @NotNull
    public Sdk createUnfinished(T data2, Collection<Sdk> existingSdks) {
        String name = this.getDefaultUnfinishedName();
        SdkType sdkType = this.getSdkType(data2);
        ProjectJdkImpl sdk2 = this.createSdk(existingSdks, sdkType, data2, name);
        data2.setValid(false);
        return sdk2;
    }

    @NotNull
    protected abstract ProjectJdkImpl createSdk(@NotNull Collection<Sdk> var1, @NotNull SdkType var2, @NotNull T var3, @Nullable String var4);

    @Override
    public abstract String getDefaultUnfinishedName();

    @Override
    public boolean canSaveUnfinished() {
        return false;
    }

    @NotNull
    @Nls
    public static String getDefaultUnfinishedInterpreterName(@NotNull String sdkName) {
        return "Remote " + sdkName + " interpreter";
    }
}

