/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RelatedFilesSafeDeleteProcessorDelegate
implements SafeDeleteProcessorDelegate {
    @Override
    public boolean handlesElement(PsiElement element2) {
        return element2 instanceof PsiFile && element2.isValid() && ((PsiFile)element2).getVirtualFile() != null && !NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element2.getProject(), ((PsiFile)element2).getVirtualFile()).isEmpty();
    }

    @Override
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element2, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        if (!askUser || !(element2 instanceof PsiFile)) {
            return Collections.emptyList();
        }
        VirtualFile file2 = ((PsiFile)element2).getVirtualFile();
        if (file2 == null) {
            return Collections.emptyList();
        }
        Collection<NestingTreeStructureProvider.ChildFileInfo> relatedFileInfos = NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element2.getProject(), file2);
        ArrayList<PsiElement> psiFiles = new ArrayList<PsiElement>(relatedFileInfos.size());
        for (NestingTreeStructureProvider.ChildFileInfo info : relatedFileInfos) {
            PsiFile psiFile2 = element2.getManager().findFile(info.file);
            if (psiFile2 == null || allElementsToDelete.contains(psiFile2)) continue;
            psiFiles.add((PsiElement)psiFile2);
        }
        if (!psiFiles.isEmpty()) {
            String message = psiFiles.size() == 1 ? RefactoringBundle.message((String)"ask.to.delete.related.file", (Object[])new Object[]{((PsiFile)psiFiles.iterator().next()).getName()}) : RefactoringBundle.message((String)"ask.to.delete.related.files", (Object[])new Object[]{StringUtil.join(psiFiles, psiFile -> ((PsiFile)psiFile).getName(), (String)", ")});
            int ok = Messages.showYesNoDialog((Project)element2.getProject(), (String)message, (String)RefactoringBundle.message((String)"delete.title"), (Icon)Messages.getQuestionIcon());
            if (ok == 0) {
                return psiFiles;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element2, PsiElement @NotNull [] allElementsToDelete, @NotNull List<UsageInfo> result2) {
        return null;
    }

    @Override
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element2, @NotNull Collection<PsiElement> allElementsToDelete) {
        return Collections.singleton(element2);
    }

    @Override
    public Collection<String> findConflicts(@NotNull PsiElement element2, PsiElement @NotNull [] allElementsToDelete) {
        return Collections.emptyList();
    }

    @Override
    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        return usages;
    }

    @Override
    public void prepareForDeletion(PsiElement element2) throws IncorrectOperationException {
    }

    @Override
    public boolean isToSearchInComments(PsiElement element2) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element2) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    @Override
    public void setToSearchInComments(PsiElement element2, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element2, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }
}

