/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;

public class RenameViewDescriptor
implements UsageViewDescriptor {
    private static final Logger LOG = Logger.getInstance(RenameViewDescriptor.class);
    private final String myProcessedElementsHeader;
    private final String myCodeReferencesText;
    private final PsiElement[] myElements;

    public RenameViewDescriptor(LinkedHashMap<PsiElement, String> renamesMap) {
        this.myElements = PsiUtilCore.toPsiElementArray(renamesMap.keySet());
        THashSet processedElementsHeaders = new THashSet();
        THashSet codeReferences = new THashSet();
        for (PsiElement element2 : this.myElements) {
            String fullName;
            int lastDot;
            PsiUtilCore.ensureValid((PsiElement)element2);
            String newName = renamesMap.get(element2);
            String prefix = "";
            if (element2 instanceof PsiDirectory && (lastDot = (fullName = UsageViewUtil.getLongName(element2)).lastIndexOf(46)) >= 0 && lastDot + 1 < fullName.length() && ((PsiDirectory)element2).getName().equals(fullName.substring(lastDot + 1))) {
                prefix = fullName.substring(0, lastDot + 1);
            }
            processedElementsHeaders.add(StringUtil.capitalize((String)RefactoringBundle.message((String)"0.to.be.renamed.to.1.2", (Object[])new Object[]{UsageViewUtil.getType(element2), prefix, newName})));
            codeReferences.add(UsageViewUtil.getType(element2) + " " + UsageViewUtil.getLongName(element2));
        }
        this.myProcessedElementsHeader = StringUtil.join((String[])ArrayUtilRt.toStringArray((Collection)processedElementsHeaders), (String)", ");
        this.myCodeReferencesText = RefactoringBundle.message((String)"references.in.code.to.0", (Object[])new Object[]{StringUtil.join((String[])ArrayUtilRt.toStringArray((Collection)codeReferences), (String)", ")});
    }

    public PsiElement @NotNull [] getElements() {
        return this.myElements;
    }

    public String getProcessedElementsHeader() {
        return this.myProcessedElementsHeader;
    }

    @NotNull
    public String getCodeReferencesText(int usagesCount, int filesCount) {
        return this.myCodeReferencesText + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
    }

    public String getCommentReferencesText(int usagesCount, int filesCount) {
        return RefactoringBundle.message((String)"comments.elements.header", (Object[])new Object[]{UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount)});
    }
}

