/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameWithOptionalReferencesDialog;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class RenamePsiFileProcessor
extends RenamePsiElementProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element2) {
        return element2 instanceof PsiFileSystemItem;
    }

    @Override
    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element2, PsiElement nameSuggestionContext, Editor editor) {
        return new PsiFileRenameDialog(project, element2, nameSuggestionContext, editor);
    }

    private static boolean getSearchForReferences(PsiElement element2) {
        return element2 instanceof PsiFile ? RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_FILE : RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (!RenamePsiFileProcessor.getSearchForReferences(element2)) {
            return Collections.emptyList();
        }
        return super.findReferences(element2, searchScope, searchInCommentsAndStrings);
    }

    public static class PsiFileRenameDialog
    extends RenameWithOptionalReferencesDialog {
        public PsiFileRenameDialog(Project project, PsiElement element2, PsiElement nameSuggestionContext, Editor editor) {
            super(project, element2, nameSuggestionContext, editor);
        }

        @Override
        protected boolean getSearchForReferences() {
            return RenamePsiFileProcessor.getSearchForReferences(this.getPsiElement());
        }

        @Override
        protected void setSearchForReferences(boolean value2) {
            if (this.getPsiElement() instanceof PsiFile) {
                RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_FILE = value2;
            } else {
                RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY = value2;
            }
        }
    }
}

