/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RelatedFilesRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelatedFilesRenamerFactory
implements AutomaticRenamerFactory {
    @Override
    public boolean isApplicable(@NotNull PsiElement element2) {
        return element2 instanceof PsiFile && ((PsiFile)element2).getVirtualFile() != null && !NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element2.getProject(), ((PsiFile)element2).getVirtualFile()).isEmpty();
    }

    @Override
    @Nullable
    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.related.files.option.name");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    @NotNull
    public AutomaticRenamer createRenamer(@NotNull PsiElement element2, @NotNull String newName, @NotNull Collection<UsageInfo> usages) {
        return new RelatedFilesRenamer((PsiFile)element2, newName);
    }
}

