/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageViewUtil;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementRenameHandler
implements RenameHandler {
    private static final Logger LOG = Logger.getInstance(PsiElementRenameHandler.class);
    private static final ExtensionPointName<Condition<? super PsiElement>> VETO_RENAME_CONDITION_EP = ExtensionPointName.create((String)"com.intellij.vetoRenameCondition");
    public static final DataKey<String> DEFAULT_NAME = DataKey.create((String)"DEFAULT_NAME");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, @NotNull DataContext dataContext) {
        String newName;
        PsiElement element2 = PsiElementRenameHandler.getElement(dataContext);
        if (element2 == null) {
            element2 = BaseRefactoringAction.getElementAtCaret(editor, file2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (newName = (String)DEFAULT_NAME.getData(dataContext)) != null) {
            PsiElementRenameHandler.rename(element2, project, element2, editor, newName);
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = InjectedLanguageUtil.findElementAtNoCommit(file2, editor.getCaretModel().getOffset());
        PsiElementRenameHandler.invoke(element2, project, nameSuggestionContext, editor, this.shouldCheckInProject());
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, DataContext dataContext) {
        PsiElement element2;
        PsiElement psiElement = element2 = elements2.length == 1 ? elements2[0] : null;
        if (element2 == null) {
            element2 = PsiElementRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element2 != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String newName = (String)DEFAULT_NAME.getData(dataContext);
            LOG.assertTrue(newName != null);
            PsiElementRenameHandler.rename(element2, project, element2, editor, newName);
        } else {
            PsiElementRenameHandler.invoke(element2, project, element2, editor, this.shouldCheckInProject());
        }
    }

    protected boolean shouldCheckInProject() {
        return true;
    }

    public static void invoke(@NotNull PsiElement element2, @NotNull Project project, PsiElement nameSuggestionContext, @Nullable Editor editor) {
        PsiElementRenameHandler.invoke(element2, project, nameSuggestionContext, editor, true);
    }

    public static void invoke(@NotNull PsiElement element2, @NotNull Project project, PsiElement nameSuggestionContext, @Nullable Editor editor, boolean checkInProject) {
        if (!PsiElementRenameHandler.canRename(project, editor, element2)) {
            return;
        }
        VirtualFile contextFile = PsiUtilCore.getVirtualFile((PsiElement)nameSuggestionContext);
        if (checkInProject && nameSuggestionContext != null && nameSuggestionContext.isPhysical() && (contextFile == null || !ScratchUtil.isScratch(contextFile)) && !PsiManager.getInstance((Project)project).isInProject(nameSuggestionContext)) {
            String message = LangBundle.message((String)"dialog.message.selected.element.used.from.non.project.files", (Object[])new Object[0]);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException(message);
            }
            if (Messages.showYesNoDialog((Project)project, (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        PsiElementRenameHandler.rename(element2, project, nameSuggestionContext, editor);
    }

    public static boolean canRename(@NotNull Project project, Editor editor, PsiElement element2) throws CommonRefactoringUtil.RefactoringErrorHintException {
        String message;
        String string = message = element2 == null ? null : PsiElementRenameHandler.renameabilityStatus(project, element2);
        if (StringUtil.isNotEmpty((String)message)) {
            PsiElementRenameHandler.showErrorMessage(project, editor, message);
            return false;
        }
        return true;
    }

    @Nullable
    private static String renameabilityStatus(@NotNull Project project, @NotNull PsiElement element2) {
        boolean hasWritableMetaData;
        boolean hasRenameProcessor = RenamePsiElementProcessor.forElement(element2) != RenamePsiElementProcessor.DEFAULT;
        boolean bl = hasWritableMetaData = element2 instanceof PsiMetaOwner && ((PsiMetaOwner)element2).getMetaData() instanceof PsiWritableMetaData;
        if (!(hasRenameProcessor || hasWritableMetaData || element2 instanceof PsiNamedElement)) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.symbol.to.rename"));
        }
        if (!PsiManager.getInstance((Project)project).isInProject(element2)) {
            VirtualFile virtualFile;
            if (element2.isPhysical() && ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2)) == null || !NonProjectFileWritingAccessProvider.isWriteAccessAllowed(virtualFile, project))) {
                String message = RefactoringBundle.message((String)"error.out.of.project.element", (Object[])new Object[]{UsageViewUtil.getType(element2)});
                return RefactoringBundle.getCannotRefactorMessage((String)message);
            }
            if (!element2.isWritable()) {
                return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.cannot.be.renamed"));
            }
        }
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix(element2)) {
            String message = RefactoringBundle.message((String)"error.in.injected.lang.prefix.suffix", (Object[])new Object[]{UsageViewUtil.getType(element2)});
            return RefactoringBundle.getCannotRefactorMessage((String)message);
        }
        return null;
    }

    private static void showErrorMessage(@NotNull Project project, @Nullable Editor editor, @NotNull String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"rename.title"), null);
    }

    public static void rename(@NotNull PsiElement element2, @NotNull Project project, PsiElement nameSuggestionContext, Editor editor) {
        PsiElementRenameHandler.rename(element2, project, nameSuggestionContext, editor, null);
    }

    public static void rename(@NotNull PsiElement element2, @NotNull Project project, PsiElement nameSuggestionContext, Editor editor, String defaultName) {
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(element2);
        PsiElementRenameHandler.rename(element2, project, nameSuggestionContext, editor, defaultName, processor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(@NotNull PsiElement element2, @NotNull Project project, PsiElement nameSuggestionContext, Editor editor, String defaultName, RenamePsiElementProcessor processor2) {
        PsiElement substituted = processor2.substituteElementToRename(element2, editor);
        if (substituted == null || !PsiElementRenameHandler.canRename(project, editor, substituted)) {
            return;
        }
        RenameDialog dialog2 = processor2.createRenameDialog(project, substituted, nameSuggestionContext, editor);
        if (defaultName == null && ApplicationManager.getApplication().isUnitTestMode()) {
            Object[] strings = dialog2.getSuggestedNames();
            if (strings != null && strings.length > 0) {
                Arrays.sort(strings);
                defaultName = strings[0];
            } else {
                defaultName = "undefined";
            }
        }
        if (defaultName != null) {
            try {
                dialog2.performRename((String)defaultName);
            }
            finally {
                dialog2.close(1);
            }
        } else {
            dialog2.show();
        }
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        return !PsiElementRenameHandler.isVetoed(PsiElementRenameHandler.getElement(dataContext));
    }

    public static boolean isVetoed(PsiElement element2) {
        if (element2 == null || element2 instanceof SyntheticElement || element2 instanceof PsiNamedElement && ((PsiNamedElement)element2).getName() == null) {
            return true;
        }
        for (Condition condition : VETO_RENAME_CONDITION_EP.getExtensionList()) {
            if (!condition.value((Object)element2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getElement(@NotNull DataContext dataContext) {
        PsiElement[] elementArray = BaseRefactoringAction.getPsiElementArray(dataContext);
        if (elementArray.length != 1) {
            return null;
        }
        return elementArray[0];
    }
}

