/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelPatch;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.listeners.RefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.RefactoringListenerManagerImpl;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.suggested.SuggestedRefactoringProvider;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UnknownUsagesInUnloadedModules;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRefactoringProcessor
implements Runnable {
    private static final Logger LOG = Logger.getInstance(BaseRefactoringProcessor.class);
    private static boolean PREVIEW_IN_TESTS = true;
    protected final Project myProject;
    @NotNull
    protected final SearchScope myRefactoringScope;
    private RefactoringTransaction myTransaction;
    private boolean myIsPreviewUsages;
    protected Runnable myPrepareSuccessfulSwingThreadCallback;
    private UsageView myUsageView;

    protected BaseRefactoringProcessor(@NotNull Project project) {
        this(project, null);
    }

    protected BaseRefactoringProcessor(@NotNull Project project, @Nullable Runnable prepareSuccessfulCallback) {
        this(project, (SearchScope)GlobalSearchScope.projectScope((Project)project), prepareSuccessfulCallback);
    }

    protected BaseRefactoringProcessor(@NotNull Project project, @NotNull SearchScope refactoringScope, @Nullable Runnable prepareSuccessfulCallback) {
        this.myProject = project;
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulCallback;
        this.myRefactoringScope = refactoringScope;
    }

    @NotNull
    protected abstract UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] var1);

    protected abstract UsageInfo @NotNull [] findUsages();

    protected void refreshElements(PsiElement @NotNull [] elements2) {
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        this.prepareSuccessful();
        return true;
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        return this.myIsPreviewUsages;
    }

    protected boolean isPreviewUsages() {
        return this.myIsPreviewUsages;
    }

    private Set<UnloadedModuleDescription> computeUnloadedModulesFromUseScope(UsageViewDescriptor descriptor2) {
        if (ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescriptions().isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<UnloadedModuleDescription> unloadedModulesInUseScope = new LinkedHashSet<UnloadedModuleDescription>();
        for (PsiElement element2 : descriptor2.getElements()) {
            SearchScope useScope = element2.getUseScope();
            if (!(useScope instanceof GlobalSearchScope)) continue;
            unloadedModulesInUseScope.addAll(((GlobalSearchScope)useScope).getUnloadedModulesBelongingToScope());
        }
        return unloadedModulesInUseScope;
    }

    public void setPreviewUsages(boolean isPreviewUsages) {
        this.myIsPreviewUsages = isPreviewUsages;
    }

    public void setPrepareSuccessfulSwingThreadCallback(Runnable prepareSuccessfulSwingThreadCallback) {
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulSwingThreadCallback;
    }

    protected RefactoringTransaction getTransaction() {
        return this.myTransaction;
    }

    protected abstract void performRefactoring(UsageInfo @NotNull [] var1);

    @ApiStatus.Experimental
    protected boolean canPerformRefactoringInBranch() {
        return false;
    }

    @ApiStatus.Experimental
    protected void performRefactoringInBranch(UsageInfo @NotNull [] usages, ModelBranch branch) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected abstract String getCommandName();

    protected void doRun() {
        boolean isPreview;
        if (!PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocumentsUnderProgress()) {
            return;
        }
        Ref refUsages = new Ref();
        Ref refErrorLanguage = new Ref();
        Ref refProcessCanceled = new Ref();
        Ref anyException = new Ref();
        DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
        Runnable findUsagesRunnable = () -> {
            try {
                refUsages.set(ReadAction.compute(this::findUsages));
            }
            catch (UnknownReferenceTypeException e) {
                refErrorLanguage.set((Object)e.getElementLanguage());
            }
            catch (ProcessCanceledException e) {
                refProcessCanceled.set((Object)Boolean.TRUE);
            }
            catch (Throwable e) {
                anyException.set((Object)Boolean.TRUE);
                LOG.error(e);
            }
        };
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(findUsagesRunnable, RefactoringBundle.message((String)"progress.text"), true, this.myProject)) {
            return;
        }
        if (!refErrorLanguage.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"unsupported.refs.found", (Object[])new Object[]{((Language)refErrorLanguage.get()).getDisplayName()}), (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            DumbService.getInstance((Project)this.myProject).showDumbModeNotification(RefactoringBundle.message((String)"refactoring.dumb.mode.notification"));
            return;
        }
        if (!refProcessCanceled.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"refactoring.index.corruption.notifiction"), (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        if (!anyException.isNull()) {
            return;
        }
        assert (!refUsages.isNull()) : "Null usages from processor " + this;
        if (!this.preprocessUsages((Ref<UsageInfo[]>)refUsages)) {
            return;
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        assert (usages != null);
        UsageViewDescriptor descriptor2 = this.createUsageViewDescriptor(usages);
        boolean bl = isPreview = this.isPreviewUsages(usages) || !this.computeUnloadedModulesFromUseScope(descriptor2).isEmpty();
        if (!isPreview) {
            boolean bl2 = isPreview = !this.ensureElementsWritable(usages, descriptor2) || UsageViewUtil.hasReadOnlyUsages(usages);
            if (isPreview) {
                StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"readonly.occurences.found"));
            }
        }
        if (isPreview) {
            for (UsageInfo usage : usages) {
                LOG.assertTrue(usage != null, this.getClass());
            }
            this.previewRefactoring(usages);
        } else {
            this.execute(usages);
        }
    }

    public static <T extends Throwable> void runWithDisabledPreview(ThrowableRunnable<T> runnable2) throws T {
        PREVIEW_IN_TESTS = false;
        try {
            runnable2.run();
        }
        finally {
            PREVIEW_IN_TESTS = true;
        }
    }

    protected void previewRefactoring(UsageInfo @NotNull [] usages) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!PREVIEW_IN_TESTS) {
                throw new RuntimeException("Unexpected preview in tests: " + StringUtil.join((Object[])usages, UsageInfo::toString, (String)", "));
            }
            this.ensureElementsWritable(usages, this.createUsageViewDescriptor(usages));
            this.execute(usages);
            return;
        }
        UsageViewDescriptor viewDescriptor = this.createUsageViewDescriptor(usages);
        final PsiElement[] elements2 = viewDescriptor.getElements();
        final PsiElement2UsageTargetAdapter[] targets2 = PsiElement2UsageTargetAdapter.convert(elements2);
        Factory factory2 = () -> new UsageInfoSearcherAdapter(){

            public void generate(@NotNull Processor<? super Usage> processor2) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (int i2 = 0; i2 < elements2.length; ++i2) {
                        elements22[i2] = targets2[i2].getElement();
                    }
                    BaseRefactoringProcessor.this.refreshElements(elements2);
                });
                this.processUsages(processor2, BaseRefactoringProcessor.this.myProject);
            }

            protected UsageInfo @NotNull [] findUsages() {
                return BaseRefactoringProcessor.this.findUsages();
            }
        };
        this.showUsageView(viewDescriptor, (Factory<UsageSearcher>)factory2, usages);
    }

    protected boolean skipNonCodeUsages() {
        return false;
    }

    private boolean ensureElementsWritable(UsageInfo @NotNull [] usages, @NotNull UsageViewDescriptor descriptor2) {
        THashSet elements2 = ContainerUtil.newIdentityTroveSet();
        for (UsageInfo usage : usages) {
            PsiElement element2;
            assert (usage != null) : "Found null element in usages array";
            if (this.skipNonCodeUsages() && usage.isNonCodeUsage() || (element2 = usage.getElement()) == null) continue;
            elements2.add(element2);
        }
        elements2.addAll(this.getElementsToWrite(descriptor2));
        return BaseRefactoringProcessor.ensureFilesWritable(this.myProject, (Collection<? extends PsiElement>)elements2);
    }

    private static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements2) {
        PsiElement[] psiElements = PsiUtilCore.toPsiElementArray(elements2);
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement[])psiElements);
    }

    protected void execute(UsageInfo @NotNull [] usages) {
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
            this.doRefactoring(usageInfos);
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
            }
            SuggestedRefactoringProvider.getInstance((Project)this.myProject).reset();
        }, this.getCommandName(), null, this.getUndoConfirmationPolicy());
    }

    protected boolean isGlobalUndoAction() {
        return CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext()) == null;
    }

    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DEFAULT;
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull UsageViewDescriptor descriptor2, Usage @NotNull [] usages) {
        UsageViewPresentation presentation2 = new UsageViewPresentation();
        presentation2.setTabText(RefactoringBundle.message((String)"usageView.tabText"));
        presentation2.setTargetsNodeText(descriptor2.getProcessedElementsHeader());
        presentation2.setShowReadOnlyStatusAsRed(true);
        presentation2.setShowCancelButton(true);
        presentation2.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        int codeUsageCount = 0;
        int nonCodeUsageCount = 0;
        int dynamicUsagesCount = 0;
        HashSet<PsiFile> codeFiles = new HashSet<PsiFile>();
        HashSet<PsiFile> nonCodeFiles = new HashSet<PsiFile>();
        HashSet<PsiFile> dynamicUsagesCodeFiles = new HashSet<PsiFile>();
        for (Usage usage : usages) {
            PsiElementUsage elementUsage;
            PsiElement element2;
            if (!(usage instanceof PsiElementUsage) || (element2 = (elementUsage = (PsiElementUsage)usage).getElement()) == null) continue;
            PsiFile containingFile = element2.getContainingFile();
            if (usage instanceof UsageInfo2UsageAdapter && ((UsageInfo2UsageAdapter)usage).getUsageInfo().isDynamicUsage()) {
                ++dynamicUsagesCount;
                dynamicUsagesCodeFiles.add(containingFile);
                continue;
            }
            if (elementUsage.isNonCodeUsage()) {
                ++nonCodeUsageCount;
                nonCodeFiles.add(containingFile);
                continue;
            }
            ++codeUsageCount;
            codeFiles.add(containingFile);
        }
        codeFiles.remove(null);
        nonCodeFiles.remove(null);
        dynamicUsagesCodeFiles.remove(null);
        String codeReferencesText = descriptor2.getCodeReferencesText(codeUsageCount, codeFiles.size());
        presentation2.setCodeUsagesString(codeReferencesText);
        String commentReferencesText = descriptor2.getCommentReferencesText(nonCodeUsageCount, nonCodeFiles.size());
        if (commentReferencesText != null) {
            presentation2.setNonCodeUsagesString(commentReferencesText);
        }
        presentation2.setDynamicUsagesString("Dynamic " + StringUtil.decapitalize((String)descriptor2.getCodeReferencesText(dynamicUsagesCount, dynamicUsagesCodeFiles.size())));
        String generatedCodeString = codeReferencesText.contains("in code") ? StringUtil.replace((String)codeReferencesText, (String)"in code", (String)"in generated code") : codeReferencesText + " in generated code";
        presentation2.setUsagesInGeneratedCodeString(generatedCodeString);
        return presentation2;
    }

    public static boolean processConflicts(@NotNull Project project, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (conflicts.isEmpty()) {
            return true;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (ConflictsInTestsException.isTestIgnore()) {
                return true;
            }
            throw new ConflictsInTestsException(conflicts.values());
        }
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        return conflictsDialog.showAndGet();
    }

    private void showUsageView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull Factory<UsageSearcher> factory2, UsageInfo @NotNull [] usageInfos) {
        UsageViewManager viewManager = UsageViewManager.getInstance((Project)this.myProject);
        PsiElement[] initialElements = viewDescriptor.getElements();
        PsiElement2UsageTargetAdapter[] targets2 = PsiElement2UsageTargetAdapter.convert(initialElements);
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), RefactoringBundle.message((String)"refactoring.preprocess.usages.progress"), true, this.myProject)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation2 = BaseRefactoringProcessor.createPresentation(viewDescriptor, usages);
        if (this.myUsageView == null) {
            this.myUsageView = viewManager.showUsages((UsageTarget[])targets2, usages, presentation2, factory2);
            this.customizeUsagesView(viewDescriptor, this.myUsageView);
        } else {
            this.myUsageView.removeUsagesBulk((Collection)this.myUsageView.getUsages());
            ((UsageViewImpl)this.myUsageView).appendUsagesInBulk(Arrays.asList(usages));
        }
        Set<UnloadedModuleDescription> unloadedModules = this.computeUnloadedModulesFromUseScope(viewDescriptor);
        if (!unloadedModules.isEmpty()) {
            this.myUsageView.appendUsage((Usage)new UnknownUsagesInUnloadedModules(unloadedModules));
        }
    }

    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
        Runnable refactoringRunnable = () -> {
            Set<UsageInfo> usagesToRefactor = UsageViewUtil.getNotExcludedUsageInfos(usageView);
            UsageInfo[] infos = usagesToRefactor.toArray(UsageInfo.EMPTY_ARRAY);
            if (this.ensureElementsWritable(infos, viewDescriptor)) {
                this.execute(infos);
            }
        };
        String canNotMakeString = RefactoringBundle.message((String)"usageView.need.reRun");
        this.addDoRefactoringAction(usageView, refactoringRunnable, canNotMakeString);
        usageView.setRerunAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseRefactoringProcessor.this.doRun();
            }
        });
    }

    private void addDoRefactoringAction(@NotNull UsageView usageView, @NotNull Runnable refactoringRunnable, @NotNull String canNotMakeString) {
        usageView.addPerformOperationAction(refactoringRunnable, this.getCommandName(), canNotMakeString, RefactoringBundle.message((String)"usageView.doAction"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring(@NotNull Collection<UsageInfo> usageInfoSet) {
        Iterator<UsageInfo> iterator2 = usageInfoSet.iterator();
        while (iterator2.hasNext()) {
            UsageInfo usageInfo = iterator2.next();
            PsiElement element2 = usageInfo.getElement();
            if (element2 != null && this.isToBeChanged(usageInfo)) continue;
            iterator2.remove();
        }
        String commandName = this.getCommandName();
        LocalHistoryAction action2 = LocalHistory.getInstance().startAction(commandName);
        UsageInfo[] writableUsageInfos = usageInfoSet.toArray(UsageInfo.EMPTY_ARRAY);
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            RefactoringListenerManagerImpl listenerManager = (RefactoringListenerManagerImpl)RefactoringListenerManager.getInstance((Project)this.myProject);
            this.myTransaction = listenerManager.startTransaction();
            LinkedHashMap preparedData = new LinkedHashMap();
            Runnable prepareHelpersRunnable = () -> {
                for (RefactoringHelper helper : RefactoringHelper.EP_NAME.getExtensionList()) {
                    Object operation = ReadAction.compute(() -> helper.prepareOperation(writableUsageInfos));
                    preparedData.put(helper, operation);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(prepareHelpersRunnable, RefactoringBundle.message((String)"refactoring.prepare.progress"), false, this.myProject);
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            if (Registry.is((String)"run.refactorings.in.model.branch") && this.canPerformRefactoringInBranch()) {
                this.callPerformRefactoring(writableUsageInfos, () -> this.performInBranch(writableUsageInfos));
            } else if (Registry.is((String)"run.refactorings.under.progress")) {
                app.runWriteActionWithNonCancellableProgressInDispatchThread(commandName, this.myProject, null, (Consumer<? super ProgressIndicator>)((Consumer)indicator -> this.callPerformRefactoring(writableUsageInfos, () -> this.performRefactoring(writableUsageInfos))));
            } else {
                app.runWriteAction(() -> this.callPerformRefactoring(writableUsageInfos, () -> this.performRefactoring(writableUsageInfos)));
            }
            DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            for (Map.Entry e : preparedData.entrySet()) {
                ((RefactoringHelper)e.getKey()).performOperation(this.myProject, e.getValue());
            }
            this.myTransaction.commit();
            if (Registry.is((String)"run.refactorings.under.progress")) {
                app.runWriteActionWithNonCancellableProgressInDispatchThread(commandName, this.myProject, null, (Consumer<? super ProgressIndicator>)((Consumer)indicator -> this.performPsiSpoilingRefactoring()));
            } else {
                app.runWriteAction(this::performPsiSpoilingRefactoring);
            }
        }
        finally {
            action2.finish();
        }
        int count = writableUsageInfos.length;
        if (count > 0) {
            StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"statusBar.refactoring.result", (Object[])new Object[]{count}));
        } else if (!this.isPreviewUsages(writableUsageInfos)) {
            StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"statusBar.noUsages"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callPerformRefactoring(UsageInfo[] usageInfos, Runnable perform2) {
        String refactoringId = this.getRefactoringId();
        if (refactoringId != null) {
            RefactoringEventData data2 = this.getBeforeData();
            if (data2 != null) {
                data2.addUsages(Arrays.asList(usageInfos));
            }
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, data2);
        }
        try {
            if (refactoringId != null) {
                UndoRefactoringAction action1 = new UndoRefactoringAction(this.myProject, refactoringId);
                UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action1);
            }
            perform2.run();
        }
        finally {
            if (refactoringId != null) {
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, this.getAfterData(usageInfos));
            }
        }
    }

    private void performInBranch(UsageInfo[] usageInfos) {
        ThrowableComputable computable = () -> (ModelPatch)ReadAction.compute(() -> ModelBranch.performInBranch((Project)this.myProject, branch -> this.performRefactoringInBranch(usageInfos, (ModelBranch)branch)));
        ModelPatch patch = (ModelPatch)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, this.getCommandName(), true, this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.isPreviewUsages()) {
            this.displayPreview(patch);
        }
        WriteAction.run(() -> patch.applyBranchChanges());
    }

    private void displayPreview(ModelPatch patch) throws ProcessCanceledException {
        DialogBuilder builder2;
        JComponent preview = VcsFacade.getInstance().createPatchPreviewComponent(this.myProject, patch);
        if (preview != null && (builder2 = new DialogBuilder(this.myProject).title(RefactoringBundle.message((String)"usageView.tabText")).centerPanel(preview)).show() != 0) {
            throw new ProcessCanceledException();
        }
    }

    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        return usageInfo.isWritable();
    }

    protected void performPsiSpoilingRefactoring() {
    }

    protected void prepareSuccessful() {
        if (this.myPrepareSuccessfulSwingThreadCallback != null) {
            try {
                GuiUtils.runOrInvokeAndWait((Runnable)this.myPrepareSuccessfulSwingThreadCallback);
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public final void run() {
        Runnable runnable2 = this::doRun;
        if (this.shouldDisableAccessChecks()) {
            runnable2 = () -> NonProjectFileWritingAccessProvider.disableChecksDuring(this::doRun);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsWriteThread();
            runnable2.run();
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            LOG.error("Refactorings should not be started inside write action\n because they start progress inside and any read action from the progress task would cause the deadlock", (Throwable)new Exception());
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(runnable2);
        } else {
            runnable2.run();
        }
    }

    protected boolean shouldDisableAccessChecks() {
        return false;
    }

    @Deprecated
    protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts) {
        return this.showConflicts(conflicts, null);
    }

    protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
        if (!conflicts.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            if (!ConflictsInTestsException.isTestIgnore()) {
                throw new ConflictsInTestsException(conflicts.values());
            }
            return true;
        }
        if (this.myPrepareSuccessfulSwingThreadCallback != null && !conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog;
            String refactoringId = this.getRefactoringId();
            if (refactoringId != null) {
                RefactoringEventData conflictUsages = new RefactoringEventData();
                conflictUsages.putUserData(RefactoringEventData.CONFLICTS_KEY, (Object)conflicts.values());
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected(refactoringId, conflictUsages);
            }
            if (!(conflictsDialog = this.prepareConflictsDialog(conflicts, usages)).showAndGet()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    @NotNull
    protected ConflictsDialog prepareConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
        ConflictsDialog conflictsDialog = this.createConflictsDialog(conflicts, usages);
        conflictsDialog.setCommandName(this.getCommandName());
        return conflictsDialog;
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        return null;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        return null;
    }

    @NonNls
    @Nullable
    protected String getRefactoringId() {
        return null;
    }

    @NotNull
    protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
        return new ConflictsDialog(this.myProject, conflicts, usages == null ? null : () -> this.execute(usages), false, true);
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor2) {
        return Arrays.asList(descriptor2.getElements());
    }

    private static class UndoRefactoringAction
    extends BasicUndoableAction {
        private final Project myProject;
        private final String myRefactoringId;

        UndoRefactoringAction(@NotNull Project project, @NotNull String refactoringId) {
            this.myProject = project;
            this.myRefactoringId = refactoringId;
        }

        public void undo() {
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).undoRefactoring(this.myRefactoringId);
        }

        public void redo() {
        }
    }

    public static class UnknownReferenceTypeException
    extends RuntimeException {
        private final Language myElementLanguage;

        public UnknownReferenceTypeException(@NotNull Language elementLanguage) {
            this.myElementLanguage = elementLanguage;
        }

        @NotNull
        Language getElementLanguage() {
            return this.myElementLanguage;
        }
    }

    public static class ConflictsInTestsException
    extends RuntimeException {
        private final Collection<? extends String> messages;
        private static boolean myTestIgnore;

        public ConflictsInTestsException(@NotNull Collection<? extends String> messages) {
            this.messages = messages;
        }

        public static boolean isTestIgnore() {
            return myTestIgnore;
        }

        public static <T extends Throwable> void withIgnoredConflicts(@NotNull ThrowableRunnable<T> r) throws T {
            try {
                myTestIgnore = true;
                r.run();
            }
            finally {
                myTestIgnore = false;
            }
        }

        @NotNull
        public Collection<String> getMessages() {
            ArrayList<String> result2 = new ArrayList<String>(this.messages);
            for (int i2 = 0; i2 < this.messages.size(); ++i2) {
                result2.set(i2, ((String)result2.get(i2)).replaceAll("<[^>]+>", ""));
            }
            return result2;
        }

        @Override
        public String getMessage() {
            ArrayList<? extends String> result2 = new ArrayList<String>(this.messages);
            Collections.sort(result2);
            return StringUtil.join(result2, (String)"\n");
        }
    }
}

