/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.FileIntPropertyPusher;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataLanguagePusher
implements FileIntPropertyPusher<Language> {
    public static final Key<Language> KEY = Key.create((String)"TEMPLATE_DATA_LANGUAGE");
    private static final VfsDependentEnum<String> ourLanguagesEnumerator = new VfsDependentEnum("languages", EnumeratorStringDescriptor.INSTANCE, 1);
    private static final FileAttribute PERSISTENCE = new FileAttribute("template_language", 2, true);

    @NotNull
    public Key<Language> getFileDataKey() {
        return KEY;
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    @NotNull
    public Language getDefaultValue() {
        return Language.ANY;
    }

    @Nullable
    public Language getImmediateValue(@NotNull Project project, @Nullable VirtualFile file2) {
        return (Language)TemplateDataLanguageMappings.getInstance(project).getImmediateMapping(file2);
    }

    @Nullable
    public Language getImmediateValue(@NotNull Module module) {
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file2, @NotNull Project project) {
        FileType type = file2.getFileType();
        return type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage() instanceof TemplateLanguage;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project) {
        return true;
    }

    @NotNull
    public FileAttribute getAttribute() {
        return PERSISTENCE;
    }

    public int toInt(@NotNull Language property) throws IOException {
        return ourLanguagesEnumerator.getId(property.getID());
    }

    @NotNull
    public Language fromInt(int val) throws IOException {
        String id2 = ourLanguagesEnumerator.getById(val);
        Language lang = Language.findLanguageByID((String)id2);
        return (Language)ObjectUtils.notNull((Object)lang, (Object)Language.ANY);
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Language actualProperty) {
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, file2 -> this.acceptsFile((VirtualFile)file2, project));
    }
}

