/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElementImpl;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataModifications;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.util.CharTable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeCollectorImpl
extends TemplateDataElementType.RangeCollector {
    private final TemplateDataElementType myTemplateDataElementType;
    private final List<TextRange> myOuterAndRemoveRanges;
    static final Key<RangeCollectorImpl> OUTER_ELEMENT_RANGES = Key.create((String)"template.parser.outer.element.handler");

    RangeCollectorImpl(@NotNull TemplateDataElementType templateDataElementType) {
        this(templateDataElementType, new ArrayList<TextRange>());
    }

    private RangeCollectorImpl(@NotNull TemplateDataElementType templateDataElementType, @NotNull List<TextRange> outerAndRemoveRanges) {
        this.myTemplateDataElementType = templateDataElementType;
        this.myOuterAndRemoveRanges = outerAndRemoveRanges;
    }

    @Override
    public void addOuterRange(@NotNull TextRange newRange) {
        this.addOuterRange(newRange, false);
    }

    @Override
    public void addOuterRange(@NotNull TextRange newRange, boolean isInsertion) {
        int lastItemIndex;
        TextRange lastRange;
        if (newRange.isEmpty()) {
            return;
        }
        this.assertRangeOrder(newRange);
        if (!this.myOuterAndRemoveRanges.isEmpty() && (lastRange = this.myOuterAndRemoveRanges.get(lastItemIndex = this.myOuterAndRemoveRanges.size() - 1)).getEndOffset() == newRange.getStartOffset() && !(lastRange instanceof RangeToRemove)) {
            InsertionRange joinedRange = lastRange instanceof InsertionRange || isInsertion ? new InsertionRange(lastRange.getStartOffset(), newRange.getEndOffset()) : TextRange.create((int)lastRange.getStartOffset(), (int)newRange.getEndOffset());
            this.myOuterAndRemoveRanges.set(lastItemIndex, joinedRange);
            return;
        }
        this.myOuterAndRemoveRanges.add(isInsertion ? new InsertionRange(newRange.getStartOffset(), newRange.getEndOffset()) : newRange);
    }

    @Override
    public void addRangeToRemove(@NotNull TextRange rangeToRemove) {
        if (rangeToRemove.isEmpty()) {
            return;
        }
        this.assertRangeOrder(rangeToRemove);
        this.myOuterAndRemoveRanges.add(new RangeToRemove(rangeToRemove.getStartOffset(), rangeToRemove.getEndOffset()));
    }

    private void assertRangeOrder(@NotNull TextRange newRange) {
        TextRange range2 = (TextRange)ContainerUtil.getLastItem(this.myOuterAndRemoveRanges);
        assert (range2 == null || newRange.getStartOffset() >= range2.getStartOffset());
    }

    void prepareFileForParsing(@NotNull Language templateLanguage, @NotNull CharSequence originalSourceCode, @NotNull CharSequence templateSourceCode) {
        this.addDummyStringsToRangesToRemove(templateSourceCode);
        TemplateDataElementType.OuterLanguageRangePatcher patcher = (TemplateDataElementType.OuterLanguageRangePatcher)TemplateDataElementType.OuterLanguageRangePatcher.EXTENSION.forLanguage(templateLanguage);
        if (patcher != null) {
            StringBuilder builder2 = templateSourceCode instanceof StringBuilder ? (StringBuilder)templateSourceCode : new StringBuilder(templateSourceCode);
            this.insertDummyStringIntoInsertionRanges(patcher, originalSourceCode, builder2);
        }
    }

    private void addDummyStringsToRangesToRemove(@NotNull CharSequence generatedText) {
        int shift = 0;
        ListIterator<TextRange> iterator2 = this.myOuterAndRemoveRanges.listIterator();
        while (iterator2.hasNext()) {
            TextRange range2 = iterator2.next();
            if (range2 instanceof RangeToRemove) {
                CharSequence insertedString = generatedText.subSequence(range2.getStartOffset() - shift, range2.getEndOffset() - shift);
                iterator2.set(new RangeToRemove(range2.getStartOffset(), insertedString));
                shift -= range2.getLength();
                continue;
            }
            shift += range2.getLength();
        }
    }

    private void insertDummyStringIntoInsertionRanges(@NotNull TemplateDataElementType.OuterLanguageRangePatcher patcher, @NotNull CharSequence originalSourceCode, @NotNull StringBuilder modifiedText) {
        if (this.myOuterAndRemoveRanges.isEmpty()) {
            return;
        }
        int shift = 0;
        ListIterator<TextRange> iterator2 = this.myOuterAndRemoveRanges.listIterator();
        while (iterator2.hasNext()) {
            String dummyString;
            TextRange outerElementRange = iterator2.next();
            if (outerElementRange instanceof RangeToRemove) {
                shift += outerElementRange.getLength();
                continue;
            }
            if (outerElementRange instanceof InsertionRange && (dummyString = patcher.getTextForOuterLanguageInsertionRange(this.myTemplateDataElementType, outerElementRange.subSequence(originalSourceCode))) != null) {
                iterator2.add(new RangeToRemove(outerElementRange.getEndOffset(), outerElementRange.getEndOffset() + dummyString.length()));
                modifiedText.insert(outerElementRange.getStartOffset() + shift, dummyString);
                shift += dummyString.length();
            }
            shift -= outerElementRange.getLength();
        }
    }

    void insertOuterElementsAndRemoveRanges(@NotNull TreeElement templateFileElement, @NotNull CharSequence sourceCode, @NotNull CharTable charTable, @NotNull Language language) {
        TreePatcher templateTreePatcher = (TreePatcher)TemplateDataElementType.TREE_PATCHER.forLanguage(language);
        TreeElement currentLeafOrLazyParseable = RangeCollectorImpl.findFirstSuitableElement(templateFileElement);
        int currentLeafOffset = 0;
        for (TextRange rangeToProcess : this.myOuterAndRemoveRanges) {
            int rangeStartOffset = rangeToProcess.getStartOffset();
            while (currentLeafOrLazyParseable != null && currentLeafOffset + currentLeafOrLazyParseable.getTextLength() <= rangeStartOffset) {
                currentLeafOffset += currentLeafOrLazyParseable.getTextLength();
                currentLeafOrLazyParseable = RangeCollectorImpl.findNextSuitableElement(currentLeafOrLazyParseable);
            }
            if (rangeToProcess instanceof RangeToRemove) {
                if (currentLeafOrLazyParseable == null) {
                    Logger.getInstance(RangeCollectorImpl.class).error("RangeToRemove's range is out of original text bound", new Attachment[]{new Attachment("myOuterAndRemoveRanges", StringUtil.join(this.myOuterAndRemoveRanges, Object::toString, (String)", ")), new Attachment("rangeToProcess", rangeToProcess.toString()), new Attachment("sourceCode", sourceCode.toString())});
                    continue;
                }
                if (currentLeafOffset > rangeToProcess.getStartOffset() || currentLeafOffset + currentLeafOrLazyParseable.getTextLength() < rangeToProcess.getStartOffset()) {
                    Logger.getInstance(RangeCollectorImpl.class).error("startLeaf doesn't contain rangeToRemove start offset");
                    continue;
                }
                currentLeafOrLazyParseable = this.removeElementsForRange(currentLeafOrLazyParseable, currentLeafOffset, rangeToProcess, charTable);
                continue;
            }
            if (currentLeafOrLazyParseable instanceof LeafElement && currentLeafOffset < rangeStartOffset) {
                int splitOffset = rangeStartOffset - currentLeafOffset;
                currentLeafOrLazyParseable = templateTreePatcher.split((LeafElement)currentLeafOrLazyParseable, splitOffset, charTable);
                currentLeafOffset = rangeStartOffset;
            }
            if (currentLeafOrLazyParseable == null) {
                this.insertLastOuterElementForRange((CompositeElement)templateFileElement, rangeToProcess, sourceCode, charTable);
                continue;
            }
            currentLeafOrLazyParseable = this.insertOuterElementFromRange(currentLeafOrLazyParseable, currentLeafOffset, rangeToProcess, sourceCode, templateTreePatcher, charTable);
            this.addRangeToLazyParseableCollector(currentLeafOrLazyParseable, rangeToProcess.shiftLeft(currentLeafOffset));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String after2 = templateFileElement.getText();
            assert (after2.contentEquals(sourceCode)) : "Text presentation for the new tree must be the same: \nbefore: " + sourceCode + "\nafter: " + after2;
        }
    }

    private void addRangeToLazyParseableCollector(@NotNull TreeElement leafOrLazyParseable, @NotNull TextRange rangeWithinLazyParseable) {
        if (rangeWithinLazyParseable instanceof RangeToRemove && ((RangeToRemove)rangeWithinLazyParseable).myTextToRemove == null) {
            return;
        }
        RangeCollectorImpl lazyParseableCollector = (RangeCollectorImpl)leafOrLazyParseable.getUserData(OUTER_ELEMENT_RANGES);
        if (lazyParseableCollector != null) {
            assert (lazyParseableCollector != this);
            lazyParseableCollector.myOuterAndRemoveRanges.add(rangeWithinLazyParseable);
        }
    }

    @Nullable
    private static TreeElement findFirstSuitableElement(@NotNull ASTNode element2) {
        if (RangeCollectorImpl.isSuitableElement(element2)) {
            return (TreeElement)element2;
        }
        for (ASTNode child2 = element2.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            TreeElement leaf = RangeCollectorImpl.findFirstSuitableElement(child2);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    private static TreeElement findNextSuitableElement(@NotNull TreeElement start2) {
        for (TreeElement element2 = start2; element2 != null; element2 = element2.getTreeParent()) {
            TreeElement nextTree = element2;
            TreeElement next = null;
            while (next == null && (nextTree = nextTree.getTreeNext()) != null) {
                next = RangeCollectorImpl.findFirstSuitableElement(nextTree);
            }
            if (next == null) continue;
            return next;
        }
        return null;
    }

    private static boolean isSuitableElement(@NotNull ASTNode element2) {
        return element2 instanceof LeafElement || TreeUtil.isCollapsedChameleon(element2) && element2.getElementType() instanceof TemplateDataElementType.TemplateAwareElementType;
    }

    private void insertLastOuterElementForRange(@NotNull CompositeElement templateFileElement, @NotNull TextRange outerElementRange, @NotNull CharSequence sourceCode, @NotNull CharTable charTable) {
        assert (RangeCollectorImpl.isLastRange(this.myOuterAndRemoveRanges, outerElementRange)) : "This should only happen for the last inserted range. Got " + this.myOuterAndRemoveRanges.lastIndexOf(outerElementRange) + " of " + (this.myOuterAndRemoveRanges.size() - 1);
        OuterLanguageElementImpl outerLanguageElement = this.myTemplateDataElementType.createOuterLanguageElement(charTable.intern(outerElementRange.subSequence(sourceCode)), this.myTemplateDataElementType.myOuterElementType);
        templateFileElement.rawAddChildren(outerLanguageElement);
    }

    private static boolean isLastRange(@NotNull List<TextRange> outerElementsRanges, @NotNull TextRange outerElementRange) {
        return outerElementsRanges.get(outerElementsRanges.size() - 1) == outerElementRange;
    }

    @NotNull
    private TreeElement insertOuterElementFromRange(@NotNull TreeElement currentLeaf, int currentLeafOffset, @NotNull TextRange outerElementRange, @NotNull CharSequence sourceCode, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        CharSequence outerElementText = outerElementRange.subSequence(sourceCode);
        if (currentLeaf instanceof LazyParseableElement) {
            StringBuilder builder2 = new StringBuilder(currentLeaf.getText());
            builder2.insert(outerElementRange.getStartOffset() - currentLeafOffset, outerElementText);
            TreeElement newElement = this.newLazyParseable(currentLeaf, builder2.toString());
            currentLeaf.rawInsertAfterMe(newElement);
            currentLeaf.rawRemove();
            return newElement;
        }
        OuterLanguageElementImpl newLeaf = this.myTemplateDataElementType.createOuterLanguageElement(charTable.intern(outerElementText), this.myTemplateDataElementType.myOuterElementType);
        templateTreePatcher.insert(currentLeaf.getTreeParent(), currentLeaf, newLeaf);
        return newLeaf;
    }

    @NotNull
    private TreeElement newLazyParseable(@NotNull TreeElement currentLeaf, @NotNull CharSequence text) {
        TemplateDataElementType.TemplateAwareElementType elementType = (TemplateDataElementType.TemplateAwareElementType)currentLeaf.getElementType();
        TreeElement newElement = elementType.createTreeElement(text);
        RangeCollectorImpl collector = (RangeCollectorImpl)currentLeaf.getUserData(OUTER_ELEMENT_RANGES);
        if (collector == null) {
            collector = new RangeCollectorImpl(this.myTemplateDataElementType);
        }
        newElement.putUserData(OUTER_ELEMENT_RANGES, collector);
        return newElement;
    }

    @Nullable
    private TreeElement removeElementsForRange(@NotNull TreeElement startLeaf, int startLeafOffset, @NotNull TextRange rangeToRemove, @NotNull CharTable charTable) {
        TreeElement updatedStartLeaf = null;
        TreeElement currentLeaf = startLeaf;
        int leafOffset = startLeafOffset;
        if (rangeToRemove.getEndOffset() > startLeafOffset + startLeaf.getTextLength()) {
            leafOffset += startLeaf.getTextLength();
            updatedStartLeaf = this.cutPartOfLeaf(startLeaf, startLeafOffset, rangeToRemove, charTable);
            currentLeaf = RangeCollectorImpl.findNextSuitableElement(updatedStartLeaf);
        }
        while (currentLeaf != null && rangeToRemove.containsRange(leafOffset, leafOffset + currentLeaf.getTextLength())) {
            TreeElement leafToRemove = currentLeaf;
            leafOffset += currentLeaf.getTextLength();
            currentLeaf = RangeCollectorImpl.findNextSuitableElement(currentLeaf);
            leafToRemove.rawRemove();
        }
        TreeElement leafAfterCompletelyRemoved = currentLeaf;
        TreeElement updatedLastLeaf = null;
        if (currentLeaf != null && leafOffset < rangeToRemove.getEndOffset()) {
            updatedLastLeaf = this.cutPartOfLeaf(currentLeaf, leafOffset, rangeToRemove, charTable);
        }
        return updatedStartLeaf != null ? updatedStartLeaf : (updatedLastLeaf != null ? updatedLastLeaf : leafAfterCompletelyRemoved);
    }

    @NotNull
    private TreeElement cutPartOfLeaf(@NotNull TreeElement currentLeafOrLazyParseable, int currentLeafOffset, @NotNull TextRange rangeToProcess, @NotNull CharTable charTable) {
        TextRange intersection = rangeToProcess.intersection(TextRange.from((int)currentLeafOffset, (int)currentLeafOrLazyParseable.getTextLength()));
        assert (intersection != null);
        TextRange rangeWithinLeaf = intersection.shiftLeft(currentLeafOffset);
        currentLeafOrLazyParseable = this.removeRange(currentLeafOrLazyParseable, rangeWithinLeaf, charTable);
        this.addRangeToLazyParseableCollector(currentLeafOrLazyParseable, rangeWithinLeaf);
        return currentLeafOrLazyParseable;
    }

    @NotNull
    ASTNode applyRangeCollectorAndExpandChameleon(@NotNull ASTNode chameleon, @NotNull Language language, @NotNull @NotNull Function<@NotNull CharSequence, @NotNull ASTNode> parser) {
        CharSequence chars = chameleon.getChars();
        if (this.myOuterAndRemoveRanges.isEmpty()) {
            return parser.apply(chars);
        }
        StringBuilder stringBuilder = this.applyOuterAndRemoveRanges(chars);
        TemplateDataElementType.OuterLanguageRangePatcher outerLanguageRangePatcher = (TemplateDataElementType.OuterLanguageRangePatcher)TemplateDataElementType.OuterLanguageRangePatcher.EXTENSION.forLanguage(language);
        if (outerLanguageRangePatcher != null) {
            this.insertDummyStringIntoInsertionRanges(outerLanguageRangePatcher, chars, stringBuilder);
        }
        ASTNode root = parser.apply(stringBuilder.toString());
        DebugUtil.performPsiModification("lazy parseable outer elements insertion", () -> this.insertOuterElementsAndRemoveRanges((TreeElement)root, chars, SharedImplUtil.findCharTableByTree(chameleon), language));
        return root;
    }

    @NotNull
    private StringBuilder applyOuterAndRemoveRanges(CharSequence chars) {
        StringBuilder stringBuilder = new StringBuilder(chars);
        int shift = 0;
        for (TextRange outerElementRange : this.myOuterAndRemoveRanges) {
            if (outerElementRange instanceof RangeToRemove) {
                CharSequence textToRemove = ((RangeToRemove)outerElementRange).myTextToRemove;
                if (textToRemove == null) continue;
                stringBuilder.insert(outerElementRange.getStartOffset() + shift, textToRemove);
                shift += textToRemove.length();
                continue;
            }
            stringBuilder.delete(outerElementRange.getStartOffset() + shift, outerElementRange.getEndOffset() + shift);
            shift -= outerElementRange.getLength();
        }
        return stringBuilder;
    }

    @NotNull
    private TreeElement removeRange(@NotNull TreeElement leaf, @NotNull TextRange rangeToRemove, @NotNull CharTable table) {
        CharSequence chars = leaf.getChars();
        String res2 = rangeToRemove.replace(chars.toString(), "");
        TreeElement newLeaf = leaf instanceof LeafElement ? ASTFactory.leaf(leaf.getElementType(), table.intern((CharSequence)res2)) : this.newLazyParseable(leaf, res2);
        leaf.rawInsertBeforeMe(newLeaf);
        leaf.rawRemove();
        return newLeaf;
    }

    @NotNull
    CharSequence applyTemplateDataModifications(@NotNull CharSequence sourceCode, @NotNull TemplateDataModifications modifications) {
        assert (this.myOuterAndRemoveRanges.isEmpty());
        List<TextRange> ranges = modifications.myOuterAndRemoveRanges;
        if (ranges.isEmpty()) {
            return sourceCode;
        }
        for (TextRange range2 : ranges) {
            if (range2 instanceof RangeToRemove) {
                if (range2.isEmpty()) continue;
                this.assertRangeOrder(range2);
                CharSequence textToRemove = ((RangeToRemove)range2).myTextToRemove;
                assert (textToRemove != null);
                this.myOuterAndRemoveRanges.add(new RangeToRemove(range2.getStartOffset(), textToRemove));
                continue;
            }
            this.addOuterRange(range2, range2 instanceof InsertionRange);
        }
        return this.applyOuterAndRemoveRanges(sourceCode);
    }

    static final class InsertionRange
    extends TextRange {
        InsertionRange(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        @NotNull
        public TextRange shiftLeft(int delta) {
            if (delta == 0) {
                return this;
            }
            return new InsertionRange(this.getStartOffset() - delta, this.getEndOffset() - delta);
        }

        @NotNull
        public TextRange intersection(@NotNull TextRange range2) {
            int newStart = Math.max(this.getStartOffset(), range2.getStartOffset());
            int newEnd = Math.min(this.getEndOffset(), range2.getEndOffset());
            InsertionRange.assertProperRange((int)newStart, (int)newEnd, (Object)"Invalid range");
            return new InsertionRange(newStart, newEnd);
        }

        public String toString() {
            return "InsertionRange" + super.toString();
        }
    }

    static final class RangeToRemove
    extends TextRange {
        @Nullable
        public final CharSequence myTextToRemove;

        RangeToRemove(int startOffset, @NotNull CharSequence text) {
            super(startOffset, startOffset + text.length());
            this.myTextToRemove = text;
        }

        RangeToRemove(int startOffset, int endOffset) {
            super(startOffset, endOffset);
            this.myTextToRemove = null;
        }

        @NotNull
        public TextRange shiftLeft(int delta) {
            if (delta == 0) {
                return this;
            }
            return this.myTextToRemove != null ? new RangeToRemove(this.getStartOffset() - delta, this.myTextToRemove) : new RangeToRemove(this.getStartOffset() - delta, this.getEndOffset() - delta);
        }

        @NotNull
        public TextRange intersection(@NotNull TextRange range2) {
            int newStart = Math.max(this.getStartOffset(), range2.getStartOffset());
            int newEnd = Math.min(this.getEndOffset(), range2.getEndOffset());
            RangeToRemove.assertProperRange((int)newStart, (int)newEnd, (Object)"Invalid range");
            return this.myTextToRemove != null ? new RangeToRemove(newStart, this.myTextToRemove.subSequence(newStart - this.getStartOffset(), newEnd - this.getStartOffset())) : new RangeToRemove(newStart, newEnd);
        }

        public String toString() {
            return "RangeToRemove" + super.toString();
        }
    }
}

