/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.StubIdList;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class StubIdExternalizer
implements DataExternalizer<StubIdList> {
    public static final StubIdExternalizer INSTANCE = new StubIdExternalizer();

    public void save(@NotNull DataOutput out, @NotNull StubIdList value2) throws IOException {
        int size = value2.size();
        if (size == 0) {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)Integer.MAX_VALUE);
        } else if (size == 1) {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.get(0));
        } else {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)(-size));
            for (int i2 = 0; i2 < size; ++i2) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.get(i2));
            }
        }
    }

    @NotNull
    public StubIdList read(@NotNull DataInput in) throws IOException {
        int size = DataInputOutputUtil.readINT((DataInput)in);
        if (size == Integer.MAX_VALUE) {
            return new StubIdList();
        }
        if (size >= 0) {
            return new StubIdList(size);
        }
        size = -size;
        int[] result2 = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            result2[i2] = DataInputOutputUtil.readINT((DataInput)in);
        }
        return new StubIdList(result2, size);
    }
}

