/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics.impl;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.SettingsSavingComponent;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.statistics.impl.StatisticsManagerImplKt;
import com.intellij.psi.statistics.impl.StatisticsUnit;
import com.intellij.reference.SoftReference;
import com.intellij.util.ScrambledOutputStream;
import com.intellij.util.io.PathKt;
import gnu.trove.THashSet;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0011H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0011\u0010$\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000RF\u0010\u000b\u001a:\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \u000e*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\r0\r0\fj\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \u000e*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\r0\r`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lcom/intellij/psi/statistics/impl/StatisticsManagerImpl;", "Lcom/intellij/psi/statistics/StatisticsManager;", "Lcom/intellij/configurationStore/SettingsSavingComponent;", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "modifiedUnits", "Lgnu/trove/THashSet;", "Lcom/intellij/psi/statistics/impl/StatisticsUnit;", "testingStatistics", "", "units", "Ljava/util/ArrayList;", "Lcom/intellij/reference/SoftReference;", "kotlin.jvm.PlatformType", "Lkotlin/collections/ArrayList;", "doGetRecency", "", "info", "Lcom/intellij/psi/statistics/StatisticsInfo;", "doGetUseCount", "doIncUseCount", "", "enableStatistics", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getAllValues", "", "context", "", "(Ljava/lang/String;)[Lcom/intellij/psi/statistics/StatisticsInfo;", "getLastUseRecency", "getUnit", "unitNumber", "getUseCount", "incUseCount", "save", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveUnit", "intellij.platform.ide.impl"})
public final class StatisticsManagerImpl
extends StatisticsManager
implements SettingsSavingComponent {
    private final ArrayList<SoftReference<StatisticsUnit>> units = new ArrayList(Collections.nCopies(997, null));
    private final THashSet<StatisticsUnit> modifiedUnits = new THashSet();
    private boolean testingStatistics;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public int getUseCount(@NotNull StatisticsInfo info) {
        if (info == StatisticsInfo.EMPTY) {
            return 0;
        }
        int useCount = 0;
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            useCount = Math.max(this.doGetUseCount(conjunct), useCount);
        }
        return useCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int doGetUseCount(StatisticsInfo info) {
        int n;
        String key = info.getContext();
        int unitNumber = StatisticsManagerImplKt.access$getUnitNumber(key);
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            n = this.getUnit(unitNumber).getData(key, info.getValue());
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    public int getLastUseRecency(@NotNull StatisticsInfo info) {
        if (info == StatisticsInfo.EMPTY) {
            return 0;
        }
        int recency = Integer.MAX_VALUE;
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            recency = Math.min(this.doGetRecency(conjunct), recency);
        }
        return recency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int doGetRecency(StatisticsInfo info) {
        int n;
        String key1 = info.getContext();
        int unitNumber = StatisticsManagerImplKt.access$getUnitNumber(key1);
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            StatisticsUnit unit = this.getUnit(unitNumber);
            n = unit.getRecency(key1, info.getValue());
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    public void incUseCount(@NotNull StatisticsInfo info) {
        if (info == StatisticsInfo.EMPTY) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !this.testingStatistics) {
            return;
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            this.doIncUseCount(conjunct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doIncUseCount(StatisticsInfo info) {
        int n;
        int n2;
        String key1 = info.getContext();
        int unitNumber = StatisticsManagerImplKt.access$getUnitNumber(key1);
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            StatisticsUnit unit = this.getUnit(unitNumber);
            unit.incData(key1, info.getValue());
            n4 = this.modifiedUnits.add((Object)unit) ? 1 : 0;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public StatisticsInfo[] getAllValues(@NotNull String context) {
        void $this$mapTo$iv$iv;
        Collection<String> $i$a$-read-StatisticsManagerImpl$getAllValues$22;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        Object object = reentrantReadWriteLock.readLock();
        ((ReentrantReadWriteLock.ReadLock)object).lock();
        try {
            boolean $i$a$-read-StatisticsManagerImpl$getAllValues$22 = false;
            $i$a$-read-StatisticsManagerImpl$getAllValues$22 = this.getUnit(StatisticsManagerImplKt.access$getUnitNumber(context)).getKeys2(context);
        }
        finally {
            ((ReentrantReadWriteLock.ReadLock)object).unlock();
        }
        Iterable $this$map$iv = $i$a$-read-StatisticsManagerImpl$getAllValues$22;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            StatisticsInfo statisticsInfo = new StatisticsInfo(context, (String)it);
            collection.add(statisticsInfo);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        StatisticsInfo[] statisticsInfoArray = thisCollection$iv.toArray(new StatisticsInfo[0]);
        if (statisticsInfoArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return statisticsInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object save(@NotNull Continuation<? super Unit> $completion) {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                for (StatisticsUnit unit : this.modifiedUnits) {
                    this.saveUnit(unit.getNumber());
                }
            }
            this.modifiedUnits.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return Unit.INSTANCE;
    }

    private final StatisticsUnit getUnit(int unitNumber) {
        StatisticsUnit unit = (StatisticsUnit)SoftReference.dereference((Reference)((Reference)this.units.get(unitNumber)));
        if (unit == null) {
            unit = StatisticsManagerImplKt.access$loadUnit(unitNumber);
            this.units.set(unitNumber, (SoftReference<StatisticsUnit>)new SoftReference((Object)unit));
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveUnit(int unitNumber) {
        StatisticsUnit statisticsUnit = (StatisticsUnit)SoftReference.dereference((Reference)((Reference)this.units.get(unitNumber)));
        if (statisticsUnit == null) {
            return;
        }
        StatisticsUnit unit = statisticsUnit;
        try {
            Closeable closeable = new ScrambledOutputStream(new BufferedOutputStream(PathKt.outputStream((Path)StatisticsManagerImplKt.access$getPathToUnit(unitNumber))));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ScrambledOutputStream out = (ScrambledOutputStream)closeable;
                boolean bl3 = false;
                unit.write(out);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.saving.statistics", (Object[])new Object[]{e.getLocalizedMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        }
    }

    public final void enableStatistics(@NotNull Disposable parentDisposable) {
        this.testingStatistics = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(this){
            final /* synthetic */ StatisticsManagerImpl this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void dispose() {
                int n;
                int n2;
                ReentrantReadWriteLock reentrantReadWriteLock = StatisticsManagerImpl.access$getLock$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                boolean bl3 = false;
                int n4 = 0;
                n4 = 0;
                int n5 = n3;
                while (n4 < n5) {
                    n2 = n4++;
                    n = 0;
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    boolean bl4 = false;
                    List list2 = StatisticsManagerImpl.access$getUnits$p(this.this$0);
                    T t = null;
                    boolean bl5 = false;
                    Collections.fill(list2, t);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    n5 = 0;
                    n2 = 0;
                    n2 = 0;
                    n = n3;
                    while (n2 < n) {
                        int n6 = n2++;
                        boolean bl6 = false;
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
                StatisticsManagerImpl.access$setTestingStatistics$p(this.this$0, false);
            }
            {
                this.this$0 = statisticsManagerImpl;
            }
        });
    }

    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$p(StatisticsManagerImpl $this) {
        return $this.lock;
    }

    public static final /* synthetic */ ArrayList access$getUnits$p(StatisticsManagerImpl $this) {
        return $this.units;
    }

    public static final /* synthetic */ boolean access$getTestingStatistics$p(StatisticsManagerImpl $this) {
        return $this.testingStatistics;
    }

    public static final /* synthetic */ void access$setTestingStatistics$p(StatisticsManagerImpl $this, boolean bl) {
        $this.testingStatistics = bl;
    }
}

