/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAwareVirtualFile;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeImpl
extends GlobalSearchScope {
    private final FileIndexFacade myFileIndex;

    public ProjectScopeImpl(@NotNull Project project, @NotNull FileIndexFacade fileIndex) {
        super(project);
        this.myFileIndex = fileIndex;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 instanceof ProjectAwareVirtualFile) {
            return ((ProjectAwareVirtualFile)file2).isInProject(Objects.requireNonNull(this.getProject()));
        }
        return this.myFileIndex.isInProjectScope(file2);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return true;
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return CoreBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        return this.myFileIndex.getUnloadedModuleDescriptions();
    }

    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == this || !scope.isSearchInLibraries()) {
            return this;
        }
        return super.uniteWith(scope);
    }

    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == this) {
            return this;
        }
        if (!scope.isSearchInLibraries()) {
            return scope;
        }
        return super.intersectWith(scope);
    }
}

