/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected.changesHandler;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.InjectedFileChangesHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;

public abstract class BaseInjectedFileChangesHandler
implements InjectedFileChangesHandler {
    protected final Editor myHostEditor;
    protected final Document myHostDocument;
    protected final Document myFragmentDocument;
    protected final Project myProject;
    protected PsiFile myInjectedFile;

    public BaseInjectedFileChangesHandler(Editor hostEditor, Document fragmentDocument, PsiFile injectedFile) {
        this.myProject = hostEditor.getProject();
        this.myHostEditor = hostEditor;
        this.myHostDocument = hostEditor.getDocument();
        this.myFragmentDocument = fragmentDocument;
        this.myInjectedFile = injectedFile;
    }

    public boolean tryReuse(@NotNull PsiFile newInjectedFile, @NotNull TextRange newHostRange) {
        DocumentWindow documentWindow;
        if (this.myInjectedFile == newInjectedFile) {
            return this.handlesRange(newHostRange);
        }
        if ((this.myInjectedFile == null || !this.myInjectedFile.isValid()) && (documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)newInjectedFile)) != null && this.handlesRange(newHostRange)) {
            this.myInjectedFile = newInjectedFile;
            return true;
        }
        return false;
    }

    public void dispose() {
    }
}

