/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.LightHighlighterClient;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.CaretModelWindow;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.FoldingModelWindow;
import com.intellij.psi.impl.source.tree.injected.FoldingRegionWindow;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InlayModelWindow;
import com.intellij.psi.impl.source.tree.injected.ListenerWrapperMap;
import com.intellij.psi.impl.source.tree.injected.SelectionModelWindow;
import com.intellij.psi.impl.source.tree.injected.SoftWrapModelWindow;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.UnsafeWeakList;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.IntFunction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorWindowImpl
extends com.intellij.injected.editor.EditorWindowImpl
implements EditorWindow,
EditorEx {
    private final DocumentWindowImpl myDocumentWindow;
    private final EditorImpl myDelegate;
    private volatile PsiFile myInjectedFile;
    private final boolean myOneLine;
    private final CaretModelWindow myCaretModelDelegate;
    private final SelectionModelWindow mySelectionModelDelegate;
    private static final Collection<EditorWindowImpl> allEditors = new UnsafeWeakList();
    private volatile boolean myDisposed;
    private final MarkupModelWindow myMarkupModelDelegate;
    private final MarkupModelWindow myDocumentMarkupModelDelegate;
    private final FoldingModelWindow myFoldingModelWindow;
    private final SoftWrapModelWindow mySoftWrapModel;
    private final InlayModelWindow myInlayModel;
    private final ListenerWrapperMap<EditorMouseListener> myEditorMouseListeners = new ListenerWrapperMap();
    private final ListenerWrapperMap<EditorMouseMotionListener> myEditorMouseMotionListeners = new ListenerWrapperMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static Editor create(@NotNull DocumentWindowImpl documentRange, @NotNull EditorImpl editor, @NotNull PsiFile injectedFile) {
        EditorWindowImpl window;
        assert (documentRange.isValid());
        assert (injectedFile.isValid());
        Collection<EditorWindowImpl> collection = allEditors;
        synchronized (collection) {
            for (EditorWindowImpl editorWindow : allEditors) {
                if (editorWindow.getDocument() != documentRange || editorWindow.getDelegate() != editor) continue;
                editorWindow.myInjectedFile = injectedFile;
                if (!editorWindow.isValid()) continue;
                return editorWindow;
            }
            window = new EditorWindowImpl(documentRange, editor, injectedFile, documentRange.isOneLine());
            allEditors.add(window);
        }
        window.checkValid();
        return window;
    }

    private EditorWindowImpl(@NotNull DocumentWindowImpl documentWindow, @NotNull EditorImpl delegate, @NotNull PsiFile injectedFile, boolean oneLine) {
        this.myDocumentWindow = documentWindow;
        this.myDelegate = delegate;
        this.myInjectedFile = injectedFile;
        this.myOneLine = oneLine;
        this.myCaretModelDelegate = new CaretModelWindow(this.myDelegate.getCaretModel(), this);
        this.mySelectionModelDelegate = new SelectionModelWindow(this.myDelegate, this.myDocumentWindow, this);
        this.myMarkupModelDelegate = new MarkupModelWindow(this.myDelegate.getMarkupModel(), this.myDocumentWindow);
        this.myDocumentMarkupModelDelegate = new MarkupModelWindow(this.myDelegate.getFilteredDocumentMarkupModel(), this.myDocumentWindow);
        this.myFoldingModelWindow = new FoldingModelWindow(delegate.getFoldingModel(), documentWindow, this);
        this.mySoftWrapModel = new SoftWrapModelWindow();
        this.myInlayModel = new InlayModelWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeInvalidEditors() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Collection<EditorWindowImpl> collection = allEditors;
        synchronized (collection) {
            Iterator<EditorWindowImpl> iterator2 = allEditors.iterator();
            while (iterator2.hasNext()) {
                EditorWindowImpl editorWindow = iterator2.next();
                if (editorWindow.isValid()) continue;
                EditorWindowImpl.disposeEditor(editorWindow);
                iterator2.remove();
            }
        }
    }

    private static void disposeEditor(@NotNull EditorWindow editorWindow) {
        EditorWindowImpl impl = (EditorWindowImpl)editorWindow;
        impl.dispose();
        InjectedLanguageUtil.clearCaches(impl.myInjectedFile, impl.getDocument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeEditorFor(@NotNull DocumentWindow documentWindow) {
        Collection<EditorWindowImpl> collection = allEditors;
        synchronized (collection) {
            Iterator<EditorWindowImpl> iterator2 = allEditors.iterator();
            while (iterator2.hasNext()) {
                EditorWindowImpl editor = iterator2.next();
                if (!InjectionRegistrarImpl.intersect(editor.getDocument(), (DocumentWindowImpl)documentWindow)) continue;
                EditorWindowImpl.disposeEditor(editor);
                iterator2.remove();
                break;
            }
        }
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed() && !this.myInjectedFile.getProject().isDisposed() && this.myInjectedFile.isValid() && this.myDocumentWindow.isValid();
    }

    private void checkValid() {
        PsiUtilCore.ensureValid((PsiElement)this.myInjectedFile);
        if (!this.isValid()) {
            StringBuilder reason = new StringBuilder("Not valid");
            if (this.myDisposed) {
                reason.append("; editorWindow: disposed");
            }
            if (!this.myDocumentWindow.isValid()) {
                reason.append("; documentWindow: invalid");
            }
            if (this.myDelegate.isDisposed()) {
                reason.append("; editor: disposed");
            }
            if (this.myInjectedFile.getProject().isDisposed()) {
                reason.append("; project: disposed");
            }
            throw new AssertionError((Object)reason.toString());
        }
    }

    @Override
    @NotNull
    public PsiFile getInjectedFile() {
        return this.myInjectedFile;
    }

    @Override
    @NotNull
    public LogicalPosition hostToInjected(@NotNull LogicalPosition hPos) {
        LogicalPosition iPos;
        this.checkValid();
        DocumentEx hostDocument = this.myDelegate.getDocument();
        int hLineEndOffset = hPos.line >= hostDocument.getLineCount() ? hostDocument.getTextLength() : hostDocument.getLineEndOffset(hPos.line);
        LogicalPosition hLineEndPos = this.myDelegate.offsetToLogicalPosition(hLineEndOffset);
        if (hLineEndPos.column < hPos.column && (iPos = this.myDocumentWindow.hostToInjectedInVirtualSpace(hPos)) != null) {
            return iPos;
        }
        int hOffset = this.myDelegate.logicalPositionToOffset(hPos);
        int iOffset = this.myDocumentWindow.hostToInjected(hOffset);
        return this.offsetToLogicalPosition(iOffset);
    }

    @Override
    @NotNull
    public LogicalPosition injectedToHost(@NotNull LogicalPosition pos) {
        this.checkValid();
        int offset = this.logicalPositionToOffset(pos);
        LogicalPosition samePos = this.offsetToLogicalPosition(offset);
        int virtualSpaceDelta = offset < this.myDocumentWindow.getTextLength() && samePos.line == pos.line && samePos.column < pos.column ? pos.column - samePos.column : 0;
        LogicalPosition hostPos = this.myDelegate.offsetToLogicalPosition(this.myDocumentWindow.injectedToHost(offset));
        return new LogicalPosition(hostPos.line, hostPos.column + virtualSpaceDelta);
    }

    private void dispose() {
        assert (!this.myDisposed);
        this.myCaretModelDelegate.disposeModel();
        for (EditorMouseListener editorMouseListener : this.myEditorMouseListeners.wrappers()) {
            this.myDelegate.removeEditorMouseListener(editorMouseListener);
        }
        this.myEditorMouseListeners.clear();
        for (EditorMouseMotionListener editorMouseMotionListener : this.myEditorMouseMotionListeners.wrappers()) {
            this.myDelegate.removeEditorMouseMotionListener(editorMouseMotionListener);
        }
        this.myEditorMouseMotionListeners.clear();
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myDocumentWindow);
    }

    @Override
    public void setViewer(boolean isViewer) {
        this.myDelegate.setViewer(isViewer);
    }

    public boolean isViewer() {
        return this.myDelegate.isViewer();
    }

    @Override
    public boolean isRendererMode() {
        return this.myDelegate.isRendererMode();
    }

    @Override
    public void setRendererMode(boolean isRendererMode) {
        this.myDelegate.setRendererMode(isRendererMode);
    }

    @Override
    public void setFile(VirtualFile vFile) {
        this.myDelegate.setFile(vFile);
    }

    public void setHeaderComponent(@Nullable JComponent header2) {
    }

    public boolean hasHeaderComponent() {
        return false;
    }

    @Nullable
    public JComponent getHeaderComponent() {
        return null;
    }

    @Override
    public TextDrawingCallback getTextDrawingCallback() {
        return this.myDelegate.getTextDrawingCallback();
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.mySelectionModelDelegate;
    }

    @Override
    @NotNull
    public MarkupModelEx getMarkupModel() {
        return this.myMarkupModelDelegate;
    }

    @Override
    @NotNull
    public MarkupModelEx getFilteredDocumentMarkupModel() {
        return this.myDocumentMarkupModelDelegate;
    }

    @Override
    @NotNull
    public FoldingModelEx getFoldingModel() {
        return this.myFoldingModelWindow;
    }

    @NotNull
    public CaretModel getCaretModel() {
        return this.myCaretModelDelegate;
    }

    @Override
    @NotNull
    public ScrollingModelEx getScrollingModel() {
        return this.myDelegate.getScrollingModel();
    }

    @Override
    @NotNull
    public SoftWrapModelEx getSoftWrapModel() {
        return this.mySoftWrapModel;
    }

    @NotNull
    public EditorSettings getSettings() {
        return this.myDelegate.getSettings();
    }

    @NotNull
    public InlayModel getInlayModel() {
        return this.myInlayModel;
    }

    @NotNull
    public EditorKind getEditorKind() {
        return this.myDelegate.getEditorKind();
    }

    @Override
    public void reinitSettings() {
        this.myDelegate.reinitSettings();
    }

    @Override
    public void setFontSize(int fontSize) {
        this.myDelegate.setFontSize(fontSize);
    }

    @Override
    public void setHighlighter(@NotNull EditorHighlighter highlighter) {
        this.myDelegate.setHighlighter(highlighter);
    }

    @Override
    @NotNull
    public EditorHighlighter getHighlighter() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.myInjectedFile.getLanguage(), (Project)this.getProject(), (VirtualFile)this.myInjectedFile.getVirtualFile());
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((SyntaxHighlighter)syntaxHighlighter, (EditorColorsScheme)scheme);
        highlighter.setText((CharSequence)this.getDocument().getText());
        highlighter.setEditor((HighlighterClient)new LightHighlighterClient((Document)this.getDocument(), this.getProject()));
        return highlighter;
    }

    @Override
    public JComponent getPermanentHeaderComponent() {
        return this.myDelegate.getPermanentHeaderComponent();
    }

    @Override
    public void setPermanentHeaderComponent(JComponent component2) {
        this.myDelegate.setPermanentHeaderComponent(component2);
    }

    @NotNull
    public JComponent getContentComponent() {
        return this.myDelegate.getContentComponent();
    }

    @Override
    @NotNull
    public EditorGutterComponentEx getGutterComponentEx() {
        return this.myDelegate.getGutterComponentEx();
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myDelegate.addPropertyChangeListener(listener2);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        this.myDelegate.addPropertyChangeListener(listener2, parentDisposable);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myDelegate.removePropertyChangeListener(listener2);
    }

    @Override
    public void setInsertMode(boolean mode) {
        this.myDelegate.setInsertMode(mode);
    }

    public boolean isInsertMode() {
        return this.myDelegate.isInsertMode();
    }

    @Override
    public void setColumnMode(boolean mode) {
        this.myDelegate.setColumnMode(mode);
    }

    public boolean isColumnMode() {
        return this.myDelegate.isColumnMode();
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        return this.logicalToVisualPosition(this.xyToLogicalPosition(p));
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        this.checkValid();
        Point2D pp = p.getX() >= 0.0 && p.getY() >= 0.0 ? p : new Point2D.Double(Math.max(p.getX(), 0.0), Math.max(p.getY(), 0.0));
        LogicalPosition hostPos = this.myDelegate.visualToLogicalPosition(this.myDelegate.xyToVisualPosition(pp));
        return this.logicalToVisualPosition(this.hostToInjected(hostPos));
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        return this.logicalToVisualPosition(this.offsetToLogicalPosition(offset));
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        return this.logicalToVisualPosition(this.offsetToLogicalPosition(offset).leanForward(leanForward));
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        this.checkValid();
        int lineNumber = this.myDocumentWindow.getLineNumber(offset);
        int lineStartOffset = this.myDocumentWindow.getLineStartOffset(lineNumber);
        int column = this.calcLogicalColumnNumber(offset - lineStartOffset, lineNumber, lineStartOffset);
        return new LogicalPosition(lineNumber, column);
    }

    @Override
    @NotNull
    public EditorColorsScheme createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
        return this.myDelegate.createBoundColorSchemeDelegate(customGlobalScheme);
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        this.checkValid();
        LogicalPosition hostPos = this.myDelegate.xyToLogicalPosition(p);
        return this.hostToInjected(hostPos);
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        this.checkValid();
        LogicalPosition hostPos = this.injectedToHost(pos);
        return this.myDelegate.logicalPositionToXY(hostPos);
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition pos) {
        this.checkValid();
        return this.logicalPositionToXY(this.visualToLogicalPosition(pos));
    }

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition pos) {
        this.checkValid();
        LogicalPosition hostLogical = this.injectedToHost(this.visualToLogicalPosition(pos));
        VisualPosition hostVisual = this.myDelegate.logicalToVisualPosition(hostLogical);
        return this.myDelegate.visualPositionToPoint2D(hostVisual);
    }

    @Override
    public void repaint(int startOffset, int endOffset) {
        this.checkValid();
        this.myDelegate.repaint(this.myDocumentWindow.injectedToHost(startOffset), this.myDocumentWindow.injectedToHost(endOffset));
    }

    @Override
    @NotNull
    public DocumentWindowImpl getDocument() {
        return this.myDocumentWindow;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myDelegate.getComponent();
    }

    public void addEditorMouseListener(final @NotNull EditorMouseListener listener2) {
        this.checkValid();
        EditorMouseListener wrapper2 = new EditorMouseListener(){

            public void mousePressed(@NotNull EditorMouseEvent e) {
                listener2.mousePressed(EditorWindowImpl.this.convertEvent(e));
            }

            public void mouseClicked(@NotNull EditorMouseEvent e) {
                listener2.mouseClicked(EditorWindowImpl.this.convertEvent(e));
            }

            public void mouseReleased(@NotNull EditorMouseEvent e) {
                listener2.mouseReleased(EditorWindowImpl.this.convertEvent(e));
            }

            public void mouseEntered(@NotNull EditorMouseEvent e) {
                listener2.mouseEntered(EditorWindowImpl.this.convertEvent(e));
            }

            public void mouseExited(@NotNull EditorMouseEvent e) {
                listener2.mouseExited(EditorWindowImpl.this.convertEvent(e));
            }
        };
        this.myEditorMouseListeners.registerWrapper(listener2, wrapper2);
        this.myDelegate.addEditorMouseListener(wrapper2);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        EditorMouseListener wrapper2 = this.myEditorMouseListeners.removeWrapper(listener2);
        if (wrapper2 != null) {
            this.myDelegate.removeEditorMouseListener(wrapper2);
        }
    }

    public void addEditorMouseMotionListener(final @NotNull EditorMouseMotionListener listener2) {
        this.checkValid();
        EditorMouseMotionListener wrapper2 = new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                listener2.mouseMoved(EditorWindowImpl.this.convertEvent(e));
            }

            public void mouseDragged(@NotNull EditorMouseEvent e) {
                listener2.mouseDragged(EditorWindowImpl.this.convertEvent(e));
            }
        };
        this.myEditorMouseMotionListeners.registerWrapper(listener2, wrapper2);
        this.myDelegate.addEditorMouseMotionListener(wrapper2);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        EditorMouseMotionListener wrapper2 = this.myEditorMouseMotionListeners.removeWrapper(listener2);
        if (wrapper2 != null) {
            this.myDelegate.removeEditorMouseMotionListener(wrapper2);
        }
    }

    private EditorMouseEvent convertEvent(EditorMouseEvent originalEvent) {
        LogicalPosition logicalPosition = this.hostToInjected(originalEvent.getLogicalPosition());
        int offset = this.logicalPositionToOffset(logicalPosition);
        VisualPosition visualPosition = this.logicalToVisualPosition(logicalPosition);
        FoldRegion hostFoldRegion = originalEvent.getCollapsedFoldRegion();
        return new EditorMouseEvent((Editor)this, originalEvent.getMouseEvent(), originalEvent.getArea(), offset, logicalPosition, visualPosition, true, (FoldRegion)(hostFoldRegion == null ? null : FoldingRegionWindow.getInjectedRegion(hostFoldRegion)), null, null);
    }

    public boolean isDisposed() {
        return this.myDisposed || this.myDelegate.isDisposed();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.myDelegate.setBackgroundColor(color);
    }

    @Override
    @NotNull
    public Color getBackgroundColor() {
        return this.myDelegate.getBackgroundColor();
    }

    @Override
    public int getMaxWidthInRange(int startOffset, int endOffset) {
        return this.myDelegate.getMaxWidthInRange(startOffset, endOffset);
    }

    public int getLineHeight() {
        return this.myDelegate.getLineHeight();
    }

    @Override
    public Dimension getContentSize() {
        return this.myDelegate.getContentSize();
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        return this.myDelegate.getScrollPane();
    }

    public void setBorder(Border border) {
        this.myDelegate.setBorder(border);
    }

    public Insets getInsets() {
        return this.myDelegate.getInsets();
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        int lineStartOffset = this.myDocumentWindow.getLineStartOffset(pos.line);
        return this.calcOffset(pos.column, pos.line, lineStartOffset);
    }

    private int calcLogicalColumnNumber(int offsetInLine, int lineNumber, int lineStartOffset) {
        if (this.myDocumentWindow.getTextLength() == 0) {
            return 0;
        }
        if (offsetInLine == 0) {
            return 0;
        }
        int end = this.myDocumentWindow.getLineEndOffset(lineNumber);
        if (offsetInLine > end - lineStartOffset) {
            offsetInLine = end - lineStartOffset;
        }
        CharSequence text = this.myDocumentWindow.getCharsSequence();
        return EditorUtil.calcColumnNumber(this, text, lineStartOffset, lineStartOffset + offsetInLine);
    }

    private int calcOffset(int col, int lineNumber, int lineStartOffset) {
        CharSequence text = this.myDocumentWindow.getImmutableCharSequence();
        int tabSize = EditorUtil.getTabSize(this.myDelegate);
        int end = this.myDocumentWindow.getLineEndOffset(lineNumber);
        int currentColumn = 0;
        for (int i2 = lineStartOffset; i2 < end; ++i2) {
            char c = text.charAt(i2);
            currentColumn = c == '\t' ? (currentColumn / tabSize + 1) * tabSize : ++currentColumn;
            if (col >= currentColumn) continue;
            return i2;
        }
        return end;
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos) {
        this.checkValid();
        return new VisualPosition(pos.line, pos.column);
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        this.checkValid();
        return new LogicalPosition(pos.line, pos.column);
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        return this.myDelegate.getDataContext();
    }

    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        return this.myDelegate.getMouseEventArea(e);
    }

    @Override
    public boolean setCaretVisible(boolean b) {
        return this.myDelegate.setCaretVisible(b);
    }

    @Override
    public boolean setCaretEnabled(boolean enabled) {
        return this.myDelegate.setCaretEnabled(enabled);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2) {
        this.myDelegate.addFocusListener(listener2);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2, @NotNull Disposable parentDisposable) {
        this.myDelegate.addFocusListener(listener2, parentDisposable);
    }

    public Project getProject() {
        return this.myDelegate.getProject();
    }

    public boolean isOneLineMode() {
        return this.myOneLine;
    }

    @Override
    public void setOneLineMode(boolean isOneLineMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmbeddedIntoDialogWrapper() {
        return this.myDelegate.isEmbeddedIntoDialogWrapper();
    }

    @Override
    public void setEmbeddedIntoDialogWrapper(boolean b) {
        this.myDelegate.setEmbeddedIntoDialogWrapper(b);
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myDelegate.getVirtualFile();
    }

    @Override
    public CopyProvider getCopyProvider() {
        return this.myDelegate.getCopyProvider();
    }

    @Override
    public CutProvider getCutProvider() {
        return this.myDelegate.getCutProvider();
    }

    @Override
    public PasteProvider getPasteProvider() {
        return this.myDelegate.getPasteProvider();
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return this.myDelegate.getDeleteProvider();
    }

    @Override
    public void setColorsScheme(@NotNull EditorColorsScheme scheme) {
        this.myDelegate.setColorsScheme(scheme);
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        return this.myDelegate.getColorsScheme();
    }

    @Override
    public void setVerticalScrollbarOrientation(int type) {
        this.myDelegate.setVerticalScrollbarOrientation(type);
    }

    @Override
    public int getVerticalScrollbarOrientation() {
        return this.myDelegate.getVerticalScrollbarOrientation();
    }

    @Override
    public void setVerticalScrollbarVisible(boolean b) {
        this.myDelegate.setVerticalScrollbarVisible(b);
    }

    @Override
    public void setHorizontalScrollbarVisible(boolean b) {
        this.myDelegate.setHorizontalScrollbarVisible(b);
    }

    @Override
    public boolean processKeyTyped(@NotNull KeyEvent e) {
        return this.myDelegate.processKeyTyped(e);
    }

    @NotNull
    public EditorGutter getGutter() {
        return this.myDelegate.getGutter();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditorWindowImpl that = (EditorWindowImpl)o;
        DocumentWindowImpl thatWindow = that.getDocument();
        return this.myDelegate.equals(that.myDelegate) && this.myDocumentWindow.equals(thatWindow);
    }

    public int hashCode() {
        return this.myDocumentWindow.hashCode();
    }

    @Override
    @NotNull
    public Editor getDelegate() {
        return this.myDelegate;
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        return this.myDelegate.getIndentsModel();
    }

    @Override
    public void setPlaceholder(@Nullable CharSequence text) {
        this.myDelegate.setPlaceholder(text);
    }

    @Override
    public void setPlaceholderAttributes(@Nullable TextAttributes attributes) {
        this.myDelegate.setPlaceholderAttributes(attributes);
    }

    @Override
    public void setShowPlaceholderWhenFocused(boolean show2) {
        this.myDelegate.setShowPlaceholderWhenFocused(show2);
    }

    @Override
    public boolean isStickySelection() {
        return this.myDelegate.isStickySelection();
    }

    @Override
    public void setStickySelection(boolean enable) {
        this.myDelegate.setStickySelection(enable);
    }

    @Override
    public boolean isPurePaintingMode() {
        return this.myDelegate.isPurePaintingMode();
    }

    @Override
    public void setPurePaintingMode(boolean enabled) {
        this.myDelegate.setPurePaintingMode(enabled);
    }

    @Override
    public void registerLineExtensionPainter(IntFunction<Collection<LineExtensionInfo>> lineExtensionPainter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerScrollBarRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback2) {
        this.myDelegate.registerScrollBarRepaintCallback(callback2);
    }

    @Override
    public void setPrefixTextAndAttributes(@Nullable String prefixText, @Nullable TextAttributes attributes) {
        this.myDelegate.setPrefixTextAndAttributes(prefixText, attributes);
    }

    @Override
    public int getPrefixTextWidthInPixels() {
        return this.myDelegate.getPrefixTextWidthInPixels();
    }

    public String toString() {
        return super.toString() + "[disposed=" + this.myDisposed + "; valid=" + this.isValid() + "]";
    }

    @Override
    public int getExpectedCaretOffset() {
        return this.myDocumentWindow.hostToInjected(this.myDelegate.getExpectedCaretOffset());
    }

    @Override
    public void setContextMenuGroupId(@Nullable String groupId2) {
        this.myDelegate.setContextMenuGroupId(groupId2);
    }

    @Override
    @Nullable
    public String getContextMenuGroupId() {
        return this.myDelegate.getContextMenuGroupId();
    }

    @Override
    public void installPopupHandler(@NotNull EditorPopupHandler popupHandler) {
        this.myDelegate.installPopupHandler(popupHandler);
    }

    @Override
    public void uninstallPopupHandler(@NotNull EditorPopupHandler popupHandler) {
        this.myDelegate.installPopupHandler(popupHandler);
    }

    @Override
    public void setCustomCursor(@NotNull Object requestor, @Nullable Cursor cursor) {
        this.myDelegate.setCustomCursor(requestor, cursor);
    }

    public int getAscent() {
        return this.myDelegate.getAscent();
    }
}

