/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class FileTargetContext {
    @NotNull
    private final PsiFileSystemItem myContext;
    private final String @NotNull [] myPathToCreate;

    public FileTargetContext(@NotNull PsiFileSystemItem context, String @NotNull [] pathToCreate) {
        this.myContext = context;
        this.myPathToCreate = pathToCreate;
    }

    public FileTargetContext(@NotNull PsiFileSystemItem context) {
        this(context, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public PsiFileSystemItem getFileSystemItem() {
        return this.myContext;
    }

    public String @NotNull [] getPathToCreate() {
        return this.myPathToCreate;
    }

    public static Collection<FileTargetContext> toTargetContexts(Collection<PsiFileSystemItem> items) {
        return ContainerUtil.map(items, FileTargetContext::new);
    }

    public static Collection<FileTargetContext> toTargetContexts(PsiFileSystemItem item) {
        return Collections.singletonList(new FileTargetContext(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTargetContext context = (FileTargetContext)o;
        return this.myContext.equals(context.myContext) && Arrays.equals(this.myPathToCreate, context.myPathToCreate);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.myContext);
        result2 = 31 * result2 + Arrays.hashCode(this.myPathToCreate);
        return result2;
    }
}

