/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemanticEditorPosition {
    private final EditorEx myEditor;
    private final HighlighterIterator myIterator;
    private final CharSequence myChars;
    private final Function<IElementType, SyntaxElement> myTypeMapper;
    private final BiFunction<? super EditorEx, ? super Integer, ? extends HighlighterIterator> myCreateHighlighterIteratorAtOffset;

    private SemanticEditorPosition(@NotNull EditorEx editor, int offset, @NotNull BiFunction<? super EditorEx, ? super Integer, ? extends HighlighterIterator> createHighlighterIteratorAtOffset, @NotNull Function<IElementType, SyntaxElement> typeMapper) {
        this.myCreateHighlighterIteratorAtOffset = createHighlighterIteratorAtOffset;
        this.myEditor = editor;
        this.myChars = this.myEditor.getDocument().getCharsSequence();
        this.myIterator = createHighlighterIteratorAtOffset.apply(editor, (Integer)offset);
        this.myTypeMapper = typeMapper;
    }

    public void moveBeforeOptional(@NotNull SyntaxElement syntaxElement) {
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition beforeOptional(@NotNull SyntaxElement syntaxElement) {
        return this.copyAnd(position -> position.moveBeforeOptional(syntaxElement));
    }

    public void moveBeforeOptionalMix(SyntaxElement ... elements2) {
        while (this.isAtAnyOf(elements2)) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition beforeOptionalMix(SyntaxElement ... elements2) {
        return this.copyAnd(position -> position.moveBeforeOptionalMix(elements2));
    }

    public void moveAfterOptionalMix(SyntaxElement ... elements2) {
        while (this.isAtAnyOf(elements2)) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition afterOptionalMix(SyntaxElement ... elements2) {
        return this.copyAnd(position -> position.moveAfterOptionalMix(elements2));
    }

    public boolean isAtMultiline() {
        if (!this.myIterator.atEnd()) {
            return CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
        }
        return false;
    }

    public boolean hasLineBreaksAfter(int offset) {
        int offsetAfter;
        if (!this.myIterator.atEnd() && offset >= 0 && (offsetAfter = offset + 1) < this.myIterator.getEnd()) {
            return CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)offsetAfter, (int)this.myIterator.getEnd());
        }
        return false;
    }

    public boolean isAtMultiline(SyntaxElement ... elements2) {
        return this.isAtAnyOf(elements2) && CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
    }

    public void moveBefore() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition before() {
        return this.copyAnd(position -> position.moveBefore());
    }

    public void moveAfterOptional(@NotNull SyntaxElement syntaxElement) {
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition afterOptional(@NotNull SyntaxElement syntaxElement) {
        return this.copyAnd(position -> position.moveAfterOptional(syntaxElement));
    }

    public void moveAfter() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.advance();
        }
    }

    public SemanticEditorPosition after() {
        return this.copyAnd(position -> position.moveAfter());
    }

    public void moveBeforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        this.skipParentheses(false, leftParenthesis, rightParenthesis);
    }

    public void moveAfterParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        this.skipParentheses(true, leftParenthesis, rightParenthesis);
    }

    protected void skipParentheses(boolean forward, @NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        int parenLevel = 0;
        while (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            if (forward) {
                this.myIterator.advance();
            } else {
                this.myIterator.retreat();
            }
            if (rightParenthesis.equals(currElement)) {
                ++parenLevel;
                continue;
            }
            if (!leftParenthesis.equals(currElement) || --parenLevel >= 1) continue;
            break;
        }
    }

    public SemanticEditorPosition beforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        return this.copyAnd(position -> position.moveBeforeParentheses(leftParenthesis, rightParenthesis));
    }

    public void moveToLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        this.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate(leftParenthesis, rightParenthesis, any -> false);
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        return this.copyAnd(position -> position.moveToLeftParenthesisBackwardsSkippingNested(leftParenthesis, rightParenthesis));
    }

    public void moveToLeftParenthesisBackwardsSkippingNestedWithPredicate(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Predicate<? super SemanticEditorPosition> terminationCondition) {
        while (!this.myIterator.atEnd() && !terminationCondition.test(this)) {
            if (rightParenthesis.equals(this.map(this.myIterator.getTokenType()))) {
                this.moveBeforeParentheses(leftParenthesis, rightParenthesis);
                continue;
            }
            if (leftParenthesis.equals(this.map(this.myIterator.getTokenType()))) break;
            this.myIterator.retreat();
        }
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNestedWithPredicate(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Predicate<? super SemanticEditorPosition> terminationCondition) {
        return this.copyAnd(position -> position.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate(leftParenthesis, rightParenthesis, terminationCondition));
    }

    public boolean isAfterOnSameLine(SyntaxElement ... syntaxElements) {
        return this.elementAfterOnSameLine(syntaxElements) != null;
    }

    @Nullable
    public SyntaxElement elementAfterOnSameLine(SyntaxElement ... syntaxElements) {
        this.myIterator.retreat();
        while (!this.myIterator.atEnd() && !this.isAtMultiline()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element2 : syntaxElements) {
                if (!element2.equals(currElement)) continue;
                return element2;
            }
            this.myIterator.retreat();
        }
        return null;
    }

    public boolean isAt(@NotNull SyntaxElement syntaxElement) {
        return !this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()));
    }

    public boolean isAt(@NotNull IElementType elementType) {
        return !this.myIterator.atEnd() && this.myIterator.getTokenType() == elementType;
    }

    public boolean isAtEnd() {
        return this.myIterator.atEnd();
    }

    public int getStartOffset() {
        return this.myIterator.getStart();
    }

    public boolean isAtAnyOf(SyntaxElement ... syntaxElements) {
        if (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element2 : syntaxElements) {
                if (!element2.equals(currElement)) continue;
                return true;
            }
        }
        return false;
    }

    public CharSequence getChars() {
        return this.myChars;
    }

    public int findStartOf(@NotNull SyntaxElement element2) {
        while (!this.myIterator.atEnd()) {
            if (element2.equals(this.map(this.myIterator.getTokenType()))) {
                return this.myIterator.getStart();
            }
            this.myIterator.retreat();
        }
        return -1;
    }

    public boolean hasEmptyLineAfter(int offset) {
        for (int i2 = offset + 1; i2 < this.myIterator.getEnd(); ++i2) {
            if (this.myChars.charAt(i2) != '\n') continue;
            return true;
        }
        return false;
    }

    public EditorEx getEditor() {
        return this.myEditor;
    }

    @Nullable
    public Language getLanguage() {
        return !this.myIterator.atEnd() ? this.myIterator.getTokenType().getLanguage() : null;
    }

    public boolean isAtLanguage(@Nullable Language language) {
        if (language != null && !this.myIterator.atEnd()) {
            return language == Language.ANY || this.myIterator.getTokenType().getLanguage().is(language);
        }
        return false;
    }

    @Nullable
    public SyntaxElement getCurrElement() {
        return !this.myIterator.atEnd() ? this.map(this.myIterator.getTokenType()) : null;
    }

    public boolean matchesRule(@NotNull Rule rule) {
        return rule.check(this);
    }

    public SyntaxElement map(@NotNull IElementType elementType) {
        return this.myTypeMapper.apply(elementType);
    }

    public String toString() {
        return this.myIterator.atEnd() ? "atEnd" : this.myIterator.getTokenType().toString() + "=>" + this.getChars().subSequence(this.getStartOffset(), Integer.min(this.getStartOffset() + 255, this.getChars().length()));
    }

    public SemanticEditorPosition copy() {
        return SemanticEditorPosition.createEditorPosition(this.myEditor, this.isAtEnd() ? -1 : this.myIterator.getStart(), (editor, offset) -> !this.isAtEnd() ? this.myCreateHighlighterIteratorAtOffset.apply((EditorEx)editor, (Integer)offset) : new HighlighterIteratorWrapper(this.myIterator){

            @Override
            public void advance() {
            }

            @Override
            public void retreat() {
            }
        }, this.myTypeMapper);
    }

    public SemanticEditorPosition copyAnd(@NotNull Consumer<? super SemanticEditorPosition> modifier) {
        SemanticEditorPosition position = this.copy();
        modifier.accept(position);
        return position;
    }

    @NotNull
    public static SemanticEditorPosition createEditorPosition(@NotNull EditorEx editor, int offset, @NotNull BiFunction<? super EditorEx, ? super Integer, ? extends HighlighterIterator> createHighlighterIteratorAtOffset, @NotNull Function<IElementType, SyntaxElement> typeMapper) {
        return new SemanticEditorPosition(editor, offset, createHighlighterIteratorAtOffset, typeMapper);
    }

    public static interface Rule {
        public boolean check(SemanticEditorPosition var1);
    }

    public static interface SyntaxElement {
    }
}

