/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsProvider;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleSchemesImpl
extends CodeStyleSchemes {
    @NonNls
    static final String CODE_STYLES_DIR_PATH = "codestyles";
    protected final SchemeManager<CodeStyleScheme> mySchemeManager;

    public CodeStyleSchemesImpl(@NotNull SchemeManagerFactory schemeManagerFactory) {
        this.mySchemeManager = schemeManagerFactory.create(CODE_STYLES_DIR_PATH, new LazySchemeProcessor<CodeStyleScheme, CodeStyleSchemeImpl>(){

            @Override
            @NotNull
            public CodeStyleSchemeImpl createScheme(@NotNull SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
                return new CodeStyleSchemeImpl(attributeProvider.apply("name"), attributeProvider.apply("parent"), dataHolder);
            }
        });
        this.mySchemeManager.loadSchemes();
        this.setCurrentScheme(this.getDefaultScheme());
        FileTypeIndentOptionsProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileTypeIndentOptionsProvider>(){

            public void extensionAdded(@NotNull FileTypeIndentOptionsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                CodeStyleSettingsManager.getInstance().registerFileTypeIndentOptions((Collection)CodeStyleSchemesImpl.this.getAllSettings(), extension.getFileType(), extension.createIndentOptions());
            }

            public void extensionRemoved(@NotNull FileTypeIndentOptionsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                CodeStyleSettingsManager.getInstance().unregisterFileTypeIndentOptions((Collection)CodeStyleSchemesImpl.this.getAllSettings(), extension.getFileType());
            }
        }, (Disposable)ApplicationManager.getApplication());
        LanguageCodeStyleSettingsProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<LanguageCodeStyleSettingsProvider>(){

            public void extensionAdded(@NotNull LanguageCodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                ObjectUtils.consumeIfNotNull((Object)CodeStyleSettingsManager.getInstance(), manager -> {
                    manager.registerLanguageSettings((Collection)CodeStyleSchemesImpl.this.getAllSettings(), extension);
                    manager.registerCustomSettings((Collection)CodeStyleSchemesImpl.this.getAllSettings(), (CodeStyleSettingsProvider)extension);
                });
            }

            public void extensionRemoved(@NotNull LanguageCodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                ObjectUtils.consumeIfNotNull((Object)CodeStyleSettingsManager.getInstance(), manager -> {
                    manager.unregisterLanguageSettings((Collection)CodeStyleSchemesImpl.this.getAllSettings(), extension);
                    manager.unregisterCustomSettings((Collection)CodeStyleSchemesImpl.this.getAllSettings(), (CodeStyleSettingsProvider)extension);
                });
            }
        }, (Disposable)ApplicationManager.getApplication());
        CodeStyleSettingsProvider.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CodeStyleSettingsProvider>(){

            public void extensionAdded(@NotNull CodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                ObjectUtils.consumeIfNotNull((Object)CodeStyleSettingsManager.getInstance(), instance -> instance.registerCustomSettings((Collection)CodeStyleSchemesImpl.this.getAllSettings(), extension));
            }

            public void extensionRemoved(@NotNull CodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                ObjectUtils.consumeIfNotNull((Object)CodeStyleSettingsManager.getInstance(), instance -> instance.unregisterCustomSettings((Collection)CodeStyleSchemesImpl.this.getAllSettings(), extension));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    private List<CodeStyleSettings> getAllSettings() {
        return ContainerUtil.map(this.mySchemeManager.getAllSchemes(), scheme -> scheme.getCodeStyleSettings());
    }

    @Transient
    public CodeStyleScheme getCurrentScheme() {
        return this.mySchemeManager.getActiveScheme();
    }

    public void setCurrentScheme(CodeStyleScheme scheme) {
        this.mySchemeManager.setCurrent(scheme);
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        return new CodeStyleSchemeImpl(SchemeNameGenerator.getUniqueName(preferredName, (Scheme)parentScheme, name -> this.mySchemeManager.findSchemeByName((String)name) != null), false, parentScheme);
    }

    public void deleteScheme(@NotNull CodeStyleScheme scheme) {
        if (scheme.isDefault()) {
            throw new IllegalArgumentException("Unable to delete default scheme!");
        }
        CodeStyleSchemeImpl currentScheme = (CodeStyleSchemeImpl)this.getCurrentScheme();
        if (currentScheme == scheme) {
            CodeStyleScheme newCurrentScheme = this.getDefaultScheme();
            if (newCurrentScheme == null) {
                throw new IllegalStateException("Unable to load default scheme!");
            }
            this.setCurrentScheme(newCurrentScheme);
        }
        this.mySchemeManager.removeScheme(scheme);
    }

    public CodeStyleScheme getDefaultScheme() {
        CodeStyleScheme defaultScheme = this.mySchemeManager.findSchemeByName("Default");
        if (defaultScheme == null) {
            defaultScheme = new CodeStyleSchemeImpl("Default", true, null);
            this.addScheme(defaultScheme);
        }
        return defaultScheme;
    }

    @Nullable
    public CodeStyleScheme findSchemeByName(@NotNull String name) {
        return this.mySchemeManager.findSchemeByName(name);
    }

    public void addScheme(@NotNull CodeStyleScheme scheme) {
        this.mySchemeManager.addScheme(scheme);
    }

    @NotNull
    public static SchemeManager<CodeStyleScheme> getSchemeManager() {
        return ((CodeStyleSchemesImpl)CodeStyleSchemes.getInstance()).mySchemeManager;
    }
}

