/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.diagnostic.PluginException;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterImpl;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ChangedRangesUtil;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerRunnable;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.codeStyle.IndentImpl;
import com.intellij.psi.impl.source.codeStyle.NewLineIndentMarkerProvider;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.lineIndent.FormatterBasedIndentAdjuster;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.MathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleManagerImpl
extends CodeStyleManager
implements FormattingModeAwareIndentAdjuster {
    private static final Logger LOG = Logger.getInstance(CodeStyleManagerImpl.class);
    private static final ThreadLocal<ProcessingUnderProgressInfo> SEQUENTIAL_PROCESSING_ALLOWED = ThreadLocal.withInitial(() -> new ProcessingUnderProgressInfo());
    private final ThreadLocal<FormattingMode> myCurrentFormattingMode = ThreadLocal.withInitial(() -> FormattingMode.REFORMAT);
    private final Project myProject;
    @NonNls
    private static final String DUMMY_IDENTIFIER = "xxx";

    public CodeStyleManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element2) throws IncorrectOperationException {
        return this.reformat(element2, false);
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element2, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        CheckUtil.checkWritable(element2);
        if (!SourceTreeToPsiMap.hasTreeElement(element2)) {
            return element2;
        }
        ASTNode treeElement = element2.getNode();
        PsiFile file2 = element2.getContainingFile();
        if (ExternalFormatProcessor.useExternalFormatter(file2)) {
            return ExternalFormatProcessor.formatElement(element2, element2.getTextRange(), canChangeWhiteSpacesOnly);
        }
        PsiElement formatted = new CodeFormatterFacade(CodeStyleManagerImpl.getSettings(file2), element2.getLanguage(), canChangeWhiteSpacesOnly).processElement(treeElement).getPsi();
        if (!canChangeWhiteSpacesOnly) {
            return CodeStyleManagerImpl.postProcessElement(file2, formatted);
        }
        return formatted;
    }

    private static PsiElement postProcessElement(@NotNull PsiFile file2, @NotNull PsiElement formatted) {
        PsiElement result2 = formatted;
        CodeStyleSettings settingsForFile = CodeStyle.getSettings((PsiFile)file2);
        if (settingsForFile.FORMATTER_TAGS_ENABLED && formatted instanceof PsiFile) {
            CodeStyleManagerImpl.postProcessEnabledRanges((PsiFile)formatted, formatted.getTextRange(), settingsForFile);
        } else {
            for (PostFormatProcessor postFormatProcessor : PostFormatProcessor.EP_NAME.getExtensionList()) {
                try {
                    result2 = postFormatProcessor.processElement(result2, settingsForFile);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error((Throwable)PluginException.createByClass((Throwable)e, postFormatProcessor.getClass()));
                }
            }
        }
        return result2;
    }

    private static void postProcessText(@NotNull PsiFile file2, @NotNull TextRange textRange) {
        if (!CodeStyleManagerImpl.getSettings((PsiFile)file2).FORMATTER_TAGS_ENABLED) {
            TextRange currentRange = textRange;
            for (PostFormatProcessor myPostFormatProcessor : PostFormatProcessor.EP_NAME.getExtensionList()) {
                currentRange = myPostFormatProcessor.processText(file2, currentRange, CodeStyleManagerImpl.getSettings(file2));
            }
        } else {
            CodeStyleManagerImpl.postProcessEnabledRanges(file2, textRange, CodeStyleManagerImpl.getSettings(file2));
        }
    }

    public PsiElement reformatRange(@NotNull PsiElement element2, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        return CodeStyleManagerImpl.reformatRangeImpl(element2, startOffset, endOffset, canChangeWhiteSpacesOnly);
    }

    public PsiElement reformatRange(@NotNull PsiElement element2, int startOffset, int endOffset) throws IncorrectOperationException {
        return CodeStyleManagerImpl.reformatRangeImpl(element2, startOffset, endOffset, false);
    }

    private static void transformAllChildren(ASTNode file2) {
        ((TreeElement)file2).acceptTree(new RecursiveTreeElementWalkingVisitor(){});
    }

    public void reformatText(@NotNull PsiFile file2, int startOffset, int endOffset) throws IncorrectOperationException {
        this.reformatText(file2, Collections.singleton(new TextRange(startOffset, endOffset)));
    }

    public void reformatText(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges) throws IncorrectOperationException {
        this.reformatText(file2, ranges, null);
    }

    public void reformatTextWithContext(@NotNull PsiFile file2, @NotNull ChangedRangesInfo info) throws IncorrectOperationException {
        this.ensureDocumentCommitted(file2);
        FormatTextRanges formatRanges = new FormatTextRanges(info, ChangedRangesUtil.processChangedRanges(file2, info));
        formatRanges.setExtendToContext(true);
        this.reformatText(file2, formatRanges, null);
    }

    public void reformatText(@NotNull PsiFile file2, @NotNull Collection<? extends TextRange> ranges, @Nullable Editor editor) throws IncorrectOperationException {
        FormatTextRanges formatRanges = new FormatTextRanges();
        ranges.forEach(range2 -> formatRanges.add((TextRange)range2, true));
        this.reformatText(file2, formatRanges, editor);
    }

    private void reformatText(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, @Nullable Editor editor) throws IncorrectOperationException {
        if (ranges.isEmpty()) {
            return;
        }
        this.ensureDocumentCommitted(file2);
        CheckUtil.checkWritable((PsiElement)file2);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file2)) {
            return;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)file2);
        CodeStyleManagerImpl.transformAllChildren(treeElement);
        LOG.assertTrue(file2.isValid(), (Object)("File name: " + file2.getName() + " , class: " + file2.getClass().getSimpleName()));
        if (editor == null) {
            editor = PsiEditorUtil.findEditor((PsiElement)file2);
        }
        CaretPositionKeeper caretKeeper = null;
        if (editor != null) {
            caretKeeper = new CaretPositionKeeper(editor, CodeStyleManagerImpl.getSettings(file2), file2.getLanguage());
        }
        if (FormatterUtil.isFormatterCalledExplicitly()) {
            CodeStyleManagerImpl.removeEndingWhiteSpaceFromEachRange(file2, ranges);
        }
        CodeStyleManagerImpl.formatRanges(file2, ranges, ExternalFormatProcessor.useExternalFormatter(file2) ? null : () -> {
            CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CodeStyleManagerImpl.getSettings(file2), file2.getLanguage());
            codeFormatter.processText(file2, ranges, true);
        });
        if (caretKeeper != null) {
            caretKeeper.restoreCaretPosition();
        }
    }

    private void ensureDocumentCommitted(@NotNull PsiFile file2) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = documentManager.getDocument(file2);
        if (document != null) {
            documentManager.commitDocument(document);
        }
    }

    public static void formatRanges(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, @Nullable Runnable formatAction) {
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)file2.getProject());
        ArrayList<RangeFormatInfo> infos = new ArrayList<RangeFormatInfo>();
        for (TextRange range2 : ranges.getTextRanges()) {
            PsiElement start2 = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, range2.getStartOffset());
            PsiElement end = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, range2.getEndOffset());
            if (start2 != null && !start2.isValid()) {
                LOG.error("start=" + start2 + "; file=" + file2);
            }
            if (end != null && !end.isValid()) {
                LOG.error("end=" + start2 + "; end=" + file2);
            }
            boolean formatFromStart = range2.getStartOffset() == 0;
            boolean formatToEnd = range2.getEndOffset() == file2.getTextLength();
            infos.add(new RangeFormatInfo(start2 == null ? null : smartPointerManager.createSmartPsiElementPointer(start2), end == null ? null : smartPointerManager.createSmartPsiElementPointer(end), formatFromStart, formatToEnd));
        }
        if (formatAction != null) {
            formatAction.run();
        }
        for (RangeFormatInfo info : infos) {
            PsiElement endElement;
            PsiElement startElement = info.startPointer == null ? null : info.startPointer.getElement();
            PsiElement psiElement = endElement = info.endPointer == null ? null : info.endPointer.getElement();
            if ((startElement != null || info.fromStart) && (endElement != null || info.toEnd)) {
                CodeStyleManagerImpl.postProcessText(file2, new TextRange(info.fromStart ? 0 : startElement.getTextRange().getStartOffset(), info.toEnd ? file2.getTextLength() : endElement.getTextRange().getEndOffset()));
            }
            if (info.startPointer != null) {
                smartPointerManager.removePointer(info.startPointer);
            }
            if (info.endPointer == null) continue;
            smartPointerManager.removePointer(info.endPointer);
        }
    }

    private static void removeEndingWhiteSpaceFromEachRange(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges) {
        for (FormatTextRange formatRange : ranges.getRanges()) {
            PsiElement prev;
            TextRange range2 = formatRange.getTextRange();
            int rangeStart = range2.getStartOffset();
            int rangeEnd = range2.getEndOffset();
            PsiElement lastElementInRange = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, rangeEnd);
            if (!(lastElementInRange instanceof PsiWhiteSpace) || rangeStart >= lastElementInRange.getTextRange().getStartOffset() || (prev = lastElementInRange.getPrevSibling()) == null) continue;
            int newEnd = prev.getTextRange().getEndOffset();
            formatRange.setTextRange(new TextRange(rangeStart, newEnd));
        }
    }

    private static PsiElement reformatRangeImpl(@NotNull PsiElement element2, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        LOG.assertTrue(element2.isValid());
        CheckUtil.checkWritable(element2);
        if (!SourceTreeToPsiMap.hasTreeElement(element2)) {
            return element2;
        }
        ASTNode treeElement = element2.getNode();
        PsiFile file2 = element2.getContainingFile();
        if (ExternalFormatProcessor.useExternalFormatter(file2)) {
            return ExternalFormatProcessor.formatElement(element2, TextRange.create((int)startOffset, (int)endOffset), canChangeWhiteSpacesOnly);
        }
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CodeStyleManagerImpl.getSettings(file2), element2.getLanguage());
        PsiElement formatted = codeFormatter.processRange(treeElement, startOffset, endOffset).getPsi();
        return canChangeWhiteSpacesOnly ? formatted : CodeStyleManagerImpl.postProcessElement(file2, formatted);
    }

    public void reformatNewlyAddedElement(@NotNull ASTNode parent, @NotNull ASTNode addedElement) throws IncorrectOperationException {
        FormattingModelBuilder builder2;
        LOG.assertTrue(addedElement.getTreeParent() == parent, (Object)"addedElement must be added to parent");
        PsiElement psiElement = parent.getPsi();
        PsiFile containingFile = psiElement.getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            containingFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        }
        assert (containingFile != null);
        TextRange textRange = addedElement.getTextRange();
        Document document = fileViewProvider.getDocument();
        if (document instanceof DocumentWindow) {
            containingFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getTopLevelFile((PsiElement)containingFile);
            textRange = ((DocumentWindow)document).injectedToHost(textRange);
        }
        if ((builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)containingFile)) != null) {
            FormattingModel model = CoreFormatterUtil.buildModel(builder2, (PsiElement)containingFile, CodeStyleManagerImpl.getSettings(containingFile), FormattingMode.REFORMAT);
            FormatterEx.getInstanceEx().formatAroundRange(model, CodeStyleManagerImpl.getSettings(containingFile), containingFile, textRange);
        }
        this.adjustLineIndent(containingFile, textRange);
    }

    public int adjustLineIndent(@NotNull PsiFile file2, int offset) throws IncorrectOperationException {
        return (Integer)PostprocessReformattingAspect.getInstance(file2.getProject()).disablePostprocessFormattingInside(() -> this.doAdjustLineIndentByOffset(file2, offset, FormattingMode.ADJUST_INDENT));
    }

    @Nullable
    static PsiElement findElementInTreeWithFormatterEnabled(PsiFile file2, int offset) {
        PsiElement bottomost = file2.findElementAt(offset);
        if (bottomost != null && LanguageFormatting.INSTANCE.forContext(bottomost) != null) {
            return bottomost;
        }
        Language fileLang = file2.getLanguage();
        if (fileLang instanceof CompositeLanguage) {
            return file2.getViewProvider().findElementAt(offset, fileLang);
        }
        return bottomost;
    }

    public int adjustLineIndent(@NotNull Document document, int offset, FormattingMode mode) {
        return (Integer)PostprocessReformattingAspect.getInstance(this.getProject()).disablePostprocessFormattingInside(() -> {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(document);
            PsiFile file2 = documentManager.getPsiFile(document);
            if (file2 == null) {
                return offset;
            }
            return this.doAdjustLineIndentByOffset(file2, offset, mode);
        });
    }

    public int adjustLineIndent(@NotNull Document document, int offset) {
        return this.adjustLineIndent(document, offset, FormattingMode.ADJUST_INDENT);
    }

    private int doAdjustLineIndentByOffset(@NotNull PsiFile file2, int offset, FormattingMode mode) {
        Integer result2 = new CodeStyleManagerRunnable<Integer>(this, mode){

            @Override
            protected Integer doPerform(int offset, TextRange range2) {
                return FormatterEx.getInstanceEx().adjustLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }

            @Override
            protected Integer computeValueInsidePlainComment(PsiFile file2, int offset, Integer defaultValue) {
                return CharArrayUtil.shiftForward((CharSequence)file2.getViewProvider().getContents(), (int)offset, (String)" \t");
            }

            @Override
            protected Integer adjustResultForInjected(Integer result2, DocumentWindow documentWindow) {
                return result2 != null ? Integer.valueOf(documentWindow.hostToInjected(result2.intValue())) : null;
            }
        }.perform(file2, offset, null, null);
        return result2 != null ? result2 : offset;
    }

    public void adjustLineIndent(@NotNull PsiFile file2, TextRange rangeToAdjust) throws IncorrectOperationException {
        new CodeStyleManagerRunnable<Object>(this, FormattingMode.ADJUST_INDENT){

            @Override
            protected Object doPerform(int offset, TextRange range2) {
                FormatterEx.getInstanceEx().adjustLineIndentsForRange(this.myModel, this.mySettings, this.myIndentOptions, range2);
                return null;
            }
        }.perform(file2, -1, rangeToAdjust, null);
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset) {
        return this.getLineIndent(file2, offset, FormattingMode.ADJUST_INDENT);
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset, FormattingMode mode) {
        return new CodeStyleManagerRunnable<String>(this, mode){

            @Override
            protected boolean useDocumentBaseFormattingModel() {
                return false;
            }

            @Override
            protected String doPerform(int offset, TextRange range2) {
                return FormatterEx.getInstanceEx().getLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }
        }.perform(file2, offset, null, null);
    }

    @Nullable
    public String getLineIndent(@NotNull Document document, int offset) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file2 == null) {
            return "";
        }
        return this.getLineIndent(file2, offset);
    }

    @Deprecated
    public boolean isLineToBeIndented(@NotNull PsiFile file2, int offset) {
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file2)) {
            return false;
        }
        CharSequence chars = file2.getViewProvider().getContents();
        int start2 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (start2 > 0 && chars.charAt(start2) != '\n' && chars.charAt(start2) != '\r') {
            return false;
        }
        int end = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        if (end >= chars.length()) {
            return false;
        }
        ASTNode element2 = SourceTreeToPsiMap.psiElementToTree(CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, end));
        if (element2 == null) {
            return false;
        }
        if (element2.getElementType() == TokenType.WHITE_SPACE) {
            return false;
        }
        if (element2.getElementType() == PlainTextTokenTypes.PLAIN_TEXT) {
            return false;
        }
        return !CodeStyleManagerImpl.getSettings((PsiFile)file2).getCommonSettings((Language)file2.getLanguage()).KEEP_FIRST_COLUMN_COMMENT || !CodeStyleManagerImpl.isCommentToken(element2) || IndentHelper.getInstance().getIndent(this.myProject, file2.getFileType(), element2, true) != 0;
    }

    private static boolean isCommentToken(ASTNode element2) {
        Language language = element2.getElementType().getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter documentationAwareCommenter = (CodeDocumentationAwareCommenter)commenter;
            return element2.getElementType() == documentationAwareCommenter.getBlockCommentTokenType() || element2.getElementType() == documentationAwareCommenter.getLineCommentTokenType();
        }
        return false;
    }

    private static boolean isWhiteSpaceSymbol(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    @Nullable
    public static TextRange insertNewLineIndentMarker(@NotNull PsiFile file2, @NotNull Document document, int offset) {
        CharSequence text = document.getImmutableCharSequence();
        if (offset <= 0 || offset >= text.length() || !CodeStyleManagerImpl.isWhiteSpaceSymbol(text.charAt(offset))) {
            return null;
        }
        if (!CodeStyleManagerImpl.isWhiteSpaceSymbol(text.charAt(offset - 1))) {
            return null;
        }
        for (int end = offset; end < text.length() && text.charAt(end) != '\n'; ++end) {
            if (CodeStyleManagerImpl.isWhiteSpaceSymbol(text.charAt(end))) continue;
            return null;
        }
        String marker = CodeStyleManagerImpl.createMarker(file2, offset);
        document.insertString(offset, (CharSequence)marker);
        return new TextRange(offset, offset + marker.length());
    }

    @NotNull
    private static String createMarker(@NotNull PsiFile file2, int offset) {
        String marker;
        Project project = file2.getProject();
        PsiElement injectedElement = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(file2, offset);
        Language language = injectedElement != null ? injectedElement.getLanguage() : PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
        CodeStyleManagerImpl.setSequentialProcessingAllowed(false);
        NewLineIndentMarkerProvider markerProvider = (NewLineIndentMarkerProvider)NewLineIndentMarkerProvider.EP.forLanguage(language);
        String string = marker = markerProvider == null ? null : markerProvider.createMarker(file2, offset);
        if (marker != null) {
            return marker;
        }
        PsiComment comment = null;
        try {
            comment = PsiParserFacade.SERVICE.getInstance((Project)project).createLineOrBlockCommentFromText(language, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String text = comment != null ? comment.getText() : null;
        return text != null ? text : DUMMY_IDENTIFIER;
    }

    @Nullable
    public static PsiElement findWhiteSpaceNode(@NotNull PsiFile file2, int offset) {
        return (PsiElement)CodeStyleManagerImpl.doFindWhiteSpaceNode((PsiFile)file2, (int)offset).first;
    }

    @NotNull
    private static Pair<PsiElement, CharTable> doFindWhiteSpaceNode(@NotNull PsiFile file2, int offset) {
        ASTNode astNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)file2);
        if (!(astNode instanceof FileElement)) {
            return new Pair(null, null);
        }
        PsiElement elementAt = InjectedLanguageManager.getInstance((Project)file2.getProject()).findInjectedElementAt(file2, offset);
        CharTable charTable = ((FileElement)astNode).getCharTable();
        if (elementAt == null) {
            elementAt = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, offset);
        }
        if (elementAt == null) {
            return new Pair(null, (Object)charTable);
        }
        ASTNode node = elementAt.getNode();
        if (node == null || node.getElementType() != TokenType.WHITE_SPACE) {
            return new Pair(null, (Object)charTable);
        }
        return Pair.create((Object)elementAt, (Object)charTable);
    }

    public Indent getIndent(String text, FileType fileType) {
        int indent = IndentHelperImpl.getIndent(CodeStyle.getSettings((Project)this.myProject).getIndentOptions(fileType), text, true);
        int indentLevel = indent / 10000;
        int spaceCount = indent - indentLevel * 10000;
        return new IndentImpl(CodeStyle.getSettings((Project)this.myProject), indentLevel, spaceCount, fileType);
    }

    public String fillIndent(Indent indent, FileType fileType) {
        IndentImpl indent1 = (IndentImpl)indent;
        int indentLevel = indent1.getIndentLevel();
        int spaceCount = indent1.getSpaceCount();
        CodeStyleSettings settings = CodeStyle.getSettings((Project)this.myProject);
        if (indentLevel < 0) {
            spaceCount += indentLevel * settings.getIndentSize(fileType);
            indentLevel = 0;
            if (spaceCount < 0) {
                spaceCount = 0;
            }
        } else if (spaceCount < 0) {
            int v = (-spaceCount + settings.getIndentSize(fileType) - 1) / settings.getIndentSize(fileType);
            spaceCount += v * settings.getIndentSize(fileType);
            if ((indentLevel -= v) < 0) {
                indentLevel = 0;
            }
        }
        return IndentHelperImpl.fillIndent(this.myProject, fileType, indentLevel * 10000 + spaceCount);
    }

    public Indent zeroIndent() {
        return new IndentImpl(CodeStyle.getSettings((Project)this.myProject), 0, 0, null);
    }

    @NotNull
    private static CodeStyleSettings getSettings(@NotNull PsiFile file2) {
        return CodeStyle.getSettings((PsiFile)file2);
    }

    public boolean isSequentialProcessingAllowed() {
        return SEQUENTIAL_PROCESSING_ALLOWED.get().isAllowed();
    }

    public static void setSequentialProcessingAllowed(boolean allowed) {
        ProcessingUnderProgressInfo info = SEQUENTIAL_PROCESSING_ALLOWED.get();
        if (allowed) {
            info.decrement();
        } else {
            info.increment();
        }
    }

    public void performActionWithFormatterDisabled(Runnable r) {
        this.performActionWithFormatterDisabled(() -> {
            r.run();
            return null;
        });
    }

    public <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> r) throws T {
        Throwable[] throwable = new Throwable[1];
        this.performActionWithFormatterDisabled(() -> {
            try {
                r.run();
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
            return null;
        });
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    public <T> T performActionWithFormatterDisabled(Computable<T> r) {
        return ((FormatterImpl)FormatterEx.getInstance()).runWithFormattingDisabled(() -> {
            PostprocessReformattingAspect component2 = PostprocessReformattingAspect.getInstance(this.getProject());
            return component2.disablePostprocessFormattingInside(r);
        });
    }

    private static void postProcessEnabledRanges(@NotNull PsiFile file2, @NotNull TextRange range2, CodeStyleSettings settings) {
        List<TextRange> enabledRanges = new FormatterTagHandler(CodeStyleManagerImpl.getSettings(file2)).getEnabledRanges((ASTNode)file2.getNode(), range2);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PostFormatProcessor processor2 : PostFormatProcessor.EP_NAME.getExtensionList()) {
                TextRange processedRange = processor2.processText(file2, enabledRange, settings);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
    }

    public FormattingMode getCurrentFormattingMode() {
        return this.myCurrentFormattingMode.get();
    }

    void setCurrentFormattingMode(@NotNull FormattingMode mode) {
        this.myCurrentFormattingMode.set(mode);
    }

    public int getSpacing(@NotNull PsiFile file2, int offset) {
        FormattingModel model = CodeStyleManagerImpl.createFormattingModel(file2);
        return model == null ? -1 : FormatterEx.getInstance().getSpacingForBlockAtOffset(model, offset);
    }

    public int getMinLineFeeds(@NotNull PsiFile file2, int offset) {
        FormattingModel model = CodeStyleManagerImpl.createFormattingModel(file2);
        return model == null ? -1 : FormatterEx.getInstance().getMinLineFeedsBeforeBlockAtOffset(model, offset);
    }

    @Nullable
    private static FormattingModel createFormattingModel(@NotNull PsiFile file2) {
        FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)file2);
        if (builder2 == null) {
            return null;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file2);
        return builder2.createModel((PsiElement)file2, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithDocCommentFormattingDisabled(@NotNull PsiFile file2, @NotNull Runnable runnable2) {
        DocCommentSettings docSettings = this.getDocCommentSettings(file2);
        boolean currDocFormattingEnabled = docSettings.isDocFormattingEnabled();
        docSettings.setDocFormattingEnabled(false);
        try {
            runnable2.run();
        }
        finally {
            docSettings.setDocFormattingEnabled(currDocFormattingEnabled);
        }
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull PsiFile file2) {
        Language language = file2.getLanguage();
        LanguageCodeStyleSettingsProvider settingsProvider = LanguageCodeStyleSettingsProvider.forLanguage((Language)language);
        if (settingsProvider != null) {
            return settingsProvider.getDocCommentSettings(CodeStyle.getSettings((PsiFile)file2));
        }
        return DocCommentSettings.DEFAULTS;
    }

    public void scheduleIndentAdjustment(@NotNull Document document, int offset) {
        FormatterBasedIndentAdjuster.scheduleIndentAdjustment(this.myProject, document, offset);
    }

    public void scheduleReformatWhenSettingsComputed(@NotNull PsiFile file2) {
        Project project = file2.getProject();
        CodeStyleCachingService.getInstance((Project)project).scheduleWhenSettingsComputed(file2, () -> CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> PostprocessReformattingAspect.getInstance(project).disablePostprocessFormattingInside(() -> CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file2))), "reformat", null));
    }

    private static class CaretPositionKeeper {
        Editor myEditor;
        Document myDocument;
        CaretModel myCaretModel;
        RangeMarker myBeforeCaretRangeMarker;
        String myCaretIndentToRestore;
        int myVisualColumnToRestore = -1;
        boolean myBlankLineIndentPreserved;

        CaretPositionKeeper(@NotNull Editor editor, @NotNull CodeStyleSettings settings, @NotNull Language language) {
            this.myEditor = editor;
            this.myCaretModel = editor.getCaretModel();
            this.myDocument = editor.getDocument();
            this.myBlankLineIndentPreserved = CaretPositionKeeper.isBlankLineIndentPreserved(settings, language);
            int caretOffset = this.getCaretOffset();
            int lineStartOffset = this.getLineStartOffsetByTotalOffset(caretOffset);
            int lineEndOffset = this.getLineEndOffsetByTotalOffset(caretOffset);
            boolean shouldFixCaretPosition = CharArrayUtil.isEmptyOrSpaces((CharSequence)this.myDocument.getCharsSequence(), (int)lineStartOffset, (int)lineEndOffset);
            if (shouldFixCaretPosition) {
                this.initRestoreInfo(caretOffset);
            }
        }

        private static boolean isBlankLineIndentPreserved(@NotNull CodeStyleSettings settings, @NotNull Language language) {
            CommonCodeStyleSettings langSettings = settings.getCommonSettings(language);
            CommonCodeStyleSettings.IndentOptions indentOptions = langSettings.getIndentOptions();
            return indentOptions != null && indentOptions.KEEP_INDENTS_ON_EMPTY_LINES;
        }

        private void initRestoreInfo(int caretOffset) {
            int lineStartOffset = this.getLineStartOffsetByTotalOffset(caretOffset);
            this.myVisualColumnToRestore = this.myCaretModel.getVisualPosition().column;
            this.myCaretIndentToRestore = this.myDocument.getText(TextRange.create((int)lineStartOffset, (int)caretOffset));
            this.myBeforeCaretRangeMarker = this.myDocument.createRangeMarker(0, lineStartOffset);
        }

        public void restoreCaretPosition() {
            if (this.isVirtualSpaceEnabled()) {
                this.restoreVisualPosition();
            } else {
                this.restorePositionByIndentInsertion();
            }
        }

        private void restorePositionByIndentInsertion() {
            if (this.myBeforeCaretRangeMarker == null || !this.myBeforeCaretRangeMarker.isValid() || this.myCaretIndentToRestore == null || this.myBlankLineIndentPreserved) {
                return;
            }
            int newCaretLineStartOffset = this.myBeforeCaretRangeMarker.getEndOffset();
            this.myBeforeCaretRangeMarker.dispose();
            if (this.myCaretModel.getVisualPosition().column == this.myVisualColumnToRestore) {
                return;
            }
            Project project = this.myEditor.getProject();
            if (project == null || PsiDocumentManager.getInstance((Project)project).isDocumentBlockedByPsi(this.myDocument)) {
                return;
            }
            this.insertWhiteSpaceIndentIfNeeded(newCaretLineStartOffset);
        }

        private void restoreVisualPosition() {
            if (this.myVisualColumnToRestore < 0) {
                EditorUtil.runWithAnimationDisabled(this.myEditor, () -> this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE));
                return;
            }
            VisualPosition position = this.myCaretModel.getVisualPosition();
            if (this.myVisualColumnToRestore != position.column) {
                this.myCaretModel.moveToVisualPosition(new VisualPosition(position.line, this.myVisualColumnToRestore));
            }
        }

        private void insertWhiteSpaceIndentIfNeeded(int caretLineOffset) {
            int lineToInsertIndent = this.myDocument.getLineNumber(caretLineOffset);
            if (!this.lineContainsWhiteSpaceSymbolsOnly(lineToInsertIndent)) {
                return;
            }
            int lineToInsertStartOffset = this.myDocument.getLineStartOffset(lineToInsertIndent);
            if (lineToInsertIndent != this.getCurrentCaretLine()) {
                this.myCaretModel.moveToOffset(lineToInsertStartOffset);
            }
            this.myDocument.replaceString(lineToInsertStartOffset, caretLineOffset, (CharSequence)this.myCaretIndentToRestore);
        }

        private boolean isVirtualSpaceEnabled() {
            return this.myEditor.getSettings().isVirtualSpace();
        }

        private int getLineStartOffsetByTotalOffset(int offset) {
            int line = this.myDocument.getLineNumber(offset);
            return this.myDocument.getLineStartOffset(line);
        }

        private int getLineEndOffsetByTotalOffset(int offset) {
            int line = this.myDocument.getLineNumber(offset);
            return this.myDocument.getLineEndOffset(line);
        }

        private int getCaretOffset() {
            int caretOffset = this.myCaretModel.getOffset();
            caretOffset = MathUtil.clamp((int)caretOffset, (int)0, (int)(this.myDocument.getTextLength() - 1));
            return caretOffset;
        }

        private boolean lineContainsWhiteSpaceSymbolsOnly(int lineNumber) {
            int startOffset = this.myDocument.getLineStartOffset(lineNumber);
            int endOffset = this.myDocument.getLineEndOffset(lineNumber);
            return CharArrayUtil.isEmptyOrSpaces((CharSequence)this.myDocument.getCharsSequence(), (int)startOffset, (int)endOffset);
        }

        private int getCurrentCaretLine() {
            return this.myDocument.getLineNumber(this.myCaretModel.getOffset());
        }
    }

    private static class RangeFormatInfo {
        private final SmartPsiElementPointer<?> startPointer;
        private final SmartPsiElementPointer<?> endPointer;
        private final boolean fromStart;
        private final boolean toEnd;

        RangeFormatInfo(@Nullable SmartPsiElementPointer<?> startPointer, @Nullable SmartPsiElementPointer<?> endPointer, boolean fromStart, boolean toEnd) {
            this.startPointer = startPointer;
            this.endPointer = endPointer;
            this.fromStart = fromStart;
            this.toEnd = toEnd;
        }
    }

    private static class ProcessingUnderProgressInfo {
        private static final long DURATION_TIME = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
        private int myCount;
        private long myEndTime;

        private ProcessingUnderProgressInfo() {
        }

        public void increment() {
            if (this.myCount > 0 && System.currentTimeMillis() > this.myEndTime) {
                this.myCount = 0;
            }
            ++this.myCount;
            this.myEndTime = System.currentTimeMillis() + DURATION_TIME;
        }

        public void decrement() {
            if (this.myCount <= 0) {
                return;
            }
            --this.myCount;
        }

        public boolean isAllowed() {
            return this.myCount <= 0 || System.currentTimeMillis() >= this.myEndTime;
        }
    }
}

