/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SmartPointerManagerImpl
extends SmartPointerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SmartPointerManagerImpl.class);
    private final Project myProject;
    private final PsiDocumentManagerBase myPsiDocManager;
    private final Key<WeakReference<SmartPointerTracker>> LIGHT_TRACKER_KEY;
    private final ConcurrentMap<VirtualFile, SmartPointerTracker> myPhysicalTrackers = ContainerUtil.createConcurrentWeakValueMap();
    private static final Key<Reference<SmartPsiElementPointerImpl<?>>> CACHED_SMART_POINTER_KEY = Key.create((String)"CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
        this.LIGHT_TRACKER_KEY = Key.create((String)("SMART_POINTERS " + (project.isDefault() ? "default" : Integer.valueOf(project.hashCode()))));
    }

    public void dispose() {
        SmartPointerTracker.processQueue();
    }

    @NotNull
    private static String anonymize(@NotNull Project project) {
        return (project.isDisposed() ? "(Disposed)" : "") + (project.isDefault() ? "(Default)" : "") + project.hashCode();
    }

    public void fastenBelts(@NotNull VirtualFile file2) {
        SmartPointerTracker pointers2 = this.getTracker(file2);
        if (pointers2 != null) {
            pointers2.fastenBelts(this);
        }
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element2.getContainingFile();
        return this.createSmartPsiElementPointer(element2, containingFile);
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element2, PsiFile containingFile) {
        return this.createSmartPsiElementPointer(element2, containingFile, false);
    }

    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element2, PsiFile containingFile, boolean forInjected) {
        SmartPointerManagerImpl.ensureValid(element2, containingFile);
        SmartPointerTracker.processQueue();
        this.ensureMyProject(containingFile != null ? containingFile.getProject() : element2.getProject());
        SmartPsiElementPointerImpl<E> pointer = SmartPointerManagerImpl.getCachedPointer(element2);
        if (!(pointer == null || pointer.getElementInfo() instanceof SelfElementInfo && ((SelfElementInfo)pointer.getElementInfo()).isForInjected() != forInjected || pointer.incrementAndGetReferenceCount(1) <= 0)) {
            return pointer;
        }
        pointer = new SmartPsiElementPointerImpl<E>(this, element2, containingFile, forInjected);
        if (containingFile != null) {
            this.trackPointer(pointer, containingFile.getViewProvider().getVirtualFile());
        }
        element2.putUserData(CACHED_SMART_POINTER_KEY, (Object)new SoftReference(pointer));
        return pointer;
    }

    private void ensureMyProject(@NotNull Project project) {
        if (project != this.myProject) {
            throw new IllegalArgumentException("Element from alien project: " + SmartPointerManagerImpl.anonymize(project) + " expected: " + SmartPointerManagerImpl.anonymize(this.myProject));
        }
    }

    private static void ensureValid(@NotNull PsiElement element2, @Nullable PsiFile containingFile) {
        boolean valid;
        boolean bl = valid = containingFile != null ? containingFile.isValid() : element2.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid((PsiElement)element2);
            if (containingFile != null && !containingFile.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)containingFile, "Element " + element2.getClass() + "(" + element2.getLanguage() + ") claims to be valid but returns invalid containing file ");
            }
        }
    }

    private static <E extends PsiElement> SmartPsiElementPointerImpl<E> getCachedPointer(@NotNull E element2) {
        Object cachedElement;
        Reference data2 = (Reference)element2.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPsiElementPointerImpl cachedPointer = (SmartPsiElementPointerImpl)SoftReference.dereference((Reference)data2);
        if (cachedPointer != null && (cachedElement = cachedPointer.getElement()) != element2) {
            return null;
        }
        return cachedPointer;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range2) {
        return this.createSmartPsiFileRangePointer(file2, range2, false);
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file2, @NotNull TextRange range2, boolean forInjected) {
        PsiUtilCore.ensureValid((PsiElement)file2);
        SmartPointerTracker.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(this, file2, ProperTextRange.create((Segment)range2), forInjected);
        this.trackPointer(pointer, file2.getViewProvider().getVirtualFile());
        return pointer;
    }

    private <E extends PsiElement> void trackPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        SmartPointerElementInfo info = pointer.getElementInfo();
        if (!(info instanceof SelfElementInfo)) {
            return;
        }
        SmartPointerTracker tracker = this.getTracker(containingFile);
        if (tracker == null) {
            tracker = this.getOrCreateTracker(containingFile);
        }
        tracker.addReference(pointer);
    }

    public void removePointer(@NotNull SmartPsiElementPointer<?> pointer) {
        if (!(pointer instanceof SmartPsiElementPointerImpl) || this.myProject.isDisposed()) {
            return;
        }
        this.ensureMyProject(pointer.getProject());
        int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
        if (refCount == -1) {
            LOG.error("Double smart pointer removal");
            return;
        }
        if (refCount == 0) {
            PsiElement element2 = ((SmartPointerEx)pointer).getCachedElement();
            if (element2 != null) {
                element2.putUserData(CACHED_SMART_POINTER_KEY, null);
            }
            SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
            info.cleanup();
            SmartPointerTracker.PointerReference reference2 = ((SmartPsiElementPointerImpl)pointer).pointerReference;
            if (reference2 != null) {
                if (reference2.get() != pointer) {
                    throw new IllegalStateException("Reference points to " + reference2.get());
                }
                reference2.tracker.removeReference(reference2);
            }
        }
    }

    @Nullable
    SmartPointerTracker getTracker(@NotNull VirtualFile file2) {
        return file2 instanceof LightVirtualFile ? (SmartPointerTracker)SoftReference.dereference((Reference)((Reference)file2.getUserData(this.LIGHT_TRACKER_KEY))) : (SmartPointerTracker)this.myPhysicalTrackers.get(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private SmartPointerTracker getOrCreateTracker(@NotNull VirtualFile file2) {
        ConcurrentMap<VirtualFile, SmartPointerTracker> concurrentMap = this.myPhysicalTrackers;
        synchronized (concurrentMap) {
            SmartPointerTracker tracker = this.getTracker(file2);
            if (tracker == null) {
                tracker = new SmartPointerTracker();
                if (file2 instanceof LightVirtualFile) {
                    file2.putUserData(this.LIGHT_TRACKER_KEY, new WeakReference<SmartPointerTracker>(tracker));
                } else {
                    this.myPhysicalTrackers.put(file2, tracker);
                }
            }
            return tracker;
        }
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        VirtualFile file2 = containingFile.getViewProvider().getVirtualFile();
        SmartPointerTracker pointers2 = this.getTracker(file2);
        return pointers2 == null ? 0 : pointers2.getSize();
    }

    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer<?> pointer1, @NotNull SmartPsiElementPointer<?> pointer2) {
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(@NotNull Document document, @NotNull FrozenDocument frozen, @NotNull List<? extends DocumentEvent> events) {
        SmartPointerTracker list2;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        SmartPointerTracker smartPointerTracker = list2 = file2 == null ? null : this.getTracker(file2);
        if (list2 != null) {
            list2.updateMarkers(frozen, events);
        }
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file2) {
        SmartPointerTracker list2 = this.getTracker(file2);
        if (list2 != null) {
            list2.updatePointerTargetsAfterReparse();
        }
    }

    @NotNull
    Project getProject() {
        return this.myProject;
    }

    @NotNull
    PsiDocumentManagerBase getPsiDocumentManager() {
        return this.myPsiDocManager;
    }
}

