/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirElementInfo
extends SmartPointerElementInfo {
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final Project myProject;

    DirElementInfo(@NotNull PsiDirectory directory) {
        this.myProject = directory.getProject();
        this.myVirtualFile = directory.getVirtualFile();
    }

    @Override
    PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager) {
        return SelfElementInfo.restoreDirectoryFromVirtual(this.myVirtualFile, this.myProject);
    }

    @Override
    PsiFile restoreFile(@NotNull SmartPointerManagerImpl manager) {
        return null;
    }

    @Override
    int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager) {
        return other instanceof DirElementInfo && Comparing.equal((Object)this.myVirtualFile, (Object)((DirElementInfo)other).myVirtualFile);
    }

    @Override
    @NotNull
    VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    Segment getRange(@NotNull SmartPointerManagerImpl manager) {
        return null;
    }

    @Override
    @Nullable
    Segment getPsiRange(@NotNull SmartPointerManagerImpl manager) {
        return null;
    }

    public String toString() {
        return "dir{" + this.myVirtualFile + "}";
    }
}

