/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexTodoCacheManagerImpl
implements TodoCacheManager {
    private static final Logger LOG = Logger.getInstance(IndexTodoCacheManagerImpl.class);
    private final Project myProject;

    public IndexTodoCacheManagerImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    public PsiFile @NotNull [] getFilesWithTodoItems() {
        if (this.myProject.isDefault()) {
            return PsiFile.EMPTY_ARRAY;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        HashSet allFiles = new HashSet();
        fileBasedIndex.ignoreDumbMode(() -> {
            for (IndexPattern indexPattern : IndexPatternUtil.getIndexPatterns()) {
                Collection files2 = fileBasedIndex.getContainingFiles(TodoIndex.NAME, (Object)new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), GlobalSearchScope.allScope((Project)this.myProject));
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                for (VirtualFile file2 : files2) {
                    if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)this.myProject)) continue;
                    ReadAction.run(() -> {
                        if (file2.isValid() && TodoIndexers.belongsToProject(this.myProject, file2)) {
                            ContainerUtil.addIfNotNull((Collection)allFiles, (Object)psiManager.findFile(file2));
                        }
                    });
                }
            }
        }, DumbModeAccessType.RELIABLE_DATA_ONLY);
        return allFiles.isEmpty() ? PsiFile.EMPTY_ARRAY : PsiUtilCore.toPsiFileArray(allFiles);
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPatternProvider patternProvider) {
        return this.getTodoCountImpl(file2, patternProvider.getIndexPatterns());
    }

    @Override
    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPattern pattern) {
        return this.getTodoCountImpl(file2, pattern);
    }

    private int getTodoCountImpl(@NotNull VirtualFile file2, IndexPattern ... indexPatterns) {
        if (this.myProject.isDefault()) {
            return 0;
        }
        if (file2 instanceof VirtualFileWindow) {
            return -1;
        }
        if (file2 instanceof LightVirtualFile) {
            return this.calculateTodoCount((LightVirtualFile)file2, indexPatterns);
        }
        if (!TodoIndexers.belongsToProject(this.myProject, file2)) {
            return 0;
        }
        return this.fetchTodoCountFromIndex(file2, indexPatterns);
    }

    private int calculateTodoCount(@NotNull LightVirtualFile file2, IndexPattern @NotNull [] indexPatterns) {
        TodoIndex extension = (TodoIndex)((Object)FileBasedIndexExtension.EXTENSION_POINT_NAME.findExtension(TodoIndex.class));
        if (extension == null) {
            return 0;
        }
        try {
            FileContent fc = FileContentImpl.createByFile((VirtualFile)file2, this.myProject);
            Map data2 = extension.getIndexer().map((Object)fc);
            return IndexTodoCacheManagerImpl.getTodoCountForInputData(data2, indexPatterns);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0;
        }
    }

    private int fetchTodoCountFromIndex(@NotNull VirtualFile file2, IndexPattern @NotNull [] indexPatterns) {
        Ref inputData = Ref.create();
        FileBasedIndex.getInstance().ignoreDumbMode(() -> {
            Map data2 = FileBasedIndex.getInstance().getFileData(TodoIndex.NAME, file2, this.myProject);
            inputData.set((Object)data2);
        }, DumbModeAccessType.RELIABLE_DATA_ONLY);
        return IndexTodoCacheManagerImpl.getTodoCountForInputData((Map)inputData.get(), indexPatterns);
    }

    private static int getTodoCountForInputData(@Nullable Map<TodoIndexEntry, Integer> data2, IndexPattern @NotNull [] indexPatterns) {
        if (data2 == null) {
            return 0;
        }
        return Arrays.stream(indexPatterns).map(p -> new TodoIndexEntry(p.getPatternString(), p.isCaseSensitive())).mapToInt(e -> data2.getOrDefault(e, 0)).sum();
    }
}

