/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.core.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.pom.wrappers.PsiEventWrapperAspect;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomModelImpl
extends UserDataHolderBase
implements PomModel {
    private final Project myProject;
    private final Map<Class<? extends PomModelAspect>, PomModelAspect> myAspects = new HashMap<Class<? extends PomModelAspect>, PomModelAspect>();
    private final Map<PomModelAspect, List<PomModelAspect>> myIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Map<PomModelAspect, List<PomModelAspect>> myInvertedIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Collection<PomModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ThreadLocal<Stack<Pair<PomModelAspect, PomTransaction>>> myBlockedAspects = ThreadLocal.withInitial(Stack::new);
    private static volatile boolean allowPsiModification = true;

    public PomModelImpl(@NotNull Project project) {
        this(project, null);
    }

    @NonInjectable
    protected PomModelImpl(@NotNull Project project, @Nullable PomModelAspect extraAspect) {
        this.myProject = project;
        TreeAspect treeAspect = TreeAspect.getInstance(project);
        this.registerAspect(TreeAspect.class, treeAspect, null);
        if (extraAspect != null) {
            this.registerAspect(extraAspect.getClass(), extraAspect, treeAspect);
        }
        this.registerAspect(PsiEventWrapperAspect.class, new PsiEventWrapperAspect(treeAspect), treeAspect);
    }

    public <T extends PomModelAspect> T getModelAspect(@NotNull Class<T> aClass) {
        return (T)this.myAspects.get(aClass);
    }

    private void registerAspect(@NotNull Class<? extends PomModelAspect> aClass, @NotNull PomModelAspect aspect, @Nullable PomModelAspect dependency) {
        this.myAspects.put(aClass, aspect);
        ArrayList<PomModelAspect> deps = new ArrayList<PomModelAspect>();
        if (dependency != null) {
            deps.addAll(this.getAllDependencies(dependency));
        }
        deps.add(aspect);
        for (PomModelAspect pomModelAspect : deps) {
            List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(pomModelAspect);
            if (pomModelAspects != null) {
                pomModelAspects.add(aspect);
                continue;
            }
            this.myInvertedIncidence.put(pomModelAspect, new ArrayList<PomModelAspect>(Collections.singletonList(aspect)));
        }
        this.myIncidence.put(aspect, deps);
    }

    private List<PomModelAspect> getAllDependencies(@NotNull PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    private List<PomModelAspect> getAllDependants(@NotNull PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    public void addModelListener(@NotNull PomModelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void addModelListener(@NotNull PomModelListener listener2, @NotNull Disposable parentDisposable) {
        this.addModelListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeModelListener(listener2));
    }

    public void removeModelListener(@NotNull PomModelListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void runTransaction(@NotNull PomTransaction transaction) throws IncorrectOperationException {
        if (!PomModelImpl.isAllowPsiModification()) {
            throw new IncorrectOperationException("Must not modify PSI inside save listener");
        }
        PomModelAspect aspect = transaction.getTransactionAspect();
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(transaction.getChangeScope());
            Document document = this.startTransaction(transaction, containingFileByTree);
            Pair<PomModelAspect, PomTransaction> block = this.getBlockingTransaction(aspect, transaction);
            if (block != null) {
                ((PomTransaction)block.getSecond()).getAccumulatedEvent().beforeNestedTransaction();
            }
            ArrayList throwables = new ArrayList(0);
            DebugUtil.performPsiModification(null, () -> {
                PomModelEvent event;
                try {
                    Stack<Pair<PomModelAspect, PomTransaction>> blockedAspects = this.myBlockedAspects.get();
                    blockedAspects.push((Object)Pair.create((Object)aspect, (Object)transaction));
                    try {
                        transaction.run();
                        event = transaction.getAccumulatedEvent();
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throwables.add(e);
                        try {
                            if (containingFileByTree != null) {
                                this.commitTransaction(containingFileByTree, document);
                            }
                        }
                        catch (ProcessCanceledException e2) {
                            throw e2;
                        }
                        catch (Throwable t) {
                            throwables.add(t);
                        }
                        if (throwables.isEmpty()) return;
                        CompoundRuntimeException.throwIfNotEmpty((List)throwables);
                        return;
                    }
                    finally {
                        blockedAspects.pop();
                    }
                    if (block == null) {
                        Set changedAspects = event.getChangedAspects();
                        LinkedHashSet<PomModelAspect> dependants = new LinkedHashSet<PomModelAspect>();
                        for (PomModelAspect pomModelAspect : changedAspects) {
                            dependants.addAll(this.getAllDependants(pomModelAspect));
                        }
                        for (PomModelAspect modelAspect : dependants) {
                            if (changedAspects.contains(modelAspect)) continue;
                            modelAspect.update(event);
                        }
                        Iterator<PomModelListener> iterator2 = this.myListeners.iterator();
                        block31: while (iterator2.hasNext()) {
                            PomModelAspect modelAspect;
                            PomModelListener listener2 = iterator2.next();
                            Set changedAspects2 = event.getChangedAspects();
                            Iterator iterator3 = changedAspects2.iterator();
                            do {
                                if (!iterator3.hasNext()) continue block31;
                            } while (!listener2.isAspectChangeInteresting(modelAspect = (PomModelAspect)iterator3.next()));
                            listener2.modelChanged(event);
                        }
                        return;
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throwables.add(t);
                    return;
                }
                ((PomTransaction)block.getSecond()).getAccumulatedEvent().merge(event);
                return;
                finally {
                    try {
                        if (containingFileByTree != null) {
                            this.commitTransaction(containingFileByTree, document);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throwables.add(t);
                    }
                    if (!throwables.isEmpty()) {
                        CompoundRuntimeException.throwIfNotEmpty((List)throwables);
                    }
                }
            });
        });
    }

    @Nullable
    private Pair<PomModelAspect, PomTransaction> getBlockingTransaction(PomModelAspect aspect, PomTransaction transaction) {
        List<PomModelAspect> allDependants = this.getAllDependants(aspect);
        for (PomModelAspect pomModelAspect : allDependants) {
            Stack<Pair<PomModelAspect, PomTransaction>> blockedAspects = this.myBlockedAspects.get();
            ListIterator blocksIterator = blockedAspects.listIterator(blockedAspects.size());
            while (blocksIterator.hasPrevious()) {
                Pair pair = (Pair)blocksIterator.previous();
                if (pomModelAspect != pair.getFirst() || !PsiTreeUtil.isAncestor((PsiElement)PomModelImpl.getContainingFileByTree(((PomTransaction)pair.getSecond()).getChangeScope()), (PsiElement)transaction.getChangeScope(), (boolean)false)) continue;
                return pair;
            }
        }
        return null;
    }

    private void commitTransaction(@NotNull PsiFile containingFileByTree, @Nullable Document document) {
        boolean isPhysicalPsiChange;
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        boolean isFromCommit = ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).isCommitInProgress();
        boolean bl = isPhysicalPsiChange = !isFromCommit && !synchronizer.isIgnorePsiEvents();
        if (isPhysicalPsiChange) {
            this.reparseParallelTrees(containingFileByTree, synchronizer);
        }
        boolean docSynced = false;
        if (document != null) {
            int oldLength = containingFileByTree.getTextLength();
            docSynced = synchronizer.commitTransaction(document);
            if (docSynced) {
                BlockSupportImpl.sendAfterChildrenChangedEvent((PsiManagerImpl)PsiManager.getInstance((Project)this.myProject), containingFileByTree, oldLength, true);
            }
        }
        if (isPhysicalPsiChange && docSynced) {
            containingFileByTree.getViewProvider().contentsSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparseParallelTrees(PsiFile changedFile, PsiToDocumentSynchronizer synchronizer) {
        List allFiles = changedFile.getViewProvider().getAllFiles();
        if (allFiles.size() <= 1) {
            return;
        }
        CharSequence newText = changedFile.getNode().getChars();
        for (PsiFile file2 : allFiles) {
            Runnable changeAction;
            FileElement fileElement = file2 == changedFile ? null : ((PsiFileImpl)file2).getTreeElement();
            Runnable runnable2 = changeAction = fileElement == null ? null : this.reparseFile(file2, fileElement, newText);
            if (changeAction == null) continue;
            synchronizer.setIgnorePsiEvents(true);
            try {
                CodeStyleManager.getInstance((Project)file2.getProject()).performActionWithFormatterDisabled(changeAction);
            }
            finally {
                synchronizer.setIgnorePsiEvents(false);
            }
        }
    }

    @Nullable
    @ApiStatus.Internal
    public Runnable reparseFile(final @NotNull PsiFile file2, @NotNull FileElement treeElement, @NotNull CharSequence newText) {
        TextRange changedPsiRange = ChangedPsiRangeUtil.getChangedPsiRange(file2, treeElement, newText);
        if (changedPsiRange == null) {
            return null;
        }
        ProgressIndicator indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator());
        final DiffLog log = BlockSupport.getInstance(this.myProject).reparseRange(file2, treeElement, changedPsiRange, newText, indicator, treeElement.getText());
        return () -> this.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)file2, this.getModelAspect(TreeAspect.class)){

            public PomModelEvent runInner() throws IncorrectOperationException {
                return new TreeAspectEvent(PomModelImpl.this, log.performActualPsiChange(file2));
            }
        });
    }

    @Nullable
    @Contract(value="_,null -> null")
    private Document startTransaction(@NotNull PomTransaction transaction, @Nullable PsiFile containingFileByTree) {
        Document document;
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiElement changeScope = transaction.getChangeScope();
        if (containingFileByTree != null && !(containingFileByTree instanceof DummyHolder) && !manager.isCommitInProgress()) {
            PsiUtilCore.ensureValid((PsiElement)containingFileByTree);
        }
        boolean physical = changeScope.isPhysical();
        if (synchronizer.toProcessPsiEvent()) {
            if (this.isDocumentUncommitted(containingFileByTree)) {
                throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            if (physical && !commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
                throw new IncorrectOperationException("Must not change PSI outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
            }
        }
        if (containingFileByTree != null) {
            ((SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)this.myProject)).fastenBelts(containingFileByTree.getViewProvider().getVirtualFile());
            if (containingFileByTree instanceof PsiFileImpl) {
                ((PsiFileImpl)containingFileByTree).beforeAstChange();
            }
        }
        BlockSupportImpl.sendBeforeChildrenChangeEvent((PsiManagerImpl)PsiManager.getInstance((Project)this.myProject), changeScope, true);
        Document document2 = containingFileByTree == null ? null : (document = physical ? manager.getDocument(containingFileByTree) : manager.getCachedDocument(containingFileByTree));
        if (document != null) {
            synchronizer.startTransaction(this.myProject, document, changeScope);
        }
        return document;
    }

    private boolean isDocumentUncommitted(@Nullable PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document cachedDocument = manager.getCachedDocument(file2);
        return cachedDocument != null && manager.isUncommited(cachedDocument);
    }

    @Nullable
    private static PsiFile getContainingFileByTree(@NotNull PsiElement changeScope) {
        PsiFile psiFile;
        ASTNode node = changeScope.getNode();
        if (node == null) {
            psiFile = changeScope.getContainingFile();
        } else {
            FileElement fileElement = TreeUtil.getFileElement((TreeElement)node);
            if (fileElement == null) {
                return null;
            }
            psiFile = (PsiFile)fileElement.getPsi();
        }
        return psiFile.getNode() != null ? psiFile : null;
    }

    public static <T extends Throwable> void guardPsiModificationsIn(@NotNull ThrowableRunnable<T> runnable2) throws T {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean old = allowPsiModification;
        try {
            allowPsiModification = false;
            runnable2.run();
        }
        finally {
            allowPsiModification = old;
        }
    }

    public static boolean isAllowPsiModification() {
        return allowPsiModification;
    }
}

