/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates.github;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Outcome<V> {
    private final V myData;
    private final boolean myCancelled;
    private final Exception myException;

    private Outcome(V data2, boolean cancelled, Exception exception) {
        this.myData = data2;
        this.myCancelled = cancelled;
        this.myException = exception;
    }

    @Nullable
    public V get() {
        return this.myData;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }

    @Nullable
    public Exception getException() {
        return this.myException;
    }

    @NotNull
    public static <V> Outcome<V> createAsCancelled() {
        return new Outcome<Object>(null, true, null);
    }

    @NotNull
    public static <V> Outcome<V> createAsException(@NotNull Exception ex) {
        return new Outcome<Object>(null, false, ex);
    }

    @NotNull
    public static <V> Outcome<V> createNormal(@NotNull V data2) {
        return new Outcome<V>(data2, false, null);
    }
}

