/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.impl.welcomeScreen.RecentProjectsWelcomeScreenActionBase;
import com.intellij.ui.ScrollingUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditProjectGroupAction
extends RecentProjectsWelcomeScreenActionBase {
    public void actionPerformed(@NotNull AnActionEvent e) {
        final ProjectGroup group = ((ProjectGroupActionGroup)EditProjectGroupAction.getSelectedElements(e).get(0)).getGroup();
        JList list2 = EditProjectGroupAction.getList(e);
        assert (list2 != null);
        DefaultListModel model = EditProjectGroupAction.getDataModel(e);
        String name = Messages.showInputDialog((Component)list2, (String)IdeBundle.message((String)"label.enter.group.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.change.group.name", (Object[])new Object[0]), null, (String)group.getName(), (InputValidator)new InputValidatorEx(){

            @Nullable
            public String getErrorText(String inputString) {
                if ((inputString = inputString.trim()).length() == 0) {
                    return "Name cannot be empty.";
                }
                if (!this.checkInput(inputString)) {
                    return "Group '" + inputString + "' already exists.";
                }
                return null;
            }

            public boolean checkInput(String inputString) {
                if ((inputString = inputString.trim()).equals(group.getName())) {
                    return true;
                }
                for (ProjectGroup projectGroup : RecentProjectsManager.getInstance().getGroups()) {
                    if (!projectGroup.getName().equals(inputString)) continue;
                    return false;
                }
                return true;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        });
        if (name != null && model != null) {
            group.setName(name);
            EditProjectGroupAction.rebuildRecentProjectDataModel(model);
            for (int i2 = 0; i2 < model.getSize(); ++i2) {
                Object element2 = model.get(i2);
                if (!(element2 instanceof ProjectGroupActionGroup) || !((ProjectGroupActionGroup)((Object)element2)).getGroup().equals((Object)group)) continue;
                ScrollingUtil.selectItem((JList)list2, (int)i2);
                break;
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        List<AnAction> selected2 = EditProjectGroupAction.getSelectedElements(e);
        boolean enabled = !selected2.isEmpty() && selected2.get(0) instanceof ProjectGroupActionGroup && !((ProjectGroupActionGroup)selected2.get(0)).getGroup().isTutorials();
        e.getPresentation().setEnabledAndVisible(enabled);
    }
}

