/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.StatusBarWidgetProvider;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetProviderToFactoryAdapter;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetSettings;
import com.intellij.util.ui.UIUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class StatusBarWidgetsManager
extends SimpleModificationTracker
implements Disposable {
    @NotNull
    private static final Logger LOG = Logger.getInstance(StatusBar.class);
    private final Map<StatusBarWidgetFactory, StatusBarWidget> myWidgetFactories = new LinkedHashMap<StatusBarWidgetFactory, StatusBarWidget>();
    private final Map<String, StatusBarWidgetFactory> myWidgetIdsMap = new HashMap<String, StatusBarWidgetFactory>();
    private final Project myProject;

    public StatusBarWidgetsManager(@NotNull Project project) {
        this.myProject = project;
        StatusBarWidgetFactory.EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StatusBarWidgetFactory>(){

            public void extensionAdded(@NotNull StatusBarWidgetFactory factory2, @NotNull PluginDescriptor pluginDescriptor) {
                StatusBarWidgetsManager.this.addWidgetFactory(factory2);
            }

            public void extensionRemoved(@NotNull StatusBarWidgetFactory factory2, @NotNull PluginDescriptor pluginDescriptor) {
                StatusBarWidgetsManager.this.removeWidgetFactory(factory2);
            }
        }, true, (Disposable)this);
        StatusBarWidgetProvider.EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StatusBarWidgetProvider>(){

            public void extensionAdded(@NotNull StatusBarWidgetProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                StatusBarWidgetsManager.this.addWidgetFactory(new StatusBarWidgetProviderToFactoryAdapter(StatusBarWidgetsManager.this.myProject, provider));
            }

            public void extensionRemoved(@NotNull StatusBarWidgetProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                StatusBarWidgetsManager.this.removeWidgetFactory(new StatusBarWidgetProviderToFactoryAdapter(StatusBarWidgetsManager.this.myProject, provider));
            }
        }, true, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllWidgets() {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            for (StatusBarWidgetFactory factory2 : this.myWidgetFactories.keySet()) {
                this.updateWidget(factory2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void disableAllWidgets() {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            for (StatusBarWidgetFactory factory2 : this.myWidgetFactories.keySet()) {
                this.disableWidget(factory2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWidget(@NotNull Class<? extends StatusBarWidgetFactory> factoryExtension) {
        StatusBarWidgetFactory factory2 = (StatusBarWidgetFactory)StatusBarWidgetFactory.EP_NAME.findExtension(factoryExtension);
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            if (factory2 == null || !this.myWidgetFactories.containsKey(factory2)) {
                LOG.info("Factory is not registered as `com.intellij.statusBarWidgetFactory` extension: " + factoryExtension.getName());
                return;
            }
            this.updateWidget(factory2);
        }
    }

    public void updateWidget(@NotNull StatusBarWidgetFactory factory2) {
        if (factory2.isAvailable(this.myProject) && (!factory2.isConfigurable() || ((StatusBarWidgetSettings)((Object)ServiceManager.getService(StatusBarWidgetSettings.class))).isEnabled(factory2))) {
            this.enableWidget(factory2);
        } else {
            this.disableWidget(factory2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasWidgetCreated(@Nullable StatusBarWidgetFactory factory2) {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            return this.myWidgetFactories.get(factory2) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            this.myWidgetFactories.forEach((factory2, createdWidget) -> this.disableWidget((StatusBarWidgetFactory)factory2));
            this.myWidgetFactories.clear();
        }
    }

    @Nullable
    public StatusBarWidgetFactory findWidgetFactory(@NotNull String widgetId) {
        return this.myWidgetIdsMap.get(widgetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<StatusBarWidgetFactory> getWidgetFactories() {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            return this.myWidgetFactories.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableWidget(@NotNull StatusBarWidgetFactory factory2) {
        List availableFactories = StatusBarWidgetFactory.EP_NAME.getExtensionList();
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            if (!this.myWidgetFactories.containsKey(factory2)) {
                LOG.error("Factory is not registered as `com.intellij.statusBarWidgetFactory` extension: " + factory2.getId());
                return;
            }
            StatusBarWidget createdWidget = this.myWidgetFactories.get(factory2);
            if (createdWidget != null) {
                return;
            }
            StatusBarWidget widget = factory2.createWidget(this.myProject);
            this.myWidgetFactories.put(factory2, widget);
            this.myWidgetIdsMap.put(widget.ID(), factory2);
            String anchor2 = this.getAnchor(factory2, availableFactories);
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!this.myProject.isDisposed()) {
                    StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
                    if (statusBar == null) {
                        LOG.error("Cannot add a widget for project without root status bar: " + factory2.getId());
                        return;
                    }
                    statusBar.addWidget(widget, anchor2, (Disposable)this);
                }
            });
        }
    }

    @NotNull
    private String getAnchor(@NotNull StatusBarWidgetFactory factory2, @NotNull List<StatusBarWidgetFactory> availableFactories) {
        StatusBarWidget widget;
        int i2;
        if (factory2 instanceof StatusBarWidgetProviderToFactoryAdapter) {
            return ((StatusBarWidgetProviderToFactoryAdapter)factory2).getAnchor();
        }
        int indexOf2 = availableFactories.indexOf(factory2);
        for (i2 = indexOf2 + 1; i2 < availableFactories.size(); ++i2) {
            StatusBarWidgetFactory nextFactory = availableFactories.get(i2);
            widget = this.myWidgetFactories.get(nextFactory);
            if (widget == null) continue;
            return StatusBar.Anchors.before((String)widget.ID());
        }
        for (i2 = indexOf2 - 1; i2 >= 0; --i2) {
            StatusBarWidgetFactory prevFactory = availableFactories.get(i2);
            widget = this.myWidgetFactories.get(prevFactory);
            if (widget == null) continue;
            return StatusBar.Anchors.after((String)widget.ID());
        }
        return StatusBar.Anchors.DEFAULT_ANCHOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableWidget(@NotNull StatusBarWidgetFactory factory2) {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            StatusBarWidget createdWidget = this.myWidgetFactories.put(factory2, null);
            if (createdWidget != null) {
                this.myWidgetIdsMap.remove(createdWidget.ID());
                factory2.disposeWidget(createdWidget);
                UIUtil.invokeLaterIfNeeded(() -> {
                    StatusBar statusBar;
                    if (!this.myProject.isDisposed() && (statusBar = WindowManager.getInstance().getStatusBar(this.myProject)) != null) {
                        statusBar.removeWidget(createdWidget.ID());
                    }
                });
            }
        }
    }

    public boolean canBeEnabledOnStatusBar(@NotNull StatusBarWidgetFactory factory2, @NotNull StatusBar statusBar) {
        return factory2.isAvailable(this.myProject) && factory2.isConfigurable() && factory2.canBeEnabledOn(statusBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWidgetFactory(@NotNull StatusBarWidgetFactory factory2) {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            if (LightEdit.owns((Project)this.myProject) && !(factory2 instanceof LightEditCompatible)) {
                return;
            }
            if (this.myWidgetFactories.containsKey(factory2)) {
                LOG.error("Factory has been added already: " + factory2.getId());
                return;
            }
            this.myWidgetFactories.put(factory2, null);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    this.updateWidget(factory2);
                }
            });
            this.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWidgetFactory(@NotNull StatusBarWidgetFactory factory2) {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            this.disableWidget(factory2);
            this.myWidgetFactories.remove(factory2);
            this.incModificationCount();
        }
    }
}

