/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import java.awt.KeyboardFocusManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShowProcessWindowAction
extends ToggleAction
implements DumbAware {
    ShowProcessWindowAction() {
        super(ActionsBundle.messagePointer((String)"action.ShowProcessWindow.text", (Object[])new Object[0]), ActionsBundle.messagePointer((String)"action.ShowProcessWindow.description", (Object[])new Object[0]), null);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        IdeStatusBarImpl statusBar;
        ProjectFrameHelper frame = ShowProcessWindowAction.getFrame();
        if (frame != null && (statusBar = frame.getStatusBar()) != null) {
            return statusBar.isProcessWindowOpen();
        }
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(ShowProcessWindowAction.getFrame() != null);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        IdeStatusBarImpl statusBar;
        ProjectFrameHelper frame = ShowProcessWindowAction.getFrame();
        if (frame != null && (statusBar = frame.getStatusBar()) != null) {
            statusBar.setProcessWindowOpen(state);
        }
    }

    @Nullable
    private static ProjectFrameHelper getFrame() {
        return ProjectFrameHelper.getFrameHelper(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow());
    }
}

