/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.Surface;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowPaneState;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.reference.SoftReference;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowsPane
extends JBLayeredPane
implements UISettingsListener {
    private static final Logger LOG = Logger.getInstance(ToolWindowsPane.class);
    public static final String TEMPORARY_ADDED = "TEMPORARY_ADDED";
    private final JFrame frame;
    private ToolWindowPaneState state = new ToolWindowPaneState();
    private final MyLayeredPane layeredPane;
    private final ThreeComponentsSplitter verticalSplitter;
    private final ThreeComponentsSplitter horizontalSplitter;
    private final Stripe leftStripe;
    private final Stripe rightStripe;
    private final Stripe bottomStripe;
    private final Stripe topStripe;
    private final List<Stripe> stripes = new ArrayList<Stripe>(4);
    private boolean isWideScreen;
    private boolean leftHorizontalSplit;
    private boolean rightHorizontalSplit;

    ToolWindowsPane(@NotNull JFrame frame, @NotNull Disposable parentDisposable) {
        this.setOpaque(false);
        this.frame = frame;
        this.verticalSplitter = new ThreeComponentsSplitter(true, parentDisposable);
        RegistryValue registryValue = Registry.get((String)"ide.mainSplitter.min.size");
        registryValue.addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value2) {
                ToolWindowsPane.this.updateInnerMinSize(value2);
            }
        }, parentDisposable);
        this.verticalSplitter.setDividerWidth(0);
        this.verticalSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.verticalSplitter.setBackground(Color.gray);
        this.horizontalSplitter = new ThreeComponentsSplitter(false, parentDisposable);
        this.horizontalSplitter.setDividerWidth(0);
        this.horizontalSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.horizontalSplitter.setBackground(Color.gray);
        this.updateInnerMinSize(registryValue);
        UISettings uiSettings = UISettings.getInstance();
        this.isWideScreen = uiSettings.getWideScreenSupport();
        this.leftHorizontalSplit = uiSettings.getLeftHorizontalSplit();
        this.rightHorizontalSplit = uiSettings.getRightHorizontalSplit();
        if (this.isWideScreen) {
            this.horizontalSplitter.setInnerComponent((JComponent)this.verticalSplitter);
        } else {
            this.verticalSplitter.setInnerComponent((JComponent)this.horizontalSplitter);
        }
        this.topStripe = new Stripe(1);
        this.stripes.add(this.topStripe);
        this.leftStripe = new Stripe(2);
        this.stripes.add(this.leftStripe);
        this.bottomStripe = new Stripe(3);
        this.stripes.add(this.bottomStripe);
        this.rightStripe = new Stripe(4);
        this.stripes.add(this.rightStripe);
        this.updateToolStripesVisibility(uiSettings);
        this.layeredPane = new MyLayeredPane((JComponent)(this.isWideScreen ? this.horizontalSplitter : this.verticalSplitter));
        this.add(this.topStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.leftStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.bottomStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.rightStripe, JLayeredPane.POPUP_LAYER);
        this.add((Component)((Object)this.layeredPane), JLayeredPane.DEFAULT_LAYER);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    void initDocumentComponent(@NotNull Project project) {
        JComponent editorComponent = FileEditorManagerEx.getInstanceEx(project).getComponent();
        editorComponent.setFocusable(false);
        this.setDocumentComponent(editorComponent);
    }

    private void updateInnerMinSize(@NotNull RegistryValue value2) {
        int minSize = Math.max(0, Math.min(100, value2.asInteger()));
        this.verticalSplitter.setMinSize(JBUIScale.scale((int)minSize));
        this.horizontalSplitter.setMinSize(JBUIScale.scale((int)minSize));
    }

    public void doLayout() {
        Dimension size = this.getSize();
        if (!this.topStripe.isVisible()) {
            this.topStripe.setBounds(0, 0, 0, 0);
            this.bottomStripe.setBounds(0, 0, 0, 0);
            this.leftStripe.setBounds(0, 0, 0, 0);
            this.rightStripe.setBounds(0, 0, 0, 0);
            this.layeredPane.setBounds(0, 0, this.getWidth(), this.getHeight());
        } else {
            Dimension topSize = this.topStripe.getPreferredSize();
            Dimension bottomSize = this.bottomStripe.getPreferredSize();
            Dimension leftSize = this.leftStripe.getPreferredSize();
            Dimension rightSize = this.rightStripe.getPreferredSize();
            this.topStripe.setBounds(0, 0, size.width, topSize.height);
            int height = size.height - topSize.height - bottomSize.height;
            this.leftStripe.setBounds(0, topSize.height, leftSize.width, height);
            this.rightStripe.setBounds(size.width - rightSize.width, topSize.height, rightSize.width, height);
            this.bottomStripe.setBounds(0, size.height - bottomSize.height, size.width, bottomSize.height);
            UISettings uiSettings = UISettings.getInstance();
            if (uiSettings.getHideToolStripes() || uiSettings.getPresentationMode()) {
                this.layeredPane.setBounds(0, 0, size.width, size.height);
            } else {
                int width = size.width - leftSize.width - rightSize.width;
                this.layeredPane.setBounds(leftSize.width, topSize.height, width, height);
            }
        }
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        this.updateToolStripesVisibility(uiSettings);
        this.updateLayout(uiSettings);
    }

    final void addDecorator(@NotNull JComponent decorator, @NotNull WindowInfo info, boolean dirtyMode, @NotNull ToolWindowManagerImpl manager) {
        if (info.isDocked()) {
            boolean side = !info.isSplit();
            WindowInfo sideInfo = manager.getDockedInfoAt(info.getAnchor(), side);
            if (sideInfo == null) {
                ToolWindowAnchor anchor2 = info.getAnchor();
                this.setComponent(decorator, anchor2, ToolWindowsPane.normalizeWeigh(info.getWeight()));
                if (!dirtyMode) {
                    this.layeredPane.validate();
                    this.layeredPane.repaint();
                }
            } else {
                this.addAndSplitDockedComponentCmd(decorator, info, dirtyMode, manager);
            }
        } else if (info.getType() == ToolWindowType.SLIDING) {
            this.addSlidingComponent(decorator, info, dirtyMode);
        } else {
            throw new IllegalArgumentException("Unknown window type: " + info.getType());
        }
    }

    void removeDecorator(@NotNull WindowInfo info, @Nullable JComponent component2, boolean dirtyMode, @NotNull ToolWindowManagerImpl manager) {
        if (info.getType() == ToolWindowType.DOCKED) {
            WindowInfo sideInfo = manager.getDockedInfoAt(info.getAnchor(), !info.isSplit());
            if (sideInfo == null) {
                this.setComponent(null, info.getAnchor(), 0.0f);
            } else {
                ToolWindowAnchor anchor2 = info.getAnchor();
                JComponent c = this.getComponentAt(anchor2);
                if (c instanceof Splitter) {
                    Splitter splitter = (Splitter)c;
                    InternalDecorator component1 = (InternalDecorator)(info.isSplit() ? splitter.getFirstComponent() : splitter.getSecondComponent());
                    this.state.addSplitProportion(info, component1, splitter);
                    this.setComponent(component1, anchor2, component1 == null ? 0.0f : ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError(component1).getWeight());
                } else {
                    this.setComponent(null, anchor2, 0.0f);
                }
            }
            if (!dirtyMode) {
                this.layeredPane.validate();
                this.layeredPane.repaint();
            }
        } else if (info.getType() == ToolWindowType.SLIDING && component2 != null) {
            this.removeSlidingComponent(component2, info, dirtyMode);
        }
    }

    @NotNull
    public final JComponent getLayeredPane() {
        return this.layeredPane;
    }

    public void validateAndRepaint() {
        this.layeredPane.validate();
        this.layeredPane.repaint();
        for (Stripe stripe : this.stripes) {
            stripe.revalidate();
            stripe.repaint();
        }
    }

    public void revalidateNotEmptyStripes() {
        for (Stripe stripe : this.stripes) {
            if (stripe.isEmpty()) continue;
            stripe.revalidate();
        }
    }

    private void setComponent(@Nullable JComponent component2, @NotNull ToolWindowAnchor anchor2, float weight2) {
        if (ToolWindowAnchor.TOP == anchor2) {
            this.verticalSplitter.setFirstComponent(component2);
            this.verticalSplitter.setFirstSize((int)((float)this.layeredPane.getHeight() * weight2));
        } else if (ToolWindowAnchor.LEFT == anchor2) {
            this.horizontalSplitter.setFirstComponent(component2);
            this.horizontalSplitter.setFirstSize((int)((float)this.layeredPane.getWidth() * weight2));
        } else if (ToolWindowAnchor.BOTTOM == anchor2) {
            this.verticalSplitter.setLastComponent(component2);
            this.verticalSplitter.setLastSize((int)((float)this.layeredPane.getHeight() * weight2));
        } else if (ToolWindowAnchor.RIGHT == anchor2) {
            this.horizontalSplitter.setLastComponent(component2);
            this.horizontalSplitter.setLastSize((int)((float)this.layeredPane.getWidth() * weight2));
        } else {
            LOG.error("unknown anchor: " + anchor2);
        }
    }

    private JComponent getComponentAt(@NotNull ToolWindowAnchor anchor2) {
        if (ToolWindowAnchor.TOP == anchor2) {
            return this.verticalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.LEFT == anchor2) {
            return this.horizontalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.BOTTOM == anchor2) {
            return this.verticalSplitter.getLastComponent();
        }
        if (ToolWindowAnchor.RIGHT == anchor2) {
            return this.horizontalSplitter.getLastComponent();
        }
        LOG.error("unknown anchor: " + anchor2);
        return null;
    }

    private void setDocumentComponent(@Nullable JComponent component2) {
        (this.isWideScreen ? this.verticalSplitter : this.horizontalSplitter).setInnerComponent(component2);
    }

    private void updateToolStripesVisibility(@NotNull UISettings uiSettings) {
        boolean oldVisible = this.leftStripe.isVisible();
        boolean showButtons = !uiSettings.getHideToolStripes() && !uiSettings.getPresentationMode();
        boolean visible = showButtons || this.state.isStripesOverlaid();
        this.leftStripe.setVisible(visible);
        this.rightStripe.setVisible(visible);
        this.topStripe.setVisible(visible);
        this.bottomStripe.setVisible(visible);
        boolean overlayed = !showButtons && this.state.isStripesOverlaid();
        this.leftStripe.setOverlayed(overlayed);
        this.rightStripe.setOverlayed(overlayed);
        this.topStripe.setOverlayed(overlayed);
        this.bottomStripe.setOverlayed(overlayed);
        if (oldVisible != visible) {
            this.revalidate();
            this.repaint();
        }
    }

    public int getBottomHeight() {
        return this.bottomStripe.isVisible() ? this.bottomStripe.getHeight() : 0;
    }

    public boolean isBottomSideToolWindowsVisible() {
        return this.getComponentAt(ToolWindowAnchor.BOTTOM) != null;
    }

    @NotNull
    Stripe getStripeFor(@NotNull ToolWindowAnchor anchor2) {
        if (ToolWindowAnchor.TOP == anchor2) {
            return this.topStripe;
        }
        if (ToolWindowAnchor.BOTTOM == anchor2) {
            return this.bottomStripe;
        }
        if (ToolWindowAnchor.LEFT == anchor2) {
            return this.leftStripe;
        }
        if (ToolWindowAnchor.RIGHT == anchor2) {
            return this.rightStripe;
        }
        throw new IllegalArgumentException("Anchor=" + anchor2);
    }

    @Nullable
    Stripe getStripeFor(@NotNull Rectangle screenRectangle, @NotNull Stripe preferred) {
        if (preferred.containsScreen(screenRectangle)) {
            return preferred;
        }
        for (Stripe stripe : this.stripes) {
            if (!stripe.containsScreen(screenRectangle)) continue;
            return stripe;
        }
        return null;
    }

    void startDrag() {
        for (Stripe each : this.stripes) {
            each.startDrag();
        }
    }

    void stopDrag() {
        for (Stripe stripe : this.stripes) {
            stripe.stopDrag();
        }
    }

    void stretchWidth(@NotNull ToolWindow window, int value2) {
        this.stretch(window, value2);
    }

    void stretchHeight(@NotNull ToolWindow window, int value2) {
        this.stretch(window, value2);
    }

    private void stretch(@NotNull ToolWindow wnd, int value2) {
        Pair<Resizer, Component> pair = this.findResizerAndComponent(wnd);
        if (pair == null) {
            return;
        }
        boolean vertical = wnd.getAnchor() == ToolWindowAnchor.TOP || wnd.getAnchor() == ToolWindowAnchor.BOTTOM;
        int actualSize = (vertical ? ((Component)pair.second).getHeight() : ((Component)pair.second).getWidth()) + value2;
        boolean first = wnd.getAnchor() == ToolWindowAnchor.LEFT || wnd.getAnchor() == ToolWindowAnchor.TOP;
        int maxValue = vertical ? this.verticalSplitter.getMaxSize(first) : this.horizontalSplitter.getMaxSize(first);
        int minValue = vertical ? this.verticalSplitter.getMinSize(first) : this.horizontalSplitter.getMinSize(first);
        ((Resizer)pair.first).setSize(Math.max(minValue, Math.min(maxValue, actualSize)));
    }

    @Nullable
    private Pair<Resizer, Component> findResizerAndComponent(@NotNull ToolWindow window) {
        if (!window.isVisible()) {
            return null;
        }
        Resizer resizer = null;
        Container component2 = null;
        if (window.getType() == ToolWindowType.DOCKED) {
            component2 = this.getComponentAt(window.getAnchor());
            if (component2 != null) {
                resizer = window.getAnchor().isHorizontal() ? (this.verticalSplitter.getFirstComponent() == component2 ? new Resizer.Splitter.FirstComponent(this.verticalSplitter) : new Resizer.Splitter.LastComponent(this.verticalSplitter)) : (this.horizontalSplitter.getFirstComponent() == component2 ? new Resizer.Splitter.FirstComponent(this.horizontalSplitter) : new Resizer.Splitter.LastComponent(this.horizontalSplitter));
            }
        } else if (window.getType() == ToolWindowType.SLIDING) {
            for (component2 = window.getComponent(); component2 != null && component2.getParent() != this.layeredPane; component2 = component2.getParent()) {
            }
            if (component2 != null) {
                if (window.getAnchor() == ToolWindowAnchor.TOP) {
                    resizer = new Resizer.LayeredPane.Top(component2);
                } else if (window.getAnchor() == ToolWindowAnchor.BOTTOM) {
                    resizer = new Resizer.LayeredPane.Bottom(component2);
                } else if (window.getAnchor() == ToolWindowAnchor.LEFT) {
                    resizer = new Resizer.LayeredPane.Left(component2);
                } else if (window.getAnchor() == ToolWindowAnchor.RIGHT) {
                    resizer = new Resizer.LayeredPane.Right(component2);
                }
            }
        }
        return resizer != null ? Pair.create(resizer, (Object)component2) : null;
    }

    private void updateLayout(@NotNull UISettings uiSettings) {
        WindowInfoImpl secondInfo;
        WindowInfoImpl firstInfo;
        Splitter splitter;
        JComponent component2;
        if (this.isWideScreen != uiSettings.getWideScreenSupport()) {
            JComponent documentComponent = (this.isWideScreen ? this.verticalSplitter : this.horizontalSplitter).getInnerComponent();
            this.isWideScreen = uiSettings.getWideScreenSupport();
            if (this.isWideScreen) {
                this.verticalSplitter.setInnerComponent(null);
                this.horizontalSplitter.setInnerComponent((JComponent)this.verticalSplitter);
            } else {
                this.horizontalSplitter.setInnerComponent(null);
                this.verticalSplitter.setInnerComponent((JComponent)this.horizontalSplitter);
            }
            this.layeredPane.remove((Component)(this.isWideScreen ? this.verticalSplitter : this.horizontalSplitter));
            this.layeredPane.add((Component)(this.isWideScreen ? this.horizontalSplitter : this.verticalSplitter), DEFAULT_LAYER);
            this.setDocumentComponent(documentComponent);
        }
        if (this.leftHorizontalSplit != uiSettings.getLeftHorizontalSplit()) {
            component2 = this.getComponentAt(ToolWindowAnchor.LEFT);
            if (component2 instanceof Splitter) {
                splitter = (Splitter)component2;
                firstInfo = ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError((InternalDecorator)splitter.getFirstComponent());
                secondInfo = ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError((InternalDecorator)splitter.getSecondComponent());
                this.setComponent((JComponent)splitter, ToolWindowAnchor.LEFT, ToolWindowAnchor.LEFT.isSplitVertically() ? firstInfo.getWeight() : firstInfo.getWeight() + secondInfo.getWeight());
            }
            this.leftHorizontalSplit = uiSettings.getLeftHorizontalSplit();
        }
        if (this.rightHorizontalSplit != uiSettings.getRightHorizontalSplit()) {
            component2 = this.getComponentAt(ToolWindowAnchor.RIGHT);
            if (component2 instanceof Splitter) {
                splitter = (Splitter)component2;
                firstInfo = ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError((InternalDecorator)splitter.getFirstComponent());
                secondInfo = ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError((InternalDecorator)splitter.getSecondComponent());
                this.setComponent((JComponent)splitter, ToolWindowAnchor.RIGHT, ToolWindowAnchor.RIGHT.isSplitVertically() ? firstInfo.getWeight() : firstInfo.getWeight() + secondInfo.getWeight());
            }
            this.rightHorizontalSplit = uiSettings.getRightHorizontalSplit();
        }
    }

    public boolean isMaximized(@NotNull ToolWindow window) {
        return this.state.isMaximized(window);
    }

    void setMaximized(@NotNull ToolWindow toolWindow, boolean maximized) {
        Pair<Resizer, Component> resizerAndComponent = this.findResizerAndComponent(toolWindow);
        if (resizerAndComponent == null) {
            return;
        }
        if (maximized) {
            int size = toolWindow.getAnchor().isHorizontal() ? ((Component)resizerAndComponent.second).getHeight() : ((Component)resizerAndComponent.second).getWidth();
            this.stretch(toolWindow, Short.MAX_VALUE);
            this.state.setMaximizedProportion((Pair<ToolWindow, Integer>)Pair.create((Object)toolWindow, (Object)size));
        } else {
            Pair<ToolWindow, Integer> maximizedProportion = this.state.getMaximizedProportion();
            LOG.assertTrue(maximizedProportion != null);
            ToolWindow maximizedWindow = (ToolWindow)maximizedProportion.first;
            assert (maximizedWindow == toolWindow);
            ((Resizer)resizerAndComponent.first).setSize((Integer)maximizedProportion.second);
            this.state.setMaximizedProportion(null);
        }
        this.doLayout();
    }

    void reset() {
        for (Stripe stripe : this.stripes) {
            stripe.reset();
        }
        this.state = new ToolWindowPaneState();
        this.revalidate();
    }

    private void addAndSplitDockedComponentCmd(@NotNull JComponent newComponent, @NotNull WindowInfo info, boolean dirtyMode, @NotNull ToolWindowManagerImpl manager) {
        float newWeight;
        JComponent c;
        final ToolWindowAnchor anchor2 = info.getAnchor();
        final class MySplitter
        extends OnePixelSplitter
        implements UISettingsListener {
            MySplitter() {
            }

            public void uiSettingsChanged(@NotNull UISettings uiSettings) {
                if (anchor2 == ToolWindowAnchor.LEFT) {
                    this.setOrientation(!uiSettings.getLeftHorizontalSplit());
                } else if (anchor2 == ToolWindowAnchor.RIGHT) {
                    this.setOrientation(!uiSettings.getRightHorizontalSplit());
                }
            }

            public String toString() {
                return "[" + this.getFirstComponent() + "|" + this.getSecondComponent() + "]";
            }
        }
        MySplitter splitter = new MySplitter();
        splitter.setOrientation(anchor2.isSplitVertically());
        if (!anchor2.isHorizontal()) {
            splitter.setAllowSwitchOrientationByMouseClick(true);
            splitter.addPropertyChangeListener(arg_0 -> ToolWindowsPane.lambda$addAndSplitDockedComponentCmd$0((Splitter)splitter, anchor2, arg_0));
        }
        if ((c = this.getComponentAt(anchor2)) == null) {
            List<ToolWindowEx> toolWindows = manager.getToolWindowsOn(anchor2, Objects.requireNonNull(info.getId()));
            toolWindows.removeIf(window -> window == null || window.isSplitMode() == info.isSplit() || !window.isVisible());
            if (!toolWindows.isEmpty()) {
                c = ((ToolWindowImpl)toolWindows.get(0)).getDecoratorComponent();
            }
            if (c == null) {
                LOG.error("Empty splitter @ " + anchor2 + " during AddAndSplitDockedComponentCmd for " + info.getId());
            }
        }
        if (c instanceof InternalDecorator) {
            InternalDecorator oldComponent = (InternalDecorator)c;
            WindowInfoImpl oldInfo = ToolWindowManagerImpl.getRegisteredMutableInfoOrLogError(oldComponent);
            IJSwingUtilities.updateComponentTreeUI(oldComponent);
            IJSwingUtilities.updateComponentTreeUI(newComponent);
            if (info.isSplit()) {
                splitter.setFirstComponent(oldComponent);
                splitter.setSecondComponent(newComponent);
                float proportion = this.state.getPreferredSplitProportion(Objects.requireNonNull(oldInfo.getId()), ToolWindowsPane.normalizeWeigh(oldInfo.getSideWeight() / (oldInfo.getSideWeight() + info.getSideWeight())));
                splitter.setProportion(proportion);
                newWeight = !anchor2.isHorizontal() && !anchor2.isSplitVertically() ? ToolWindowsPane.normalizeWeigh(oldInfo.getWeight() + info.getWeight()) : ToolWindowsPane.normalizeWeigh(oldInfo.getWeight());
            } else {
                splitter.setFirstComponent(newComponent);
                splitter.setSecondComponent(oldComponent);
                splitter.setProportion(ToolWindowsPane.normalizeWeigh(info.getSideWeight()));
                newWeight = !anchor2.isHorizontal() && !anchor2.isSplitVertically() ? ToolWindowsPane.normalizeWeigh(oldInfo.getWeight() + info.getWeight()) : ToolWindowsPane.normalizeWeigh(info.getWeight());
            }
        } else {
            newWeight = ToolWindowsPane.normalizeWeigh(info.getWeight());
        }
        this.setComponent((JComponent)((Object)splitter), anchor2, newWeight);
        if (!dirtyMode) {
            this.layeredPane.validate();
            this.layeredPane.repaint();
        }
    }

    private void addSlidingComponent(@NotNull JComponent component2, @NotNull WindowInfo info, boolean dirtyMode) {
        if (dirtyMode || !UISettings.getInstance().getAnimateWindows() || RemoteDesktopService.isRemoteSession()) {
            this.layeredPane.add(component2, JLayeredPane.PALETTE_LAYER);
            this.layeredPane.setBoundsInPaletteLayer(component2, info.getAnchor(), info.getWeight());
        } else {
            Image topImage = this.layeredPane.getTopImage();
            Rectangle bounds2 = component2.getBounds();
            UIUtil.useSafely((Graphics)topImage.getGraphics(), topGraphics -> {
                component2.putClientProperty(TEMPORARY_ADDED, Boolean.TRUE);
                try {
                    this.layeredPane.add(component2, JLayeredPane.PALETTE_LAYER);
                    this.layeredPane.moveToFront(component2);
                    this.layeredPane.setBoundsInPaletteLayer(component2, info.getAnchor(), info.getWeight());
                    component2.paint((Graphics)topGraphics);
                    this.layeredPane.remove(component2);
                }
                finally {
                    component2.putClientProperty(TEMPORARY_ADDED, null);
                }
            });
            Image bottomImage = this.layeredPane.getBottomImage();
            Point2D bottomImageOffset = PaintUtil.getFractOffsetInRootPane((JComponent)((Object)this.layeredPane));
            UIUtil.useSafely((Graphics)bottomImage.getGraphics(), bottomGraphics -> {
                bottomGraphics.setClip(0, 0, bounds2.width, bounds2.height);
                bottomGraphics.translate(bottomImageOffset.getX() - (double)bounds2.x, bottomImageOffset.getY() - (double)bounds2.y);
                this.layeredPane.paint((Graphics)bottomGraphics);
            });
            Surface surface = new Surface(topImage, bottomImage, PaintUtil.negate((Point2D)bottomImageOffset), 1, info.getAnchor(), 300);
            this.layeredPane.add(surface, JLayeredPane.PALETTE_LAYER);
            surface.setBounds(bounds2);
            this.layeredPane.validate();
            this.layeredPane.repaint();
            surface.runMovement();
            this.layeredPane.remove(surface);
            this.layeredPane.add(component2, JLayeredPane.PALETTE_LAYER);
        }
        if (!dirtyMode) {
            this.layeredPane.validate();
            this.layeredPane.repaint();
        }
    }

    private void removeSlidingComponent(@NotNull Component component2, @NotNull WindowInfo info, boolean dirtyMode) {
        UISettings uiSettings = UISettings.getInstance();
        if (!dirtyMode && uiSettings.getAnimateWindows() && !RemoteDesktopService.isRemoteSession()) {
            Rectangle bounds2 = component2.getBounds();
            Image topImage = this.layeredPane.getTopImage();
            UIUtil.useSafely((Graphics)topImage.getGraphics(), component2::paint);
            Image bottomImage = this.layeredPane.getBottomImage();
            Point2D bottomImageOffset = PaintUtil.getFractOffsetInRootPane((JComponent)((Object)this.layeredPane));
            UIUtil.useSafely((Graphics)bottomImage.getGraphics(), bottomGraphics -> {
                this.layeredPane.remove(component2);
                bottomGraphics.clipRect(0, 0, bounds2.width, bounds2.height);
                bottomGraphics.translate(bottomImageOffset.getX() - (double)bounds2.x, bottomImageOffset.getY() - (double)bounds2.y);
                this.layeredPane.paint((Graphics)bottomGraphics);
            });
            Surface surface = new Surface(topImage, bottomImage, PaintUtil.negate((Point2D)bottomImageOffset), -1, info.getAnchor(), 300);
            this.layeredPane.add(surface, JLayeredPane.PALETTE_LAYER);
            surface.setBounds(bounds2);
            this.layeredPane.validate();
            this.layeredPane.repaint();
            surface.runMovement();
            this.layeredPane.remove(surface);
        } else {
            this.layeredPane.remove(component2);
        }
        if (!dirtyMode) {
            this.layeredPane.validate();
            this.layeredPane.repaint();
        }
    }

    void setStripesOverlayed(boolean value2) {
        this.state.setStripesOverlaid(value2);
        this.updateToolStripesVisibility(UISettings.getInstance());
    }

    private static float normalizeWeigh(float weight2) {
        if (weight2 <= 0.0f) {
            return 0.33f;
        }
        if (weight2 >= 1.0f) {
            return 0.66999996f;
        }
        return weight2;
    }

    private static /* synthetic */ void lambda$addAndSplitDockedComponentCmd$0(Splitter splitter, ToolWindowAnchor anchor2, PropertyChangeEvent evt) {
        if (!"orientation".equals(evt.getPropertyName())) {
            return;
        }
        boolean isSplitterHorizontalNow = !splitter.isVertical();
        UISettings settings = UISettings.getInstance();
        if (anchor2 == ToolWindowAnchor.LEFT && settings.getLeftHorizontalSplit() != isSplitterHorizontalNow) {
            settings.setLeftHorizontalSplit(isSplitterHorizontalNow);
            settings.fireUISettingsChanged();
        }
        if (anchor2 == ToolWindowAnchor.RIGHT && settings.getRightHorizontalSplit() != isSplitterHorizontalNow) {
            settings.setRightHorizontalSplit(isSplitterHorizontalNow);
            settings.fireUISettingsChanged();
        }
    }

    private final class MyLayeredPane
    extends JBLayeredPane {
        private final Function<ScaleContext, ImageRef> myImageProvider = __ -> {
            int width = Math.max(Math.max(1, this.getWidth()), ToolWindowsPane.this.frame.getWidth());
            int height = Math.max(Math.max(1, this.getHeight()), ToolWindowsPane.this.frame.getHeight());
            return new ImageRef(ImageUtil.createImage((GraphicsConfiguration)this.getGraphicsConfiguration(), (int)width, (int)height, (int)1));
        };
        private final ImageCache myBottomImageCache = new ImageCache(this.myImageProvider);
        private final ImageCache myTopImageCache = new ImageCache(this.myImageProvider);

        MyLayeredPane(JComponent splitter) {
            this.setOpaque(false);
            this.add(splitter, JLayeredPane.DEFAULT_LAYER);
        }

        final Image getBottomImage() {
            return this.myBottomImageCache.get(ScaleContext.create((Component)((Object)this)));
        }

        final Image getTopImage() {
            return this.myTopImageCache.get(ScaleContext.create((Component)((Object)this)));
        }

        public void doLayout() {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width < 0 || height < 0) {
                return;
            }
            Component[] components = this.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            LOG.assertTrue(components.length <= 1);
            for (Component component2 : components) {
                component2.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
            for (Component component2 : components = this.getComponentsInLayer(JLayeredPane.PALETTE_LAYER)) {
                if (!(component2 instanceof InternalDecorator)) continue;
                WindowInfo info = ((InternalDecorator)component2).getToolWindow().getWindowInfo();
                float weight2 = info.getAnchor().isHorizontal() ? (float)component2.getHeight() / (float)this.getHeight() : (float)component2.getWidth() / (float)this.getWidth();
                this.setBoundsInPaletteLayer(component2, info.getAnchor(), weight2);
            }
        }

        final void setBoundsInPaletteLayer(@NotNull Component component2, @NotNull ToolWindowAnchor anchor2, float weight2) {
            if (weight2 < 0.0f) {
                weight2 = 0.33f;
            } else if (weight2 > 1.0f) {
                weight2 = 1.0f;
            }
            if (ToolWindowAnchor.TOP == anchor2) {
                component2.setBounds(0, 0, this.getWidth(), (int)((float)this.getHeight() * weight2 + 0.5f));
            } else if (ToolWindowAnchor.LEFT == anchor2) {
                component2.setBounds(0, 0, (int)((float)this.getWidth() * weight2 + 0.5f), this.getHeight());
            } else if (ToolWindowAnchor.BOTTOM == anchor2) {
                int height = (int)((float)this.getHeight() * weight2 + 0.5f);
                component2.setBounds(0, this.getHeight() - height, this.getWidth(), height);
            } else if (ToolWindowAnchor.RIGHT == anchor2) {
                int width = (int)((float)this.getWidth() * weight2 + 0.5f);
                component2.setBounds(this.getWidth() - width, 0, width, this.getHeight());
            } else {
                LOG.error("unknown anchor " + anchor2);
            }
        }
    }

    private static class ImageCache
    extends ScaleContext.Cache<ImageRef> {
        ImageCache(@NotNull Function<? super ScaleContext, ImageRef> imageProvider) {
            super(imageProvider);
        }

        public BufferedImage get(@NotNull ScaleContext ctx) {
            ImageRef ref = (ImageRef)((Object)this.getOrProvide((UserScaleContext)ctx));
            BufferedImage image = (BufferedImage)SoftReference.dereference((Reference)((Object)ref));
            if (image != null) {
                return image;
            }
            this.clear();
            return this.get(ctx);
        }
    }

    private static final class ImageRef
    extends SoftReference<BufferedImage> {
        @Nullable
        private BufferedImage myStrongRef;

        ImageRef(@NotNull BufferedImage image) {
            super((Object)image);
            this.myStrongRef = image;
        }

        public BufferedImage get() {
            if (this.myStrongRef != null) {
                BufferedImage img = this.myStrongRef;
                this.myStrongRef = null;
                return img;
            }
            return (BufferedImage)super.get();
        }
    }

    @FunctionalInterface
    static interface Resizer {
        public void setSize(int var1);

        public static abstract class LayeredPane
        implements Resizer {
            Component myComponent;

            LayeredPane(@NotNull Component component2) {
                this.myComponent = component2;
            }

            @Override
            public final void setSize(int size) {
                this._setSize(size);
                if (this.myComponent.getParent() instanceof JComponent) {
                    JComponent parent = (JComponent)this.myComponent;
                    parent.revalidate();
                    parent.repaint();
                }
            }

            abstract void _setSize(int var1);

            static class Bottom
            extends LayeredPane {
                Bottom(@NotNull Component component2) {
                    super(component2);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds2 = this.myComponent.getBounds();
                    int delta = size - bounds2.height;
                    bounds2.y -= delta;
                    bounds2.height += delta;
                    this.myComponent.setBounds(bounds2);
                }
            }

            static class Top
            extends LayeredPane {
                Top(@NotNull Component component2) {
                    super(component2);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(this.myComponent.getWidth(), size);
                }
            }

            static final class Right
            extends LayeredPane {
                Right(@NotNull Component component2) {
                    super(component2);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds2 = this.myComponent.getBounds();
                    int delta = size - bounds2.width;
                    bounds2.x -= delta;
                    bounds2.width += delta;
                    this.myComponent.setBounds(bounds2);
                }
            }

            static final class Left
            extends LayeredPane {
                Left(@NotNull Component component2) {
                    super(component2);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(size, this.myComponent.getHeight());
                }
            }
        }

        public static abstract class Splitter
        implements Resizer {
            ThreeComponentsSplitter mySplitter;

            Splitter(@NotNull ThreeComponentsSplitter splitter) {
                this.mySplitter = splitter;
            }

            static final class LastComponent
            extends Splitter {
                LastComponent(@NotNull ThreeComponentsSplitter splitter) {
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setLastSize(size);
                }
            }

            static final class FirstComponent
            extends Splitter {
                FirstComponent(@NotNull ThreeComponentsSplitter splitter) {
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setFirstSize(size);
                }
            }
        }
    }
}

