/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Stripe
extends JPanel
implements UISettingsListener {
    private static final Dimension EMPTY_SIZE = new Dimension();
    private final int anchor;
    private final List<StripeButton> buttons = new ArrayList<StripeButton>();
    private Dimension preferredSize;
    private StripeButton myDragButton;
    private Rectangle myDropRectangle;
    private JComponent myDragButtonImage;
    private LayoutData myLastLayoutData;
    private boolean myFinishingDrop;
    static final int DROP_DISTANCE_SENSITIVITY = 20;

    Stripe(int anchor2) {
        super(new GridBagLayout());
        this.setOpaque(true);
        this.anchor = anchor2;
        this.setBorder(new AdaptiveBorder());
    }

    public boolean isEmpty() {
        return this.buttons.isEmpty();
    }

    public void reset() {
        this.buttons.clear();
        this.preferredSize = null;
        this.myLastLayoutData = null;
        this.removeAll();
        this.revalidate();
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        this.updatePresentation();
    }

    void addButton(@NotNull StripeButton button2, @NotNull Comparator<StripeButton> comparator2) {
        this.preferredSize = null;
        this.buttons.add(button2);
        this.buttons.sort(comparator2);
        this.add(button2);
    }

    void removeButton(@NotNull StripeButton button2) {
        this.preferredSize = null;
        this.buttons.remove(button2);
        this.remove(button2);
        this.revalidate();
    }

    @Override
    public void invalidate() {
        this.preferredSize = null;
        super.invalidate();
    }

    @Override
    public void doLayout() {
        if (!this.myFinishingDrop) {
            this.myLastLayoutData = this.recomputeBounds(true, this.getSize(), false);
        }
    }

    private LayoutData recomputeBounds(boolean setBounds, Dimension toFitWith, boolean noDrop) {
        boolean processDrop;
        LayoutData data2 = new LayoutData();
        int horizontalOffset = this.getHeight();
        data2.eachY = 0;
        data2.size = new Dimension();
        data2.gap = 0;
        data2.horizontal = this.isHorizontal();
        data2.dragInsertPosition = -1;
        if (data2.horizontal) {
            data2.eachX = horizontalOffset - 1;
            data2.eachY = 1;
        } else {
            data2.eachX = 0;
        }
        data2.fitSize = toFitWith != null ? toFitWith : new Dimension();
        Rectangle stripeSensitiveRectangle = new Rectangle(-20, -20, this.getWidth() + 40, this.getHeight() + 40);
        boolean bl = processDrop = this.isDroppingButton() && stripeSensitiveRectangle.intersects(this.myDropRectangle) && !noDrop;
        if (toFitWith == null) {
            for (StripeButton button2 : this.buttons) {
                if (!button2.isVisible()) continue;
                Dimension eachSize = button2.getPreferredSize();
                data2.fitSize.width = Math.max(eachSize.width, data2.fitSize.width);
                data2.fitSize.height = Math.max(eachSize.height, data2.fitSize.height);
            }
        }
        int gap = 0;
        if (toFitWith != null) {
            LayoutData layoutData = this.recomputeBounds(false, null, true);
            gap = data2.horizontal ? toFitWith.width - horizontalOffset - layoutData.size.width - data2.eachX : toFitWith.height - layoutData.size.height - data2.eachY;
            if (processDrop) {
                gap = data2.horizontal ? (gap -= this.myDropRectangle.width + data2.gap) : (gap -= this.myDropRectangle.height + data2.gap);
            }
            gap = Math.max(gap, 0);
        }
        boolean sidesStarted = false;
        for (StripeButton button3 : this.getButtonsToLayOut()) {
            int insertOrder = button3.getWindowInfo().getOrder();
            Dimension eachSize = button3.getPreferredSize();
            if (!sidesStarted && button3.getWindowInfo().isSplit()) {
                if (processDrop) {
                    this.tryDroppingOnGap(data2, gap, button3.getWindowInfo().getOrder());
                }
                if (data2.horizontal) {
                    data2.eachX += gap;
                    data2.size.width += gap;
                } else {
                    data2.eachY += gap;
                    data2.size.height += gap;
                }
                sidesStarted = true;
            }
            if (processDrop && !data2.dragTargetChosen) {
                int distance2;
                if (data2.horizontal) {
                    distance2 = this.myDropRectangle.x - data2.eachX;
                    if (distance2 < eachSize.width / 2 || this.myDropRectangle.x + this.myDropRectangle.width < eachSize.width / 2) {
                        Stripe.layoutButton(data2, this.myDragButtonImage, false);
                        data2.dragInsertPosition = insertOrder;
                        data2.dragToSide = sidesStarted;
                        data2.dragTargetChosen = true;
                    }
                } else {
                    distance2 = this.myDropRectangle.y - data2.eachY;
                    if (distance2 < eachSize.height / 2 || this.myDropRectangle.y + this.myDropRectangle.height < eachSize.height / 2) {
                        Stripe.layoutButton(data2, this.myDragButtonImage, false);
                        data2.dragInsertPosition = insertOrder;
                        data2.dragToSide = sidesStarted;
                        data2.dragTargetChosen = true;
                    }
                }
            }
            Stripe.layoutButton(data2, button3, setBounds);
        }
        if (!sidesStarted && processDrop) {
            this.tryDroppingOnGap(data2, gap, -1);
        }
        if (this.isDroppingButton()) {
            Dimension dragSize = this.myDragButton.getPreferredSize();
            if (this.getAnchor().isHorizontal() == this.myDragButton.getWindowInfo().getAnchor().isHorizontal()) {
                data2.size.width = Math.max(data2.size.width, dragSize.width);
                data2.size.height = Math.max(data2.size.height, dragSize.height);
            } else {
                data2.size.width = Math.max(data2.size.width, dragSize.height);
                data2.size.height = Math.max(data2.size.height, dragSize.width);
            }
        }
        if (processDrop && !data2.dragTargetChosen) {
            data2.dragInsertPosition = -1;
            data2.dragToSide = true;
            data2.dragTargetChosen = true;
        }
        return data2;
    }

    private void tryDroppingOnGap(LayoutData data2, int gap, int insertOrder) {
        int sideDistance;
        int nonSideDistance;
        if (data2.dragTargetChosen) {
            return;
        }
        if (data2.horizontal) {
            nonSideDistance = this.myDropRectangle.x - data2.eachX;
            sideDistance = data2.eachX + gap - this.myDropRectangle.x;
        } else {
            nonSideDistance = this.myDropRectangle.y - data2.eachY;
            sideDistance = data2.eachY + gap - this.myDropRectangle.y;
        }
        nonSideDistance = Math.max(0, nonSideDistance);
        if (sideDistance > 0) {
            if (nonSideDistance > sideDistance) {
                data2.dragInsertPosition = insertOrder;
                data2.dragToSide = true;
            } else {
                data2.dragInsertPosition = -1;
                data2.dragToSide = false;
            }
            data2.dragTargetChosen = true;
            Stripe.layoutButton(data2, this.myDragButtonImage, false);
        }
    }

    @NotNull
    private List<StripeButton> getButtonsToLayOut() {
        ArrayList<StripeButton> result2 = new ArrayList<StripeButton>();
        ArrayList<StripeButton> tools = new ArrayList<StripeButton>();
        ArrayList<StripeButton> sideTools = new ArrayList<StripeButton>();
        for (StripeButton button2 : this.buttons) {
            if (!button2.isVisible()) continue;
            if (button2.getWindowInfo().isSplit()) {
                sideTools.add(button2);
                continue;
            }
            tools.add(button2);
        }
        result2.addAll(tools);
        result2.addAll(sideTools);
        return result2;
    }

    @NotNull
    public ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.get((int)this.anchor);
    }

    private static void layoutButton(@NotNull LayoutData data2, @NotNull JComponent button2, boolean setBounds) {
        Dimension eachSize = button2.getPreferredSize();
        if (setBounds) {
            int width = data2.horizontal ? eachSize.width : data2.fitSize.width;
            int height = data2.horizontal ? data2.fitSize.height : eachSize.height;
            button2.setBounds(data2.eachX, data2.eachY, width, height);
        }
        if (data2.horizontal) {
            int deltaX = eachSize.width + data2.gap;
            data2.eachX += deltaX;
            data2.size.width += deltaX;
            data2.size.height = eachSize.height;
        } else {
            int deltaY = eachSize.height + data2.gap;
            data2.eachY += deltaY;
            data2.size.width = eachSize.width;
            data2.size.height += deltaY;
        }
        ++data2.processedComponents;
    }

    public void startDrag() {
        this.revalidate();
        this.repaint();
    }

    public void stopDrag() {
        this.revalidate();
        this.repaint();
    }

    @Nullable
    public StripeButton getButtonFor(@NotNull String toolWindowId) {
        for (StripeButton button2 : this.buttons) {
            if (!button2.getId().equals(toolWindowId)) continue;
            return button2;
        }
        return null;
    }

    public void setOverlayed(boolean overlayed) {
        if (Registry.is((String)"disable.toolwindow.overlay")) {
            return;
        }
        Color bg = UIUtil.getPanelBackground();
        if (overlayed) {
            this.setBackground(ColorUtil.toAlpha((Color)bg, (int)190));
        } else {
            this.setBackground(bg);
        }
    }

    private boolean isHorizontal() {
        return this.anchor == 1 || this.anchor == 3;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = this.buttons.isEmpty() ? EMPTY_SIZE : this.recomputeBounds((boolean)false, null, (boolean)false).size;
        }
        return this.preferredSize;
    }

    void updatePresentation() {
        for (StripeButton button2 : this.buttons) {
            button2.updatePresentation();
        }
    }

    public boolean containsScreen(@NotNull Rectangle screenRec) {
        Point point = screenRec.getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        return new Rectangle(point, screenRec.getSize()).intersects(new Rectangle(-20, -20, this.getWidth() + 20, this.getHeight() + 20));
    }

    public void finishDrop(@NotNull ToolWindowManagerImpl manager) {
        if (this.myLastLayoutData == null || !this.isDroppingButton()) {
            return;
        }
        String id2 = this.myDragButton.toolWindow.getId();
        this.myFinishingDrop = true;
        manager.setSideToolAndAnchor(id2, ToolWindowAnchor.get((int)this.anchor), this.myLastLayoutData.dragInsertPosition, this.myLastLayoutData.dragToSide);
        manager.invokeLater(this::resetDrop);
    }

    public void resetDrop() {
        this.myDragButton = null;
        this.myDragButtonImage = null;
        this.myFinishingDrop = false;
        this.preferredSize = null;
        this.revalidate();
        this.repaint();
    }

    void processDropButton(@NotNull StripeButton button2, @NotNull JComponent buttonImage, Point screenPoint) {
        if (!this.isDroppingButton()) {
            BufferedImage image = UIUtil.createImage((Component)button2, (int)button2.getWidth(), (int)button2.getHeight(), (int)1);
            buttonImage.paint(image.getGraphics());
            this.myDragButton = button2;
            this.myDragButtonImage = buttonImage;
            this.preferredSize = null;
        }
        Point point = new Point(screenPoint);
        SwingUtilities.convertPointFromScreen(point, this);
        this.myDropRectangle = new Rectangle(point, buttonImage.getSize());
        this.revalidate();
        this.repaint();
    }

    private boolean isDroppingButton() {
        return this.myDragButton != null;
    }

    @Override
    public String toString() {
        String anchor2 = null;
        switch (this.anchor) {
            case 1: {
                anchor2 = "TOP";
                break;
            }
            case 3: {
                anchor2 = "BOTTOM";
                break;
            }
            case 2: {
                anchor2 = "LEFT";
                break;
            }
            case 4: {
                anchor2 = "RIGHT";
            }
        }
        return this.getClass().getName() + " " + anchor2;
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        super.paintComponent(g);
        if (!this.myFinishingDrop && this.isDroppingButton() && this.myDragButton.getParent() != this) {
            g.setColor(this.getBackground().brighter());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (StartupUiUtil.isUnderDarcula()) {
            return;
        }
        ToolWindowAnchor anchor2 = this.getAnchor();
        g.setColor(new Color(255, 255, 255, 40));
        Rectangle r = this.getBounds();
        if (anchor2 == ToolWindowAnchor.LEFT || anchor2 == ToolWindowAnchor.RIGHT) {
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)0.0, (double)r.height);
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(r.width - 2), (double)0.0, (double)(r.width - 2), (double)r.height);
        } else {
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)1.0, (double)r.width, (double)1.0);
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)(r.height - 1), (double)r.width, (double)(r.height - 1));
        }
    }

    private static final class LayoutData {
        int eachX;
        int eachY;
        int gap;
        Dimension size;
        Dimension fitSize;
        boolean horizontal;
        int processedComponents;
        boolean dragTargetChosen;
        boolean dragToSide;
        int dragInsertPosition;

        private LayoutData() {
        }
    }

    private static final class AdaptiveBorder
    implements Border {
        private AdaptiveBorder() {
        }

        @Override
        public void paintBorder(@NotNull Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = ((JComponent)c).getInsets();
            g.setColor(UIUtil.CONTRAST_BORDER_COLOR);
            AdaptiveBorder.drawBorder((Graphics2D)g, x, y, width, height, insets);
        }

        private static void drawBorder(Graphics2D g, int x, int y, int width, int height, Insets insets) {
            if (insets.top == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)(x + width), (double)y);
            }
            if (insets.right == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)(x + width - 1), (double)y, (double)(x + width - 1), (double)(y + height));
            }
            if (insets.left == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)x, (double)(y + height));
            }
            if (insets.bottom == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)(y + height - 1), (double)(x + width), (double)(y + height - 1));
            }
            if (!StartupUiUtil.isUnderDarcula()) {
                return;
            }
            Color c = g.getColor();
            if (insets.top == 2) {
                g.setColor(c);
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)(x + width), (double)y);
                g.setColor((Color)Gray._85);
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)(y + 1), (double)(x + width), (double)(y + 1));
            }
            if (insets.right == 2) {
                g.setColor((Color)Gray._85);
                LinePainter2D.paint((Graphics2D)g, (double)(x + width - 1), (double)y, (double)(x + width - 1), (double)(y + height));
                g.setColor(c);
                LinePainter2D.paint((Graphics2D)g, (double)(x + width - 2), (double)y, (double)(x + width - 2), (double)(y + height));
            }
            if (insets.left == 2) {
                g.setColor((Color)Gray._85);
                LinePainter2D.paint((Graphics2D)g, (double)(x + 1), (double)y, (double)(x + 1), (double)(y + height));
                g.setColor(c);
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)x, (double)(y + height));
            }
        }

        @Override
        public Insets getBorderInsets(@NotNull Component c) {
            Stripe stripe = (Stripe)c;
            ToolWindowAnchor anchor2 = stripe.getAnchor();
            if (anchor2 == ToolWindowAnchor.LEFT) {
                return new Insets(1, 0, 0, 1);
            }
            if (anchor2 == ToolWindowAnchor.RIGHT) {
                return new Insets(1, 1, 0, 0);
            }
            if (anchor2 == ToolWindowAnchor.TOP) {
                return new Insets(1, 0, 0, 0);
            }
            return new Insets(1, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

