/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

final class SideStack {
    private static final Logger LOG = Logger.getInstance(SideStack.class);
    private final Stack<WindowInfoImpl> stack = new Stack();

    SideStack() {
    }

    void push(@NotNull WindowInfoImpl info) {
        LOG.assertTrue(info.isDocked());
        LOG.assertTrue(!info.isAutoHide());
        this.stack.push((Object)info.copy());
    }

    WindowInfoImpl pop(@NotNull ToolWindowAnchor anchor2) {
        int i2 = this.stack.size() - 1;
        while (true) {
            WindowInfoImpl info;
            if (anchor2 == (info = (WindowInfoImpl)this.stack.get(i2)).getAnchor()) {
                this.stack.remove(i2);
                return info;
            }
            --i2;
        }
    }

    boolean isEmpty(@NotNull ToolWindowAnchor anchor2) {
        for (int i2 = this.stack.size() - 1; i2 > -1; --i2) {
            WindowInfoImpl info = (WindowInfoImpl)this.stack.get(i2);
            if (anchor2 != info.getAnchor()) continue;
            return false;
        }
        return true;
    }

    void remove(String id2) {
        this.stack.removeIf(info -> id2.equals(info.getId()));
    }

    void clear() {
        this.stack.clear();
    }
}

