/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import java.awt.Dialog;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class ModalityHelper {
    private static final Logger LOG = Logger.getInstance(ModalityHelper.class);
    private static Method isModalBlockedMethod = null;
    private static Method getModalBlockerMethod = null;

    public static boolean isModalBlocked(Window window) {
        boolean result2 = false;
        try {
            result2 = (Boolean)isModalBlockedMethod.invoke((Object)window, new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return result2;
    }

    public static Dialog getModalBlockerFor(Window window) {
        Dialog result2 = null;
        try {
            result2 = (Dialog)getModalBlockerMethod.invoke((Object)window, new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return result2;
    }

    public static Dialog getBlockerForFrame(IdeFrame ideFrame) {
        if (ideFrame == null) {
            return null;
        }
        JComponent c = ideFrame.getComponent();
        if (c == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(c);
        if (window == null) {
            return null;
        }
        if (!ModalityHelper.isModalBlocked(window)) {
            return null;
        }
        return ModalityHelper.getModalBlockerFor(window);
    }

    public static Dialog getBlockerForFocusedFrame() {
        return ModalityHelper.getBlockerForFrame(IdeFocusManager.getGlobalInstance().getLastFocusedFrame());
    }

    static {
        Class[] noParams = new Class[]{};
        try {
            isModalBlockedMethod = Window.class.getDeclaredMethod("isModalBlocked", noParams);
            getModalBlockerMethod = Window.class.getDeclaredMethod("getModalBlocker", noParams);
            isModalBlockedMethod.setAccessible(true);
            getModalBlockerMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Throwable)e);
        }
    }
}

