/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.dnd.DnDAware;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.openapi.wm.impl.PaintersHelper;
import com.intellij.openapi.wm.impl.WindowShadowPainter;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeGlassPaneImpl
extends JPanel
implements IdeGlassPaneEx,
IdeEventQueue.EventDispatcher {
    private static final Logger LOG = Logger.getInstance(IdeGlassPaneImpl.class);
    private static final String PREPROCESSED_CURSOR_KEY = "SuperCursor";
    private final List<EventListener> myMouseListeners = new ArrayList<EventListener>();
    private final Set<EventListener> mySortedMouseListeners = new TreeSet<EventListener>((o1, o2) -> {
        double weight1 = 0.0;
        if (o1 instanceof Weighted) {
            weight1 = ((Weighted)o1).getWeight();
        }
        double weight2 = 0.0;
        if (o2 instanceof Weighted) {
            weight2 = ((Weighted)o2).getWeight();
        }
        return weight1 > weight2 ? 1 : (weight1 < weight2 ? -1 : this.myMouseListeners.indexOf(o1) - this.myMouseListeners.indexOf(o2));
    });
    private final JRootPane myRootPane;
    private final Map<String, PaintersHelper> myNamedPainters = new HashMap<String, PaintersHelper>();
    private boolean myPreprocessorActive;
    private final Map<Object, Cursor> myListener2Cursor = new LinkedHashMap<Object, Cursor>();
    private Component myLastCursorComponent;
    private Cursor myLastOriginalCursor;
    private MouseEvent myPrevPressEvent;
    WindowShadowPainter myWindowShadowPainter;

    public IdeGlassPaneImpl(JRootPane rootPane) {
        this(rootPane, false);
    }

    public IdeGlassPaneImpl(JRootPane rootPane, boolean installPainters) {
        this.myRootPane = rootPane;
        this.setOpaque(false);
        this.setVisible(false);
        this.setEnabled(false);
        this.setLayout(null);
        if (installPainters) {
            IdeBackgroundUtil.initFramePainters(this);
            IdeBackgroundUtil.initEditorPainters(this);
        }
        if (SystemInfo.isWindows && Registry.is((String)"ide.window.shadow.painter", (boolean)false)) {
            this.myWindowShadowPainter = new WindowShadowPainter();
            this.getPainters().addPainter((Painter)this.myWindowShadowPainter, null);
        }
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        return e instanceof MouseEvent && this.dispatchMouseEvent((MouseEvent)e);
    }

    private boolean dispatchMouseEvent(@NotNull MouseEvent event) {
        boolean dispatched;
        JRootPane eventRootPane = this.myRootPane;
        Window eventWindow = ComponentUtil.getWindow((Component)event.getComponent());
        if (IdeGlassPaneImpl.isContextMenu(eventWindow)) {
            return false;
        }
        Window thisGlassWindow = SwingUtilities.getWindowAncestor(this.myRootPane);
        if (eventWindow != thisGlassWindow) {
            return false;
        }
        if (event.getID() == 506 && ApplicationManager.getApplication() != null) {
            IdeTooltipManager.getInstance().hideCurrent(event);
        }
        if (event.getID() == 501 || event.getID() == 502 || event.getID() == 500) {
            dispatched = this.preprocess(event, false, eventRootPane);
        } else if (event.getID() == 503 || event.getID() == 506) {
            dispatched = this.preprocess(event, true, eventRootPane);
        } else if (event.getID() == 505 || event.getID() == 504) {
            dispatched = this.preprocess(event, false, eventRootPane);
        } else {
            return false;
        }
        Component meComponent = event.getComponent();
        if (!dispatched && meComponent != null) {
            boolean pureMouse1Event;
            if (eventWindow != SwingUtilities.getWindowAncestor(this.myRootPane)) {
                return false;
            }
            int button1 = 1040;
            boolean bl = pureMouse1Event = (event.getModifiersEx() | button1) == button1;
            if (pureMouse1Event && event.getClickCount() <= 1 && !event.isPopupTrigger()) {
                Container parent = this.myRootPane.getContentPane().getParent();
                Point point = SwingUtilities.convertPoint(meComponent, event.getPoint(), parent);
                Component target2 = SwingUtilities.getDeepestComponentAt(parent, point.x, point.y);
                boolean bl2 = dispatched = target2 instanceof DnDAware && this.dispatchForDnDAware(event, point, target2);
            }
        }
        if (this.isVisible() && this.getComponentCount() == 0) {
            boolean cursorSet = false;
            if (meComponent != null) {
                Container parent = this.myRootPane.getContentPane().getParent();
                Point point = SwingUtilities.convertPoint(meComponent, event.getPoint(), parent);
                Component target3 = SwingUtilities.getDeepestComponentAt(parent, point.x, point.y);
                if (target3 != null) {
                    UIUtil.setCursor((Component)this, (Cursor)target3.getCursor());
                    cursorSet = true;
                }
            }
            if (!cursorSet) {
                UIUtil.setCursor((Component)this, (Cursor)Cursor.getDefaultCursor());
            }
        }
        return dispatched;
    }

    private boolean dispatchForDnDAware(@NotNull MouseEvent event, @NotNull Point point, @NotNull Component target2) {
        Point targetPoint = SwingUtilities.convertPoint(this.myRootPane.getContentPane().getParent(), point.x, point.y, target2);
        boolean overSelection = ((DnDAware)target2).isOverSelection(targetPoint);
        if (!overSelection) {
            return false;
        }
        boolean dispatched = false;
        switch (event.getID()) {
            case 501: {
                AWTEventListener[] eventListeners;
                if (target2.isFocusable()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(target2, true));
                }
                boolean consumed = false;
                MouseEvent mouseEvent = MouseEventAdapter.convert((MouseEvent)event, (Component)target2);
                for (MouseListener listener2 : (MouseListener[])target2.getListeners(MouseListener.class)) {
                    String className = listener2.getClass().getName();
                    if (className.contains("BasicTreeUI$") || className.contains("MacTreeUI$")) continue;
                    IdeGlassPaneImpl.fireMouseEvent(listener2, mouseEvent);
                    if (!mouseEvent.isConsumed()) continue;
                    consumed = true;
                    break;
                }
                if (!mouseEvent.isConsumed() && (eventListeners = Toolkit.getDefaultToolkit().getAWTEventListeners(16L)) != null && eventListeners.length > 0) {
                    for (AWTEventListener eventListener : eventListeners) {
                        eventListener.eventDispatched(event);
                        if (event.isConsumed()) break;
                    }
                    if (event.isConsumed()) break;
                }
                if (consumed) {
                    event.consume();
                } else {
                    this.myPrevPressEvent = mouseEvent;
                }
                dispatched = true;
                break;
            }
            case 502: {
                return this.dispatchMouseReleased(event, target2);
            }
            default: {
                this.myPrevPressEvent = null;
            }
        }
        return dispatched;
    }

    private boolean dispatchMouseReleased(@NotNull MouseEvent event, @NotNull Component target2) {
        MouseEvent mouseEvent = MouseEventAdapter.convert((MouseEvent)event, (Component)target2);
        if (this.myPrevPressEvent == null || this.myPrevPressEvent.getComponent() != target2) {
            return false;
        }
        for (MouseListener listener2 : (MouseListener[])target2.getListeners(MouseListener.class)) {
            String className = listener2.getClass().getName();
            if (className.contains("BasicTreeUI$") || className.contains("MacTreeUI$")) {
                IdeGlassPaneImpl.fireMouseEvent(listener2, this.myPrevPressEvent);
                IdeGlassPaneImpl.fireMouseEvent(listener2, mouseEvent);
                if (mouseEvent.isConsumed()) break;
            }
            IdeGlassPaneImpl.fireMouseEvent(listener2, mouseEvent);
            if (mouseEvent.isConsumed()) break;
        }
        if (mouseEvent.isConsumed()) {
            event.consume();
        }
        this.myPrevPressEvent = null;
        return true;
    }

    private static boolean isContextMenu(Window window) {
        if (window instanceof JWindow) {
            JLayeredPane layeredPane = ((JWindow)window).getLayeredPane();
            for (Component component2 : layeredPane.getComponents()) {
                if (!(component2 instanceof JPanel) || ContainerUtil.findInstance((Object[])((JPanel)component2).getComponents(), JPopupMenu.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean preprocess(@NotNull MouseEvent e, boolean motion, JRootPane eventRootPane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setCursor(@NotNull Component target2, Cursor cursor) {
        if (target2 instanceof EditorComponentImpl) {
            ((EditorComponentImpl)target2).getEditor().setCustomCursor(IdeGlassPaneImpl.class, cursor);
        } else {
            if (target2 instanceof JComponent) {
                IdeGlassPaneImpl.savePreProcessedCursor((JComponent)target2, target2.getCursor());
            }
            UIUtil.setCursor((Component)target2, (Cursor)cursor);
        }
    }

    private static void resetCursor(@NotNull Component target2, Cursor lastCursor) {
        if (target2 instanceof EditorComponentImpl) {
            ((EditorComponentImpl)target2).getEditor().setCustomCursor(IdeGlassPaneImpl.class, null);
        } else {
            Cursor cursor = null;
            if (target2 instanceof JComponent) {
                JComponent jComponent = (JComponent)target2;
                cursor = (Cursor)jComponent.getClientProperty(PREPROCESSED_CURSOR_KEY);
                jComponent.putClientProperty(PREPROCESSED_CURSOR_KEY, null);
            }
            cursor = cursor == null ? lastCursor : cursor;
            UIUtil.setCursor((Component)target2, (Cursor)cursor);
        }
    }

    private static boolean canProcessCursorFor(Component target2) {
        return !(target2 instanceof JMenuItem) && !(target2 instanceof Divider) && !(target2 instanceof JSeparator) && (!(target2 instanceof JEditorPane) || !(((JEditorPane)target2).getEditorKit() instanceof HTMLEditorKit));
    }

    private static Component getCompWithCursor(Component c) {
        for (Component eachParentWithCursor = c; eachParentWithCursor != null; eachParentWithCursor = eachParentWithCursor.getParent()) {
            if (!eachParentWithCursor.isCursorSet()) continue;
            return eachParentWithCursor;
        }
        return null;
    }

    private void restoreLastComponent(Component newC) {
        if (this.myLastCursorComponent != null && this.myLastCursorComponent != newC) {
            IdeGlassPaneImpl.resetCursor(this.myLastCursorComponent, this.myLastOriginalCursor);
        }
    }

    public static boolean hasPreProcessedCursor(@NotNull JComponent component2) {
        return component2.getClientProperty(PREPROCESSED_CURSOR_KEY) != null;
    }

    public static boolean savePreProcessedCursor(@NotNull JComponent component2, @NotNull Cursor cursor) {
        if (IdeGlassPaneImpl.hasPreProcessedCursor(component2)) {
            return false;
        }
        component2.putClientProperty(PREPROCESSED_CURSOR_KEY, cursor);
        return true;
    }

    public void setCursor(Cursor cursor, @NotNull Object requestor) {
        if (cursor == null) {
            this.myListener2Cursor.remove(requestor);
        } else {
            this.myListener2Cursor.put(requestor, cursor);
        }
    }

    private static void fireMouseEvent(MouseListener listener2, MouseEvent event) {
        switch (event.getID()) {
            case 501: {
                listener2.mousePressed(event);
                break;
            }
            case 502: {
                listener2.mouseReleased(event);
                break;
            }
            case 504: {
                listener2.mouseEntered(event);
                break;
            }
            case 505: {
                listener2.mouseExited(event);
                break;
            }
            case 500: {
                listener2.mouseClicked(event);
            }
        }
    }

    private static void fireMouseMotion(@NotNull MouseMotionListener listener2, @NotNull MouseEvent event) {
        switch (event.getID()) {
            case 506: {
                listener2.mouseDragged(event);
            }
            case 503: {
                listener2.mouseMoved(event);
            }
        }
    }

    public void addMousePreprocessor(@NotNull MouseListener listener2, @NotNull Disposable parent) {
        this._addListener(listener2, parent);
    }

    public void addMouseMotionPreprocessor(@NotNull MouseMotionListener listener2, @NotNull Disposable parent) {
        this._addListener(listener2, parent);
    }

    private void _addListener(@NotNull EventListener listener2, @NotNull Disposable parent) {
        this.myMouseListeners.add(listener2);
        Disposer.register((Disposable)parent, () -> UIUtil.invokeLaterIfNeeded(() -> this.removeListener(listener2)));
        this.updateSortedList();
        this.activateIfNeeded();
    }

    public void removeMouseMotionPreprocessor(@NotNull MouseMotionListener listener2) {
        this.removeListener(listener2);
    }

    private void removeListener(@NotNull EventListener listener2) {
        if (this.myMouseListeners.remove(listener2)) {
            this.updateSortedList();
        }
        this.deactivateIfNeeded();
    }

    private void updateSortedList() {
        this.mySortedMouseListeners.clear();
        this.mySortedMouseListeners.addAll(this.myMouseListeners);
    }

    private void deactivateIfNeeded() {
        if (this.myPreprocessorActive && this.myMouseListeners.isEmpty()) {
            this.myPreprocessorActive = false;
        }
        this.applyActivationState();
    }

    private void activateIfNeeded() {
        if (!this.myPreprocessorActive && !this.myMouseListeners.isEmpty()) {
            this.myPreprocessorActive = true;
        }
        this.applyActivationState();
    }

    private void applyActivationState() {
        IdeEventQueue queue;
        boolean hasWork;
        boolean wasVisible = this.isVisible();
        boolean bl = hasWork = this.getPainters().hasPainters() || this.getComponentCount() > 0;
        if (wasVisible != hasWork) {
            this.setVisible(hasWork);
        }
        if (!(queue = IdeEventQueue.getInstance()).containsDispatcher(this) && (this.myPreprocessorActive || this.isVisible())) {
            queue.addDispatcher(this, null);
        } else if (queue.containsDispatcher(this) && !this.myPreprocessorActive && !this.isVisible()) {
            queue.removeDispatcher(this);
        }
        if (wasVisible != this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    @NotNull
    PaintersHelper getNamedPainters(@NotNull String name) {
        return this.myNamedPainters.computeIfAbsent(name, key -> new PaintersHelper(this));
    }

    @NotNull
    private PaintersHelper getPainters() {
        return this.getNamedPainters("glass");
    }

    public void addPainter(@Nullable Component component2, @NotNull Painter painter, @NotNull Disposable parent) {
        this.getPainters().addPainter(painter, component2);
        this.activateIfNeeded();
        Disposer.register((Disposable)parent, () -> SwingUtilities.invokeLater(() -> this.removePainter(painter)));
    }

    private void removePainter(@NotNull Painter painter) {
        this.getPainters().removePainter(painter);
        this.deactivateIfNeeded();
    }

    @Override
    protected void addImpl(Component comp, Object constraints2, int index) {
        super.addImpl(comp, constraints2, index);
        SwingUtilities.invokeLater(() -> this.activateIfNeeded());
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        SwingUtilities.invokeLater(() -> this.deactivateIfNeeded());
    }

    @Override
    public boolean isInModalContext() {
        for (Component component2 : this.getComponents()) {
            if (!(component2 instanceof GlassPaneDialogWrapperPeer.TransparentLayeredPane)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.getPainters().paint(g);
    }

    public Component getTargetComponentFor(MouseEvent e) {
        Component candidate = IdeGlassPaneImpl.findComponent(e, this.myRootPane.getLayeredPane());
        if (candidate != null) {
            return candidate;
        }
        candidate = IdeGlassPaneImpl.findComponent(e, this.myRootPane.getContentPane());
        if (candidate != null) {
            return candidate;
        }
        return e.getComponent();
    }

    private static Component findComponent(MouseEvent e, Container container2) {
        Point lpPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), container2);
        return SwingUtilities.getDeepestComponentAt(container2, lpPoint.x, lpPoint.y);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return !this.getPainters().hasPainters() && super.isOptimizedDrawingEnabled();
    }

    private static /* synthetic */ boolean lambda$preprocess$2(Component comp) {
        return UIUtil.isClientPropertyTrue((Object)comp, (Object)UIUtil.TEXT_COPY_ROOT);
    }
}

