/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CachedFileType {
    private static final ConcurrentMap<FileType, CachedFileType> ourInterner = new ConcurrentHashMap<FileType, CachedFileType>();
    @Nullable
    private FileType fileType;

    private CachedFileType(@NotNull FileType fileType) {
        this.fileType = fileType;
    }

    @Nullable
    FileType getUpToDateOrNull() {
        return this.fileType;
    }

    static CachedFileType forType(@NotNull FileType fileType) {
        return ourInterner.computeIfAbsent(fileType, CachedFileType::new);
    }

    public static void clearCache() {
        ourInterner.forEach((type, cachedType) -> {
            cachedType.fileType = null;
        });
        ourInterner.clear();
    }

    public static void remove(@NotNull FileType type) {
        CachedFileType cached = (CachedFileType)ourInterner.remove(type);
        if (cached != null) {
            cached.fileType = null;
        }
    }

    static final class PsiListener
    implements PsiModificationTracker.Listener {
        PsiListener() {
        }

        public void modificationCountChanged() {
            CachedFileType.clearCache();
        }
    }
}

