/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VfsImplUtil {
    private static final Logger LOG = Logger.getInstance(VfsImplUtil.class);
    private static final String FILE_SEPARATORS = "/" + (File.separatorChar == '/' ? "" : File.separator);
    private static final AtomicBoolean ourSubscribed = new AtomicBoolean(false);
    private static final Object ourLock = new Object();
    private static final Map<String, Pair<ArchiveFileSystem, ArchiveHandler>> ourHandlerCache = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
    private static final Map<String, Set<String>> ourDominatorsMap = new THashMap(FileUtil.PATH_HASHING_STRATEGY);

    private VfsImplUtil() {
    }

    @Nullable
    public static NewVirtualFile findFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        Pair<NewVirtualFile, Iterable<String>> data2 = VfsImplUtil.prepare(vfs, path);
        if (data2 == null) {
            return null;
        }
        NewVirtualFile file2 = (NewVirtualFile)data2.first;
        for (String pathElement : (Iterable)data2.second) {
            NewVirtualFile canonicalFile;
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            file2 = "..".equals(pathElement) ? (file2.is(VFileProperty.SYMLINK) ? ((canonicalFile = file2.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : file2.getParent()) : file2.findChild(pathElement);
            if (file2 != null) continue;
            return null;
        }
        return file2;
    }

    @Nullable
    public static NewVirtualFile findFileByPathIfCached(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        return (NewVirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)vfs, (String)path).first;
    }

    @NotNull
    public static Pair<NewVirtualFile, NewVirtualFile> findCachedFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        Pair<NewVirtualFile, Iterable<String>> data2 = VfsImplUtil.prepare(vfs, path);
        if (data2 == null) {
            return Pair.empty();
        }
        NewVirtualFile file2 = (NewVirtualFile)data2.first;
        for (String pathElement : (Iterable)data2.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            NewVirtualFile last = file2;
            if ("..".equals(pathElement)) {
                if (file2.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file2.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? (NewVirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)vfs, (String)canonicalPath).first : null;
                    file2 = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file2 = file2.getParent();
                }
            } else {
                file2 = file2.findChildIfCached(pathElement);
            }
            if (file2 != null) continue;
            return Pair.pair(null, (Object)last);
        }
        return Pair.pair((Object)file2, null);
    }

    @Nullable
    public static NewVirtualFile refreshAndFindFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        Pair<NewVirtualFile, Iterable<String>> data2 = VfsImplUtil.prepare(vfs, path);
        if (data2 == null) {
            return null;
        }
        NewVirtualFile file2 = (NewVirtualFile)data2.first;
        for (String pathElement : (Iterable)data2.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (file2.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file2.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? VfsImplUtil.refreshAndFindFileByPath(vfs, canonicalPath) : null;
                    file2 = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file2 = file2.getParent();
                }
            } else {
                file2 = file2.refreshAndFindChild(pathElement);
            }
            if (file2 != null) continue;
            return null;
        }
        return file2;
    }

    @Nullable
    private static Pair<NewVirtualFile, Iterable<String>> prepare(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        String normalizedPath = vfs.normalize(path);
        if (StringUtil.isEmptyOrSpaces((String)normalizedPath)) {
            return null;
        }
        String basePath = vfs.extractRootPath(normalizedPath);
        if (StringUtil.isEmptyOrSpaces((String)basePath) || basePath.length() > normalizedPath.length()) {
            LOG.warn(vfs + " has extracted incorrect root '" + basePath + "' from '" + normalizedPath + "' (original '" + path + "')");
            return null;
        }
        NewVirtualFile root = ManagingFS.getInstance().findRoot(basePath, vfs);
        if (root == null || !root.exists()) {
            return null;
        }
        Iterable parts = StringUtil.tokenize((String)normalizedPath.substring(basePath.length()), (String)FILE_SEPARATORS);
        return Pair.pair((Object)root, (Object)parts);
    }

    public static void refresh(@NotNull NewVirtualFileSystem vfs, boolean asynchronous) {
        VirtualFile[] roots = ManagingFS.getInstance().getRoots(vfs);
        if (roots.length > 0) {
            RefreshQueue.getInstance().refresh(asynchronous, true, null, roots);
        }
    }

    public static void forceSyncRefresh(@NotNull VirtualFile file2) {
        RefreshQueue.getInstance().processSingleEvent((VFileEvent)new VFileContentChangeEvent(null, file2, file2.getModificationStamp(), -1L, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T extends ArchiveHandler> T getHandler(@NotNull ArchiveFileSystem vfs, @NotNull VirtualFile entryFile, @NotNull Function<? super String, ? extends T> producer) {
        ArchiveHandler handler2;
        String localPath = vfs.extractLocalPath(VfsUtilCore.getRootFile((VirtualFile)entryFile).getPath());
        VfsImplUtil.checkSubscription();
        Object object = ourLock;
        synchronized (object) {
            ArchiveHandler t;
            Pair record = ourHandlerCache.get(localPath);
            if (record == null) {
                handler2 = (ArchiveHandler)producer.fun((Object)localPath);
                record = Pair.pair((Object)vfs, (Object)handler2);
                ourHandlerCache.put(localPath, (Pair<ArchiveFileSystem, ArchiveHandler>)record);
                VfsImplUtil.forEachDirectoryComponent(localPath, containingDirectoryPath -> {
                    Set handlers = ourDominatorsMap.computeIfAbsent((String)containingDirectoryPath, __ -> new THashSet());
                    handlers.add(localPath);
                });
            }
            handler2 = t = (ArchiveHandler)record.second;
        }
        return (T)handler2;
    }

    private static void forEachDirectoryComponent(@NotNull String rootPath, @NotNull Consumer<? super String> consumer) {
        int index = rootPath.lastIndexOf(47);
        while (index > 0) {
            String containingDirectoryPath = rootPath.substring(0, index);
            consumer.accept(containingDirectoryPath);
            index = rootPath.lastIndexOf(47, index - 1);
        }
    }

    private static void checkSubscription() {
        if (ourSubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDisposed()) {
            return;
        }
        MessageBusConnection connection = app.getMessageBus().connect((Disposable)app);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                InvalidationState state = null;
                Object object = ourLock;
                synchronized (object) {
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
                        String path = vFileEvent.getPath();
                        VirtualFile file2 = vFileEvent.getFile();
                        if (file2 == null || !file2.isDirectory()) {
                            state = VfsImplUtil.invalidate(state, path);
                            continue;
                        }
                        ArrayList affectedPaths = (ArrayList)ourDominatorsMap.get(path);
                        if (affectedPaths == null) continue;
                        affectedPaths = new ArrayList(affectedPaths);
                        for (String affectedPath : affectedPaths) {
                            state = VfsImplUtil.invalidate(state, affectedPath);
                        }
                    }
                }
                if (state != null) {
                    state.scheduleRefresh();
                }
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Object object = ourLock;
                synchronized (object) {
                    ourHandlerCache.clear();
                }
            }
        });
    }

    @Nullable
    private static InvalidationState invalidate(@Nullable InvalidationState state, @NotNull String path) {
        Pair<ArchiveFileSystem, ArchiveHandler> handlerPair = ourHandlerCache.remove(path);
        if (handlerPair != null) {
            ((ArchiveHandler)handlerPair.second).dispose();
            VfsImplUtil.forEachDirectoryComponent(path, containingDirectoryPath -> {
                Set<String> handlers = ourDominatorsMap.get(containingDirectoryPath);
                if (handlers != null && handlers.remove(path) && handlers.isEmpty()) {
                    ourDominatorsMap.remove(containingDirectoryPath);
                }
            });
            if (state == null) {
                state = new InvalidationState();
            }
            state.registerPathToRefresh(path, (ArchiveFileSystem)handlerPair.first);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseHandler(@NotNull String localPath) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        Object object = ourLock;
        synchronized (object) {
            InvalidationState state = VfsImplUtil.invalidate(null, localPath);
            if (state == null) {
                throw new IllegalArgumentException(localPath + " not in " + ourHandlerCache.keySet());
            }
        }
    }

    @NotNull
    public static List<VFileDeleteEvent> getJarInvalidationEvents(@NotNull VFileEvent event, @NotNull List<? super Runnable> outApplyActions) {
        if (!(event instanceof VFileDeleteEvent || event instanceof VFileMoveEvent || event instanceof VFilePropertyChangeEvent && "name".equals(((VFilePropertyChangeEvent)event).getPropertyName()))) {
            return Collections.emptyList();
        }
        String path = event instanceof VFilePropertyChangeEvent ? ((VFilePropertyChangeEvent)event).getOldPath() : (event instanceof VFileMoveEvent ? ((VFileMoveEvent)event).getOldPath() : event.getPath());
        VirtualFile file2 = event.getFile();
        if (file2 == null) {
            return Collections.emptyList();
        }
        List<String> jarPaths = (List<String>)((Object)ourDominatorsMap.get(path));
        if (jarPaths == null) {
            jarPaths = Collections.singletonList(path);
        }
        ArrayList<VFileDeleteEvent> events = new ArrayList<VFileDeleteEvent>(jarPaths.size());
        for (String jarPath : jarPaths) {
            Pair<ArchiveFileSystem, ArchiveHandler> handlerPair = ourHandlerCache.get(jarPath);
            if (handlerPair == null) continue;
            ArchiveFileSystem fileSystem = (ArchiveFileSystem)handlerPair.first;
            NewVirtualFile root = ManagingFS.getInstance().findRoot(fileSystem.composeRootPath(jarPath), (NewVirtualFileSystem)fileSystem);
            if (root == null) continue;
            VFileDeleteEvent jarDeleteEvent = new VFileDeleteEvent(event.getRequestor(), (VirtualFile)root, event.isFromRefresh());
            Runnable runnable2 = () -> {
                Pair<ArchiveFileSystem, ArchiveHandler> pair = ourHandlerCache.remove(jarPath);
                if (pair != null) {
                    ((ArchiveHandler)pair.second).dispose();
                    VfsImplUtil.forEachDirectoryComponent(jarPath, containingDirectoryPath -> {
                        Set<String> handlers = ourDominatorsMap.get(containingDirectoryPath);
                        if (handlers != null && handlers.remove(jarPath) && handlers.isEmpty()) {
                            ourDominatorsMap.remove(containingDirectoryPath);
                        }
                    });
                }
            };
            events.add(jarDeleteEvent);
            outApplyActions.add(runnable2);
        }
        return events;
    }

    private static class InvalidationState {
        private Set<Pair<String, ArchiveFileSystem>> myRootsToRefresh;

        private InvalidationState() {
        }

        private void registerPathToRefresh(@NotNull String path, @NotNull ArchiveFileSystem vfs) {
            if (this.myRootsToRefresh == null) {
                this.myRootsToRefresh = new HashSet<Pair<String, ArchiveFileSystem>>();
            }
            this.myRootsToRefresh.add((Pair<String, ArchiveFileSystem>)Pair.pair((Object)path, (Object)vfs));
        }

        private void scheduleRefresh() {
            if (this.myRootsToRefresh != null) {
                List rootsToRefresh = ContainerUtil.mapNotNull(this.myRootsToRefresh, pathAndFs -> ManagingFS.getInstance().findRoot(((ArchiveFileSystem)pathAndFs.second).composeRootPath((String)pathAndFs.first), (NewVirtualFileSystem)pathAndFs.second));
                for (NewVirtualFile root : rootsToRefresh) {
                    root.markDirtyRecursively();
                }
                boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                RefreshQueue.getInstance().refresh(async, true, null, (Collection)rootsToRefresh);
            }
        }
    }
}

