/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

final class WatchRootsUtil {
    WatchRootsUtil() {
    }

    static boolean isCoveredRecursively(@NotNull NavigableSet<String> recursiveRoots, @NotNull String path) {
        String recursiveRoot = recursiveRoots.floor(path);
        return recursiveRoot != null && OSAgnosticPathUtil.startsWith((String)path, (String)recursiveRoot);
    }

    static <T> void collectByPrefix(@NotNull NavigableMap<String, T> paths, @NotNull String prefix, @NotNull Consumer<Map.Entry<String, T>> collector) {
        for (Map.Entry entry : paths.tailMap(prefix, false).entrySet()) {
            if (!OSAgnosticPathUtil.startsWith((String)((String)entry.getKey()), (String)prefix)) break;
            collector.accept(entry);
        }
    }

    static void insertRecursivePath(@NotNull NavigableSet<String> recursiveRoots, @NotNull String path) {
        if (!WatchRootsUtil.isCoveredRecursively(recursiveRoots, path)) {
            String higher;
            recursiveRoots.add(path);
            while ((higher = recursiveRoots.higher(path)) != null && OSAgnosticPathUtil.startsWith((String)higher, (String)path)) {
                recursiveRoots.remove(higher);
            }
        }
    }

    static void forEachPathSegment(@NotNull String path, char separator, @NotNull Predicate<String> consumer) {
        int position = path.indexOf(separator);
        int length = path.length();
        while (position >= 0 && position < length) {
            String subPath = path.substring(0, position);
            if (!consumer.test(subPath)) {
                return;
            }
            position = path.indexOf(separator, position + 1);
        }
        consumer.test(path);
    }

    @NotNull
    static NavigableSet<String> optimizeFlatRoots(@NotNull Collection<String> flatRoots, @NotNull NavigableSet<String> recursiveRoots, boolean convertToForwardSlashes) {
        NavigableSet<String> result2 = WatchRootsUtil.createFileNavigableSet();
        if (convertToForwardSlashes) {
            for (String flatRoot : flatRoots) {
                if (WatchRootsUtil.isCoveredRecursively(recursiveRoots, flatRoot = flatRoot.replace('/', '\\'))) continue;
                result2.add(flatRoot);
            }
        } else {
            for (String flatRoot : flatRoots) {
                if (WatchRootsUtil.isCoveredRecursively(recursiveRoots, flatRoot)) continue;
                result2.add(flatRoot);
            }
        }
        return result2;
    }

    @NotNull
    static NavigableSet<String> createFileNavigableSet() {
        return new TreeSet<String>(OSAgnosticPathUtil.COMPARATOR);
    }

    @NotNull
    static <T> NavigableMap<String, T> createFileNavigableMap() {
        return new TreeMap(OSAgnosticPathUtil.COMPARATOR);
    }

    @NotNull
    static NavigableSet<Pair<String, String>> createMappingsNavigableSet() {
        return new TreeSet<Pair<String, String>>((a, b) -> OSAgnosticPathUtil.COMPARATOR.compare(a.first, b.first));
    }

    static boolean removeRecursivePath(@NotNull NavigableSet<String> optimizedRecursiveRoots, @NotNull NavigableMap<String, ?> sourceRecursiveRoots, @NotNull String path) {
        if (!optimizedRecursiveRoots.remove(path)) {
            return false;
        }
        Ref lastPathRef = new Ref();
        WatchRootsUtil.collectByPrefix(sourceRecursiveRoots, path, entry -> {
            String lastPath = (String)lastPathRef.get();
            String childPath = (String)entry.getKey();
            if (lastPath == null || !OSAgnosticPathUtil.startsWith((String)childPath, (String)lastPath)) {
                optimizedRecursiveRoots.add(childPath);
                lastPathRef.set((Object)childPath);
            }
        });
        return true;
    }
}

