/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.FilePartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;

class VirtualFilePointerImpl
extends TraceableDisposable
implements VirtualFilePointer {
    private static final Logger LOG = Logger.getInstance(VirtualFilePointerImpl.class);
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    volatile FilePartNode myNode;
    private int useCount;
    boolean recursive;
    final VirtualFilePointerListener myListener;

    VirtualFilePointerImpl(VirtualFilePointerListener listener2) {
        super(TRACE_CREATION);
        this.myListener = listener2;
    }

    @NotNull
    public String getFileName() {
        FilePartNode node = this.checkDisposed(this.myNode);
        if (node == null) {
            return "";
        }
        Object result2 = node.myFileOrUrl;
        if (result2 instanceof VirtualFile) {
            return ((VirtualFile)result2).getName();
        }
        String url = (String)result2;
        int index = url.lastIndexOf(47);
        return index >= 0 ? url.substring(index + 1) : url;
    }

    public VirtualFile getFile() {
        FilePartNode node = this.checkDisposed(this.myNode);
        if (node == null) {
            return null;
        }
        return FilePartNode.myFile(node.myFileOrUrl);
    }

    @NotNull
    public String getUrl() {
        FilePartNode node = this.myNode;
        if (node == null) {
            return "";
        }
        return FilePartNode.myUrl(node.myFileOrUrl);
    }

    @NotNull
    public String getPresentableUrl() {
        return PathUtil.toPresentableUrl((String)this.getUrl());
    }

    private FilePartNode checkDisposed(FilePartNode node) {
        if (node == null) {
            ProgressManager.checkCanceled();
            LOG.error("Already disposed: URL='" + (Object)((Object)this) + "'");
        }
        return node;
    }

    public boolean isValid() {
        FilePartNode node = this.myNode;
        return node != null && FilePartNode.myFile(node.myFileOrUrl) != null;
    }

    public String toString() {
        FilePartNode node = this.myNode;
        return node == null ? "(disposed)" : FilePartNode.myUrl(node.myFileOrUrl);
    }

    public void dispose() {
        boolean shouldKill;
        VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
        if (pointerManager instanceof VirtualFilePointerManagerImpl) {
            shouldKill = ((VirtualFilePointerManagerImpl)pointerManager).decrementUsageCount(this);
        } else {
            boolean bl = shouldKill = this.incrementUsageCount(-1) == 0;
        }
        if (shouldKill) {
            this.kill("URL when die: " + (Object)((Object)this));
        }
    }

    int incrementUsageCount(int delta) {
        return this.useCount += delta;
    }

    boolean isRecursive() {
        return this.recursive;
    }
}

