/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.annotations.Attribute;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileManagerImpl
extends VirtualFileManagerEx
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(VirtualFileManagerImpl.class);
    private static final ExtensionPointImpl<VirtualFileManagerListener> MANAGER_LISTENER_EP = ((ExtensionsAreaImpl)ApplicationManager.getApplication().getExtensionArea()).getExtensionPoint("com.intellij.virtualFileManagerListener");
    private final List<? extends VirtualFileSystem> myPreCreatedFileSystems;
    private final KeyedExtensionCollector<VirtualFileSystem, String> myCollector = new KeyedExtensionCollector("com.intellij.virtualFileSystem");
    private final EventDispatcher<VirtualFileListener> myVirtualFileListenerMulticaster = EventDispatcher.create(VirtualFileListener.class);
    private final List<VirtualFileManagerListener> myVirtualFileManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<AsyncFileListener> myAsyncFileListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myRefreshCount;

    public VirtualFileManagerImpl(@NotNull List<? extends VirtualFileSystem> preCreatedFileSystems) {
        this(preCreatedFileSystems, ApplicationManager.getApplication().getMessageBus());
    }

    public VirtualFileManagerImpl(@NotNull List<? extends VirtualFileSystem> preCreatedFileSystems, @NotNull MessageBus bus) {
        this.myPreCreatedFileSystems = new ArrayList<VirtualFileSystem>(preCreatedFileSystems);
        for (VirtualFileSystem virtualFileSystem : preCreatedFileSystems) {
            this.myCollector.addExplicitExtension((Object)virtualFileSystem.getProtocol(), (Object)virtualFileSystem);
            if (virtualFileSystem instanceof CachingVirtualFileSystem) continue;
            virtualFileSystem.addVirtualFileListener((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster());
        }
        if (LOG.isDebugEnabled() && !ApplicationInfoImpl.isInStressTest()) {
            this.addVirtualFileListener(new LoggingListener());
        }
        bus.connect().subscribe(VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster()));
    }

    @NotNull
    public List<VirtualFileSystem> getPhysicalFileSystems() {
        ArrayList<VirtualFileSystem> physicalFileSystems = new ArrayList<VirtualFileSystem>(this.myPreCreatedFileSystems);
        ExtensionPoint point = this.myCollector.getPoint();
        if (point != null) {
            for (KeyedLazyInstance bean : point.getExtensionList()) {
                if (!((VirtualFileSystemBean)bean).physical) continue;
                VirtualFileSystem fileSystem = (VirtualFileSystem)bean.getInstance();
                physicalFileSystems.add(fileSystem);
            }
        }
        return physicalFileSystems;
    }

    public void dispose() {
    }

    public long getStructureModificationCount() {
        return 0L;
    }

    @Nullable
    public VirtualFileSystem getFileSystem(@Nullable String protocol) {
        if (protocol == null) {
            return null;
        }
        List systems = this.myCollector.forKey((Object)protocol);
        return this.selectFileSystem(protocol, systems);
    }

    @Nullable
    protected VirtualFileSystem selectFileSystem(@NotNull String protocol, @NotNull List<? extends VirtualFileSystem> candidates) {
        int size = candidates.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            LOG.error(protocol + ": " + candidates);
        }
        return candidates.get(0);
    }

    public long syncRefresh() {
        return this.doRefresh(false, null);
    }

    public long asyncRefresh(@Nullable Runnable postAction) {
        return this.doRefresh(true, postAction);
    }

    protected long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        for (VirtualFileSystem fileSystem : this.getPhysicalFileSystems()) {
            if (fileSystem instanceof CachingVirtualFileSystem) continue;
            fileSystem.refresh(asynchronous);
        }
        return 0L;
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        for (VirtualFileSystem fileSystem : this.getPhysicalFileSystems()) {
            if (fileSystem instanceof CachingVirtualFileSystem) {
                ((CachingVirtualFileSystem)fileSystem).refreshWithoutFileWatcher(asynchronous);
                continue;
            }
            fileSystem.refresh(asynchronous);
        }
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener2);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2, @NotNull Disposable parentDisposable) {
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        this.myVirtualFileListenerMulticaster.removeListener((EventListener)listener2);
    }

    public void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2) {
        this.myVirtualFileManagerListeners.add(listener2);
    }

    public void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.addVirtualFileManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeVirtualFileManagerListener(listener2));
    }

    public void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2) {
        this.myVirtualFileManagerListeners.remove(listener2);
    }

    public void addAsyncFileListener(@NotNull AsyncFileListener listener2, @NotNull Disposable parentDisposable) {
        this.myAsyncFileListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myAsyncFileListeners.remove(listener2));
    }

    @ApiStatus.Internal
    public void addAsyncFileListenersTo(@NotNull List<? super AsyncFileListener> listeners) {
        listeners.addAll(this.myAsyncFileListeners);
    }

    public void notifyPropertyChanged(@NotNull VirtualFile virtualFile, @VirtualFile.PropName @NotNull String property, Object oldValue, Object newValue2) {
        Application app = ApplicationManager.getApplication();
        ((AppUIExecutor)AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().expireWith((Disposable)app)).submit(() -> {
            if (virtualFile.isValid()) {
                WriteAction.run(() -> {
                    List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent((Object)this, virtualFile, property, oldValue, newValue2, false));
                    BulkFileListener listener2 = (BulkFileListener)app.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                    listener2.before(events);
                    listener2.after(events);
                });
            }
        });
    }

    @Override
    public void fireBeforeRefreshStart(boolean asynchronous) {
        if (this.myRefreshCount++ != 0) {
            return;
        }
        for (VirtualFileManagerListener listener3 : this.myVirtualFileManagerListeners) {
            try {
                listener3.beforeRefreshStart(asynchronous);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        ExtensionProcessingHelper.forEachExtensionSafe(MANAGER_LISTENER_EP, listener2 -> listener2.beforeRefreshStart(asynchronous));
    }

    @Override
    public void fireAfterRefreshFinish(boolean asynchronous) {
        if (--this.myRefreshCount != 0) {
            return;
        }
        for (VirtualFileManagerListener listener3 : this.myVirtualFileManagerListeners) {
            try {
                listener3.afterRefreshFinish(asynchronous);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        ExtensionProcessingHelper.forEachExtensionSafe(MANAGER_LISTENER_EP, listener2 -> listener2.afterRefreshFinish(asynchronous));
    }

    public long getModificationCount() {
        return 0L;
    }

    public int storeName(@NotNull String name) {
        throw new AbstractMethodError();
    }

    @NotNull
    public CharSequence getVFileName(int nameId) {
        throw new AbstractMethodError();
    }

    public VirtualFile findFileByUrl(@NotNull String url) {
        VirtualFileSystem fileSystem;
        int protocolSepIndex = url.indexOf("://");
        VirtualFileSystem virtualFileSystem = fileSystem = protocolSepIndex < 0 ? null : this.getFileSystem(url.substring(0, protocolSepIndex));
        if (fileSystem == null) {
            return null;
        }
        String path = url.substring(protocolSepIndex + "://".length());
        return fileSystem.findFileByPath(path);
    }

    public VirtualFile refreshAndFindFileByUrl(@NotNull String url) {
        VirtualFileSystem fileSystem;
        int protocolSepIndex = url.indexOf("://");
        VirtualFileSystem virtualFileSystem = fileSystem = protocolSepIndex < 0 ? null : this.getFileSystem(url.substring(0, protocolSepIndex));
        if (fileSystem == null) {
            return null;
        }
        String path = url.substring(protocolSepIndex + "://".length());
        return fileSystem.refreshAndFindFileByPath(path);
    }

    @Nullable
    public VirtualFile findFileByNioPath(@NotNull Path path) {
        if (!FileSystems.getDefault().equals(path.getFileSystem())) {
            return null;
        }
        VirtualFileSystem fileSystem = this.getFileSystem("file");
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.findFileByPath(path.toString());
    }

    @Nullable
    public VirtualFile refreshAndFindFileByNioPath(@NotNull Path path) {
        if (!FileSystems.getDefault().equals(path.getFileSystem())) {
            return null;
        }
        VirtualFileSystem fileSystem = this.getFileSystem("file");
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.refreshAndFindFileByPath(path.toString());
    }

    private static class LoggingListener
    implements VirtualFileListener {
        private LoggingListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            LOG.debug("propertyChanged: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            LOG.debug("contentsChanged: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            LOG.debug("fileCreated: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            LOG.debug("fileDeleted: file = " + event.getFile() + ", parent = " + event.getParent() + ", requestor = " + event.getRequestor());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            LOG.debug("fileMoved: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            LOG.debug("fileCopied: file = " + event.getFile() + ", originalFile = " + event.getOriginalFile() + ", requestor = " + event.getRequestor());
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            LOG.debug("beforeContentsChange: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            LOG.debug("beforePropertyChange: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            LOG.debug("beforeFileDeletion: file = " + event.getFile() + ", requestor = " + event.getRequestor());
            LOG.assertTrue(event.getFile().isValid());
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            LOG.debug("beforeFileMovement: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }
    }

    private static class VirtualFileSystemBean
    extends KeyedLazyInstanceEP<VirtualFileSystem> {
        @Attribute
        public boolean physical;

        private VirtualFileSystemBean() {
        }
    }
}

