/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ui.EmptyIcon;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseFileEncodingAction
extends ComboBoxAction {
    private final VirtualFile myVirtualFile;
    public static final Charset NO_ENCODING = new Charset("NO_ENCODING", null){

        @Override
        public boolean contains(Charset cs) {
            return false;
        }

        @Override
        public CharsetDecoder newDecoder() {
            return null;
        }

        @Override
        public CharsetEncoder newEncoder() {
            return null;
        }
    };

    protected ChooseFileEncodingAction(@Nullable VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public abstract void update(@NotNull AnActionEvent var1);

    private void fillCharsetActions(@NotNull DefaultActionGroup group, final @Nullable VirtualFile virtualFile, @NotNull List<? extends Charset> charsets, final @NotNull Function<? super Charset, String> charsetFilter) {
        for (final Charset charset : charsets) {
            CharsetAction action2 = new CharsetAction(charset.displayName(), null, EmptyIcon.ICON_16){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ChooseFileEncodingAction.this.chosen(virtualFile, charset);
                }

                public void update(@NotNull AnActionEvent e) {
                    Icon defer;
                    super.update(e);
                    String description = (String)charsetFilter.fun((Object)charset);
                    if (virtualFile == null || virtualFile.isDirectory()) {
                        defer = null;
                    } else {
                        VolatileNotNullLazyValue myText = VolatileNotNullLazyValue.createValue(() -> LoadTextUtil.loadText(virtualFile));
                        VolatileNotNullLazyValue myBytes = VolatileNotNullLazyValue.createValue(() -> {
                            try {
                                return virtualFile.contentsToByteArray();
                            }
                            catch (IOException e1) {
                                return ArrayUtilRt.EMPTY_BYTE_ARRAY;
                            }
                        });
                        defer = IconDeferrer.getInstance().defer(null, (Object)Pair.create((Object)virtualFile, (Object)charset), arg_0 -> 1.lambda$update$2((NotNullLazyValue)myText, (NotNullLazyValue)myBytes, arg_0));
                    }
                    e.getPresentation().setIcon(defer);
                    e.getPresentation().setDescription(description);
                }

                private static /* synthetic */ Icon lambda$update$2(NotNullLazyValue myText, NotNullLazyValue myBytes, Pair pair) {
                    VirtualFile myFile = (VirtualFile)pair.getFirst();
                    Charset charset2 = (Charset)pair.getSecond();
                    CharSequence text = (CharSequence)myText.getValue();
                    byte[] bytes = (byte[])myBytes.getValue();
                    EncodingUtil.Magic8 safeToReload = EncodingUtil.isSafeToReloadIn(myFile, text, bytes, charset2);
                    EncodingUtil.Magic8 safeToConvert = EncodingUtil.Magic8.ABSOLUTELY;
                    if (safeToReload != EncodingUtil.Magic8.ABSOLUTELY) {
                        safeToConvert = EncodingUtil.isSafeToConvertTo(myFile, text, bytes, charset2);
                    }
                    return safeToReload == EncodingUtil.Magic8.ABSOLUTELY || safeToConvert == EncodingUtil.Magic8.ABSOLUTELY ? null : (safeToReload == EncodingUtil.Magic8.WELL_IF_YOU_INSIST || safeToConvert == EncodingUtil.Magic8.WELL_IF_YOU_INSIST ? AllIcons.General.Warning : AllIcons.General.Error);
                }
            };
            group.add((AnAction)action2);
        }
    }

    protected abstract void chosen(@Nullable VirtualFile var1, @NotNull Charset var2);

    @NotNull
    protected DefaultActionGroup createCharsetsActionGroup(@Nullable String clearItemText, @Nullable Charset alreadySelected, @NotNull Function<? super Charset, String> charsetFilter) {
        DefaultActionGroup group = new DefaultActionGroup();
        ArrayList favorites = new ArrayList(EncodingManager.getInstance().getFavorites());
        Collections.sort(favorites);
        Charset current2 = this.myVirtualFile == null ? null : this.myVirtualFile.getCharset();
        favorites.remove(current2);
        favorites.remove(alreadySelected);
        if (clearItemText != null) {
            String description = this.myVirtualFile == null ? IdeBundle.message((String)"action.clear.encoding.description", (Object[])new Object[0]) : IdeBundle.message((String)"action.clear.encoding.description.file", (Object[])new Object[]{this.myVirtualFile.getName()});
            group.add((AnAction)new DumbAwareAction(clearItemText, description, null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ChooseFileEncodingAction.this.chosen(ChooseFileEncodingAction.this.myVirtualFile, NO_ENCODING);
                }
            });
        }
        if (favorites.isEmpty() && clearItemText == null) {
            this.fillCharsetActions(group, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), charsetFilter);
        } else {
            this.fillCharsetActions(group, this.myVirtualFile, favorites, charsetFilter);
            DefaultActionGroup more = DefaultActionGroup.createPopupGroup(() -> IdeBundle.message((String)"action.text.more", (Object[])new Object[0]));
            group.add((AnAction)more);
            this.fillCharsetActions(more, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), charsetFilter);
        }
        return group;
    }

    private static abstract class CharsetAction
    extends DumbAwareAction
    implements LightEditCompatible {
        CharsetAction(String name, String description, Icon icon2) {
            super(name, description, icon2);
        }
    }
}

