/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.util.Alarm;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class ZipperUpdater {
    private final Alarm myAlarm;
    private boolean myRaised;
    private final Object myLock = new Object();
    private final int myDelay;
    private final Alarm.ThreadToUse myThreadToUse;

    public ZipperUpdater(int delay, @NotNull Disposable parentDisposable) {
        this(delay, Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
    }

    public ZipperUpdater(int delay, Alarm.ThreadToUse threadToUse, @NotNull Disposable parentDisposable) {
        this.myDelay = delay;
        this.myThreadToUse = threadToUse;
        this.myAlarm = new Alarm(threadToUse, parentDisposable);
    }

    public void queue(@NotNull Runnable runnable2) {
        this.queue(runnable2, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(final @NotNull Runnable runnable2, boolean urgent, boolean anyModality) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myAlarm.isDisposed()) {
                return;
            }
            boolean wasRaised = this.myRaised;
            this.myRaised = true;
            if (!wasRaised) {
                Runnable request2 = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ZipperUpdater.this.myLock;
                        synchronized (object) {
                            if (!ZipperUpdater.this.myRaised) {
                                return;
                            }
                            ZipperUpdater.this.myRaised = false;
                        }
                        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)ZipperUpdater.this.myAlarm, runnable2);
                    }

                    public String toString() {
                        return runnable2.toString();
                    }
                };
                this.addRequest(request2, urgent, anyModality);
            }
        }
    }

    private void addRequest(@NotNull Runnable request2, boolean urgent, boolean anyModality) {
        int delay;
        int n = delay = urgent ? 0 : this.myDelay;
        if (Alarm.ThreadToUse.SWING_THREAD.equals((Object)this.myThreadToUse)) {
            if (anyModality) {
                this.myAlarm.addRequest(request2, delay, ModalityState.any());
            } else if (!ApplicationManager.getApplication().isDispatchThread()) {
                this.myAlarm.addRequest(request2, delay, ModalityState.NON_MODAL);
            } else {
                this.myAlarm.addRequest(request2, delay);
            }
        } else {
            this.myAlarm.addRequest(request2, delay);
        }
    }

    public void stop() {
        this.myAlarm.cancelAllRequests();
    }

    public void waitForAllExecuted(long timeout, @NotNull TimeUnit unit) {
        try {
            this.myAlarm.waitForAllExecuted(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }
}

