/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.WindowStateBean;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WindowStateAdapter
extends WindowAdapter
implements ComponentListener {
    private final WindowStateBean myWindowState = new WindowStateBean();

    @NotNull
    static WindowStateBean getState(@NotNull Window window) {
        return WindowStateAdapter.getAdapter((Window)window).myWindowState;
    }

    @NotNull
    private static WindowStateAdapter getAdapter(@NotNull Window window) {
        for (ComponentListener listener2 : window.getComponentListeners()) {
            if (!(listener2 instanceof WindowStateAdapter)) continue;
            return (WindowStateAdapter)listener2;
        }
        return new WindowStateAdapter(window);
    }

    private WindowStateAdapter(@NotNull Window window) {
        this.myWindowState.applyFrom(window);
        window.addComponentListener(this);
        window.addWindowListener(this);
        window.addWindowStateListener(this);
    }

    @Override
    public void windowOpened(WindowEvent event) {
        this.update(event);
    }

    @Override
    public void windowStateChanged(WindowEvent event) {
        this.update(event);
    }

    @Override
    public void componentMoved(ComponentEvent event) {
        this.update(event);
    }

    @Override
    public void componentResized(ComponentEvent event) {
        this.update(event);
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    private void update(@Nullable ComponentEvent event) {
        Object source;
        Object object = source = event == null ? null : event.getSource();
        if (source instanceof Window) {
            this.myWindowState.applyFrom((Window)source);
        }
    }
}

