/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class AssertFocused
extends AbstractCommand {
    public static final String PREFIX = "%assert focused";

    public AssertFocused(String text, int line) {
        super(text, line);
    }

    @Override
    protected Promise<Object> _execute(PlaybackContext context) {
        String text = this.getText().substring(PREFIX.length()).trim();
        LinkedHashMap<String, String> expected = new LinkedHashMap<String, String>();
        if (text.length() > 0) {
            String[] keyValue;
            for (String each : keyValue = text.split(",")) {
                String[] eachPair = each.split("=");
                if (eachPair.length != 2) {
                    String error = "Syntax error, must be comma-separated pairs key=value";
                    context.error(error, this.getLine());
                    return Promises.rejectedPromise((String)error);
                }
                expected.put(eachPair[0], eachPair[1]);
            }
        }
        AsyncPromise result2 = new AsyncPromise();
        IdeFocusManager.findInstance().doWhenFocusSettlesDown(() -> {
            try {
                this.doAssert(expected, context);
                result2.setResult(null);
            }
            catch (AssertionError error) {
                context.error("Assertion failed: " + ((Throwable)((Object)error)).getMessage(), this.getLine());
                result2.setError((Throwable)((Object)error));
            }
        });
        return result2;
    }

    private void doAssert(Map<String, String> expected, PlaybackContext context) throws AssertionError {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            throw new AssertionError((Object)"No component focused");
        }
        LinkedHashMap actual = new LinkedHashMap();
        for (Component eachParent = owner; eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof Queryable)) continue;
            ((Queryable)eachParent).putInfo(actual);
        }
        LinkedHashSet<String> testedKeys = new LinkedHashSet<String>();
        for (String string : expected.keySet()) {
            testedKeys.add(string);
            String actualValue = (String)actual.get(string);
            String expectedValue = expected.get(string);
            if (!expectedValue.equals(actualValue)) {
                throw new AssertionError((Object)(string + " expected: " + expectedValue + " but was: " + actualValue));
            }
        }
        HashMap untested = new HashMap();
        for (String eachKey : actual.keySet()) {
            if (testedKeys.contains(eachKey)) continue;
            untested.put(eachKey, actual.get(eachKey));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String each : untested.keySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(each).append("=").append((String)untested.get(each));
        }
        context.message("Untested info: " + stringBuilder, this.getLine());
    }
}

